/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import java.util.ArrayList;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.expr.Numeric;
import org.apache.fop.fo.expr.PropertyException;

public class MixedLength
extends Length {
    private ArrayList lengths;

    public MixedLength(ArrayList lengths) {
        this.lengths = lengths;
    }

    protected void computeValue() {
        int computedValue = 0;
        boolean bAllComputed = true;
        int i = 0;
        while (i < this.lengths.size()) {
            Length l = (Length)this.lengths.get(i);
            computedValue += l.mvalue();
            if (!l.isComputed()) {
                bAllComputed = false;
            }
            ++i;
        }
        this.setComputedValue(computedValue, bAllComputed);
    }

    public double getTableUnits() {
        double tableUnits = 0.0;
        int i = 0;
        while (i < this.lengths.size()) {
            tableUnits += ((Length)this.lengths.get(i)).getTableUnits();
            ++i;
        }
        return tableUnits;
    }

    public void resolveTableUnit(double dTableUnit) {
        int i = 0;
        while (i < this.lengths.size()) {
            ((Length)this.lengths.get(i)).resolveTableUnit(dTableUnit);
            ++i;
        }
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < this.lengths.size()) {
            if (sbuf.length() > 0) {
                sbuf.append('+');
            }
            sbuf.append(this.lengths.get(i).toString());
            ++i;
        }
        return sbuf.toString();
    }

    public Numeric asNumeric() {
        Numeric numeric = null;
        int i = 0;
        while (i < this.lengths.size()) {
            Length l = (Length)this.lengths.get(i);
            if (numeric == null) {
                numeric = l.asNumeric();
            } else {
                try {
                    Numeric sum;
                    numeric = sum = numeric.add(l.asNumeric());
                }
                catch (PropertyException pe) {
                    System.err.println("Can't convert MixedLength to Numeric: " + pe);
                }
            }
            ++i;
        }
        return numeric;
    }
}

