/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.trax;

import java.io.IOException;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.joost.stx.Parser;
import net.sf.joost.stx.Processor;
import net.sf.joost.trace.DebugProcessor;
import net.sf.joost.trax.TrAXConstants;
import net.sf.joost.trax.TransformerFactoryImpl;
import net.sf.joost.trax.TransformerImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TemplatesImpl
implements Templates,
TrAXConstants {
    private static Log log = LogFactory.getLog((Class)(class$net$sf$joost$trax$TemplatesImpl == null ? (class$net$sf$joost$trax$TemplatesImpl = TemplatesImpl.class$("net.sf.joost.trax.TemplatesImpl")) : class$net$sf$joost$trax$TemplatesImpl));
    protected TransformerFactoryImpl factory = null;
    private Processor processor = null;
    private Boolean reentryGuard = new Boolean(true);
    static /* synthetic */ Class class$net$sf$joost$trax$TemplatesImpl;

    protected TemplatesImpl(Parser parser, TransformerFactoryImpl transformerFactoryImpl) throws TransformerConfigurationException {
        this.factory = transformerFactoryImpl;
        try {
            this.init(parser);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            log.fatal((Object)transformerConfigurationException);
            throw transformerConfigurationException;
        }
    }

    protected TemplatesImpl(XMLReader xMLReader, InputSource inputSource, TransformerFactoryImpl transformerFactoryImpl) throws TransformerConfigurationException {
        this.factory = transformerFactoryImpl;
        try {
            this.init(xMLReader, inputSource);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerFactoryImpl.defaultErrorListener.fatalError(transformerConfigurationException);
        }
    }

    private void init(Parser parser) throws TransformerConfigurationException {
        try {
            boolean bl = (Boolean)this.factory.getAttribute("http://joost.sf.net/attributes/debug-feature");
            if (bl) {
                log.info((Object)"init transformer in debug mode");
                this.processor = new DebugProcessor(parser);
            } else {
                this.processor = new Processor(parser);
            }
            if (this.factory.thResolver != null) {
                this.processor.setTransformerHandlerResolver(this.factory.thResolver);
            }
        }
        catch (SAXException sAXException) {
            log.fatal((Object)sAXException);
            throw new TransformerConfigurationException(sAXException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            log.fatal((Object)nullPointerException);
            throw new TransformerConfigurationException("Could not found value for property javax.xml.parsers.SAXParser " + nullPointerException.getMessage());
        }
    }

    private void init(XMLReader xMLReader, InputSource inputSource) throws TransformerConfigurationException {
        try {
            boolean bl = (Boolean)this.factory.getAttribute("http://joost.sf.net/attributes/debug-feature");
            this.processor = bl ? new DebugProcessor(xMLReader, inputSource, this.factory.getErrorListener(), this.factory.getURIResolver(), this.factory.getParserListenerMgr(), this.factory.getMessageEmitter()) : new Processor(xMLReader, inputSource, this.factory.getErrorListener(), this.factory.getURIResolver());
            if (this.factory.thResolver != null) {
                this.processor.setTransformerHandlerResolver(this.factory.thResolver);
            }
        }
        catch (IOException iOException) {
            throw new TransformerConfigurationException(iOException.getMessage(), iOException);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception instanceof TransformerConfigurationException) {
                throw (TransformerConfigurationException)exception;
            }
            throw new TransformerConfigurationException(sAXException.getMessage(), sAXException);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace(System.err);
            throw new TransformerConfigurationException("could not found value for property javax.xml.parsers.SAXParser ", nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transformer newTransformer() throws TransformerConfigurationException {
        Boolean bl = this.reentryGuard;
        synchronized (bl) {
            TransformerImpl transformerImpl = new TransformerImpl(this.processor);
            return transformerImpl;
        }
    }

    public Properties getOutputProperties() {
        try {
            Transformer transformer = this.newTransformer();
            return transformer.getOutputProperties();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            try {
                this.factory.defaultErrorListener.fatalError(transformerConfigurationException);
            }
            catch (TransformerConfigurationException transformerConfigurationException2) {}
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

