/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.trace;

import java.util.TooManyListenersException;
import java.util.Vector;
import net.sf.joost.instruction.AbstractInstruction;
import net.sf.joost.stx.SAXEvent;
import net.sf.joost.trace.TraceListener;
import net.sf.joost.trax.TransformerImpl;

public class TraceManager {
    private TransformerImpl transformer;
    private Vector traceListeners = null;

    public TraceManager(TransformerImpl transformerImpl) {
        this.transformer = transformerImpl;
    }

    public boolean hasTraceListeners() {
        return this.traceListeners != null;
    }

    public void addTraceListener(TraceListener traceListener) throws TooManyListenersException {
        TransformerImpl.DEBUG_MODE = true;
        if (this.traceListeners == null) {
            this.traceListeners = new Vector();
        }
        this.traceListeners.addElement(traceListener);
    }

    public void removeTraceListener(TraceListener traceListener) {
        if (this.traceListeners != null) {
            this.traceListeners.removeElement(traceListener);
        }
    }

    public void fireStartSourceDocument() {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.startSourceDocument();
                ++n2;
            }
        }
    }

    public void fireEndSourceDocument() {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.endSourceDocument();
                ++n2;
            }
        }
    }

    public void fireStartSourceElement(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.startSourceElement(sAXEvent);
                ++n2;
            }
        }
    }

    public void fireEndSourceElement(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.endSourceElement(sAXEvent);
                ++n2;
            }
        }
    }

    public void fireSourceText(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.sourceText(sAXEvent);
                ++n2;
            }
        }
    }

    public void fireSourcePI(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.sourcePI(sAXEvent);
                ++n2;
            }
        }
    }

    public void fireSourceMapping(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.sourceMapping(sAXEvent);
                ++n2;
            }
        }
    }

    public void fireSourceComment(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.sourceComment(sAXEvent);
                ++n2;
            }
        }
    }

    public void fireEnterInstructionNode(AbstractInstruction abstractInstruction, SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.enterInstructionNode(abstractInstruction, sAXEvent);
                ++n2;
            }
        }
    }

    public void fireLeaveInstructionNode(AbstractInstruction abstractInstruction, SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.leaveInstructionNode(abstractInstruction, sAXEvent);
                ++n2;
            }
        }
    }

    public void fireStartResultDocument() {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.startResultDocument();
                ++n2;
            }
        }
    }

    public void fireEndResultDocument() {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.endResultDocument();
                ++n2;
            }
        }
    }

    public void fireStartResultElement(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.startResultElement(sAXEvent);
                ++n2;
            }
        }
    }

    public void fireEndResultElement(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.endResultElement(sAXEvent);
                ++n2;
            }
        }
    }

    public void fireResultText(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.resultText(sAXEvent);
                ++n2;
            }
        }
    }

    public void fireResultPI(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.resultPI(sAXEvent);
                ++n2;
            }
        }
    }

    public void fireResultComment(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.resultComment(sAXEvent);
                ++n2;
            }
        }
    }

    public void fireStartResultCDATA() {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.startResultCDATA();
                ++n2;
            }
        }
    }

    public void fireEndResultCDATA() {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(n2);
                traceListener.endResultCDATA();
                ++n2;
            }
        }
    }
}

