/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx;

import java.util.HashMap;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public final class SAXEvent {
    public static final int ROOT = 0;
    public static final int ELEMENT = 1;
    public static final int TEXT = 2;
    public static final int CDATA = 3;
    public static final int PI = 4;
    public static final int COMMENT = 5;
    public static final int ATTRIBUTE = 6;
    public static final int ELEMENT_END = 7;
    public static final int MAPPING = 8;
    public static final int MAPPING_END = 9;
    public int type;
    public String uri;
    public String lName;
    public String qName;
    public Attributes attrs;
    public Hashtable namespaces;
    public String value = "";
    public boolean hasChildNodes = false;
    private HashMap posHash;
    private static final DoubleString GENERIC_ELEMENT = new DoubleString("*", "*");
    private static final DoubleString GENERIC_PI = new DoubleString("pi()", "");

    private SAXEvent() {
    }

    public static SAXEvent newElement(String string, String string2, String string3, Attributes attributes, Hashtable hashtable) {
        SAXEvent sAXEvent = new SAXEvent();
        sAXEvent.type = attributes != null ? 1 : 7;
        sAXEvent.uri = string;
        sAXEvent.lName = string2;
        sAXEvent.qName = string3;
        if (attributes != null) {
            sAXEvent.attrs = attributes.getLength() != 0 ? new AttributesImpl(attributes) : new AttributesImpl();
        }
        sAXEvent.namespaces = hashtable;
        sAXEvent.hasChildNodes = false;
        sAXEvent.value = "";
        return sAXEvent;
    }

    public static SAXEvent newText(String string) {
        SAXEvent sAXEvent = new SAXEvent();
        sAXEvent.type = 2;
        sAXEvent.value = string;
        return sAXEvent;
    }

    public static SAXEvent newCDATA(String string) {
        SAXEvent sAXEvent = new SAXEvent();
        sAXEvent.type = 3;
        sAXEvent.value = string;
        return sAXEvent;
    }

    public static SAXEvent newRoot() {
        SAXEvent sAXEvent = new SAXEvent();
        sAXEvent.type = 0;
        sAXEvent.enableChildNodes(true);
        return sAXEvent;
    }

    public static SAXEvent newComment(String string) {
        SAXEvent sAXEvent = new SAXEvent();
        sAXEvent.type = 5;
        sAXEvent.value = string;
        return sAXEvent;
    }

    public static SAXEvent newPI(String string, String string2) {
        SAXEvent sAXEvent = new SAXEvent();
        sAXEvent.type = 4;
        sAXEvent.qName = string;
        sAXEvent.value = string2;
        return sAXEvent;
    }

    public static SAXEvent newAttribute(Attributes attributes, int n) {
        SAXEvent sAXEvent = new SAXEvent();
        sAXEvent.type = 6;
        sAXEvent.uri = attributes.getURI(n);
        sAXEvent.lName = attributes.getLocalName(n);
        sAXEvent.qName = attributes.getQName(n);
        sAXEvent.value = attributes.getValue(n);
        return sAXEvent;
    }

    public static SAXEvent newMapping(String string, String string2) {
        SAXEvent sAXEvent = new SAXEvent();
        sAXEvent.type = string2 != null ? 8 : 9;
        sAXEvent.qName = string;
        sAXEvent.value = string2;
        return sAXEvent;
    }

    public void enableChildNodes(boolean bl) {
        if (bl) {
            this.posHash = new HashMap();
            this.hasChildNodes = true;
        } else if (this.posHash == null) {
            this.posHash = new HashMap();
        }
    }

    public void countElement(String string, String string2) {
        Object[] objectArray = new Object[]{"node()", GENERIC_ELEMENT, new DoubleString(string, string2), new DoubleString("*", string2), new DoubleString(string, "*")};
        this._countPosition(objectArray);
    }

    public void countText() {
        Object[] objectArray = new String[]{"node()", "text()"};
        this._countPosition(objectArray);
    }

    public void countCDATA() {
        Object[] objectArray = new String[]{"node()", "text()", "cdata()"};
        this._countPosition(objectArray);
    }

    public void countComment() {
        Object[] objectArray = new String[]{"node()", "comment()"};
        this._countPosition(objectArray);
    }

    public void countPI(String string) {
        Object[] objectArray = new Object[]{"node()", GENERIC_PI, new DoubleString("pi()", string)};
        this._countPosition(objectArray);
    }

    private void _countPosition(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Counter counter = (Counter)this.posHash.get(objectArray[n]);
            if (counter == null) {
                this.posHash.put(objectArray[n], new Counter());
            } else {
                ++counter.value;
            }
            ++n;
        }
    }

    public long getPositionOf(String string, String string2) {
        Counter counter = (Counter)this.posHash.get(new DoubleString(string, string2));
        if (counter == null) {
            throw new NullPointerException();
        }
        return counter.value;
    }

    public long getPositionOfNode() {
        Counter counter = (Counter)this.posHash.get("node()");
        if (counter == null) {
            throw new NullPointerException();
        }
        return counter.value;
    }

    public long getPositionOfText() {
        Counter counter = (Counter)this.posHash.get("text()");
        if (counter == null) {
            throw new NullPointerException();
        }
        return counter.value;
    }

    public long getPositionOfCDATA() {
        Counter counter = (Counter)this.posHash.get("cdata()");
        if (counter == null) {
            throw new NullPointerException();
        }
        return counter.value;
    }

    public long getPositionOfComment() {
        Counter counter = (Counter)this.posHash.get("comment()");
        if (counter == null) {
            throw new NullPointerException();
        }
        return counter.value;
    }

    public long getPositionOfPI(String string) {
        Counter counter = (Counter)this.posHash.get(new DoubleString("pi()", string));
        if (counter == null) {
            throw new NullPointerException();
        }
        return counter.value;
    }

    public Object clone() {
        SAXEvent sAXEvent = new SAXEvent();
        sAXEvent.type = this.type;
        sAXEvent.qName = this.qName;
        return sAXEvent;
    }

    public String toString() {
        String string = "SAXEvent ";
        switch (this.type) {
            case 0: {
                return string + "/";
            }
            case 1: {
                return string + "<" + this.qName + ">";
            }
            case 7: {
                return string + "</" + this.qName + ">";
            }
            case 2: {
                return string + "`" + this.value + "'";
            }
            case 3: {
                return string + "<![CDATA[" + this.value + "]]>";
            }
            case 5: {
                return string + "<!--" + this.value + "-->";
            }
            case 4: {
                return string + "<?" + this.qName + " " + this.value + "?>";
            }
            case 6: {
                return string + this.qName + "='" + this.value + "'";
            }
            case 8: {
                return "xmlns:" + this.qName + "=" + this.value;
            }
        }
        return "SAXEvent ???";
    }

    private static final class DoubleString {
        private String s1;
        private String s2;
        private int hashValue;

        public DoubleString(String string, String string2) {
            this.s1 = string;
            this.s2 = string2;
            this.hashValue = string.hashCode() << 1 ^ string2.hashCode();
        }

        public int hashCode() {
            return this.hashValue;
        }

        public boolean equals(Object object) {
            if (!(object instanceof DoubleString)) {
                return false;
            }
            DoubleString doubleString = (DoubleString)object;
            return this.s1.equals(doubleString.s1) && this.s2.equals(doubleString.s2);
        }
    }

    private final class Counter {
        public long value = 1L;
    }
}

