/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import net.sf.joost.Constants;
import net.sf.joost.TransformerHandlerResolver;
import net.sf.joost.emitter.StxEmitter;
import net.sf.joost.grammar.EvalException;
import net.sf.joost.instruction.AbstractInstruction;
import net.sf.joost.instruction.GroupBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.instruction.PSiblingsFactory;
import net.sf.joost.instruction.ProcessBase;
import net.sf.joost.instruction.TemplateFactory;
import net.sf.joost.instruction.TransformFactory;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.Emitter;
import net.sf.joost.stx.ErrorHandlerImpl;
import net.sf.joost.stx.Parser;
import net.sf.joost.stx.ParserListener;
import net.sf.joost.stx.SAXEvent;
import net.sf.joost.stx.Value;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class Processor
extends XMLFilterImpl
implements Constants,
LexicalHandler {
    public static final byte PASS_THROUGH_NONE = 0;
    public static final byte PASS_THROUGH_ELEMENT = 1;
    public static final byte PASS_THROUGH_TEXT = 2;
    public static final byte PASS_THROUGH_COMMENT = 4;
    public static final byte PASS_THROUGH_PI = 8;
    public static final byte PASS_THROUGH_ATTRIBUTE = 16;
    public static final byte PASS_THROUGH_ALL = -1;
    private TransformFactory.Instance transformNode;
    private TemplateFactory.Instance[] globalTemplates;
    private Context context;
    private Emitter emitter;
    private int skipDepth = 0;
    private boolean insideCDATA = false;
    private boolean insideDTD = false;
    private StringBuffer collectedCharacters = new StringBuffer();
    private SAXEvent lastElement = null;
    private Hashtable inScopeNamespaces;
    private Stack namespaceContext = new Stack();
    private boolean nsContextActive = false;
    private Stack eventStack;
    private Stack innerProcStack = new Stack();
    public Properties outputProperties;
    private DataStack dataStack = new DataStack();
    private static Log log = LogFactory.getLog((Class)(class$net$sf$joost$stx$Processor == null ? (class$net$sf$joost$stx$Processor = Processor.class$("net.sf.joost.stx.Processor")) : class$net$sf$joost$stx$Processor));
    private static String PROP_PREFIX = "http://xml.org/sax/properties/";
    private int processStatus;
    static /* synthetic */ Class class$net$sf$joost$stx$Processor;
    static /* synthetic */ Class class$java$lang$Object;

    public Processor(InputSource inputSource, ErrorListener errorListener, URIResolver uRIResolver) throws IOException, SAXException {
        this(null, inputSource, errorListener, uRIResolver, null);
    }

    public Processor(InputSource inputSource) throws IOException, SAXException {
        this(null, inputSource, null, null, null);
    }

    public Processor(XMLReader xMLReader, InputSource inputSource, ErrorListener errorListener, URIResolver uRIResolver) throws IOException, SAXException {
        this(xMLReader, inputSource, errorListener, uRIResolver, null);
    }

    public Processor(XMLReader xMLReader, InputSource inputSource, ErrorListener errorListener, URIResolver uRIResolver, ParserListener parserListener) throws IOException, SAXException {
        if (xMLReader == null) {
            xMLReader = Processor.getXMLReader();
        }
        ErrorHandlerImpl errorHandlerImpl = new ErrorHandlerImpl(errorListener, true);
        Parser parser = new Parser();
        parser.setErrorHandler(errorHandlerImpl);
        parser.setURIResolver(uRIResolver);
        parser.setParserListener(parserListener);
        xMLReader.setContentHandler(parser);
        xMLReader.setErrorHandler(errorHandlerImpl);
        xMLReader.parse(inputSource);
        this.init(parser);
        this.setParent(xMLReader);
    }

    public Processor(Parser parser) throws SAXException {
        this.init(parser);
        this.setParent(Processor.getXMLReader());
    }

    public Processor(Processor processor) {
        this.transformNode = processor.transformNode;
        this.globalTemplates = processor.globalTemplates;
        this.dataStack.push(processor.dataStack.elementAt(0));
        this.context = processor.context.copy();
        this.setParent(processor.getParent());
    }

    /*
     * Unable to fully structure code
     */
    public static XMLReader getXMLReader() throws SAXException {
        block7: {
            var0 = null;
            try {
                var0 = XMLReaderFactory.createXMLReader();
                break block7;
            }
            catch (SAXException var1_1) {
                var2_2 = System.getProperty("org.xml.sax.driver");
                if (var2_2 != null) {
                    throw new SAXException("Can't create XMLReader for class " + var2_2);
                }
                var3_3 = new String[]{"org.apache.xerces.parsers.SAXParser", "org.apache.crimson.parser.XMLReaderImpl", "gnu.xml.aelfred2.SAXDriver"};
                var4_4 = 0;
                ** while (var4_4 < var3_3.length)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var0 = XMLReaderFactory.createXMLReader(var3_3[var4_4]);
                    break;
                }
                catch (SAXException var5_5) {
                    ++var4_4;
                }
                continue;
            }
lbl18:
            // 2 sources

            if (var0 == null) {
                throw new SAXException("Can't find SAX parser implementation.\nPlease specify a parser class via the system property 'org.xml.sax.driver'");
            }
        }
        return var0;
    }

    protected void init(Parser parser) throws SAXException {
        this.context = new Context();
        this.emitter = this.context.emitter = this.initializeEmitter(this.context, parser);
        this.eventStack = this.context.ancestorStack;
        this.setErrorHandler(this.context.errorHandler);
        this.context.currentProcessor = this;
        this.transformNode = parser.getTransformNode();
        this.context.targetGroup = this.transformNode;
        this.context.currentGroup = this.transformNode;
        this.dataStack.push(new Data(this.context));
        this.inScopeNamespaces = new Hashtable();
        this.inScopeNamespaces.put("xml", "http://www.w3.org/XML/1998/namespace");
        Vector vector = this.transformNode.getGlobalTemplates();
        this.globalTemplates = new TemplateFactory.Instance[vector.size()];
        vector.toArray(this.globalTemplates);
        Arrays.sort(this.globalTemplates);
        this.initOutputProperties();
    }

    protected Emitter initializeEmitter(Context context, Parser parser) {
        return new Emitter(context.errorHandler);
    }

    public void initOutputProperties() {
        this.outputProperties = new Properties();
        this.outputProperties.setProperty("encoding", this.transformNode.outputEncoding);
        this.outputProperties.setProperty("media-type", "text/xml");
        this.outputProperties.setProperty("method", this.transformNode.outputMethod);
        this.outputProperties.setProperty("omit-xml-declaration", "no");
        this.outputProperties.setProperty("standalone", "no");
        this.outputProperties.setProperty("version", "1.0");
    }

    public void setParent(XMLReader xMLReader) {
        super.setParent(xMLReader);
        xMLReader.setContentHandler(this);
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXException sAXException) {
            log.warn((Object)("Accessing " + xMLReader + ": " + sAXException));
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.emitter.setContentHandler(contentHandler);
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.emitter.setLexicalHandler(lexicalHandler);
    }

    public void setDeclHandler(DeclHandler declHandler) {
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ((PROP_PREFIX + "lexical-handler").equals(string)) {
            this.setLexicalHandler((LexicalHandler)object);
        } else if ((PROP_PREFIX + "declaration-handler").equals(string)) {
            this.setDeclHandler((DeclHandler)object);
        } else {
            super.setProperty(string, object);
        }
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.context.errorHandler.errorListener = errorListener;
    }

    public String getOutputEncoding() {
        return this.transformNode.outputEncoding;
    }

    public void setParameter(String string, Object object) {
        if (!string.startsWith("{")) {
            string = "{}" + string;
        }
        this.transformNode.globalParams.put(string, new Value(object));
    }

    public Object getParameter(String string) {
        if (!string.startsWith("{")) {
            string = "{}" + string;
        }
        Value value = (Value)this.transformNode.globalParams.get(string);
        try {
            if (value != null) {
                return value.toJavaObject(class$java$lang$Object == null ? (class$java$lang$Object = Processor.class$("java.lang.Object")) : class$java$lang$Object);
            }
        }
        catch (EvalException evalException) {
            log.fatal((Object)evalException);
        }
        return null;
    }

    public void clearParameters() {
        this.transformNode.globalParams.clear();
    }

    public void setTransformerHandlerResolver(TransformerHandlerResolver transformerHandlerResolver) {
        this.context.defaultTransformerHandlerResolver.customResolver = transformerHandlerResolver;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.context.uriResolver = uRIResolver;
    }

    public void setMessageEmitter(StxEmitter stxEmitter) {
        this.context.messageEmitter = stxEmitter;
    }

    public void startInnerProcessing() throws SAXException {
        this.innerProcStack.push(this.collectedCharacters.toString());
        this.collectedCharacters.setLength(0);
        this.dataStack.push(new Data(5, null, null, null, this.context));
    }

    public void endInnerProcessing() throws SAXException {
        this.clearProcessSiblings();
        this.context.localVars = this.dataStack.pop().localVars;
        this.collectedCharacters.append(this.innerProcStack.pop());
    }

    private boolean foundUnprocessedTemplate(TemplateFactory.Instance instance) {
        int n = this.dataStack.size() - 1;
        while (n >= 0) {
            Data data = this.dataStack.elementAt(n);
            if (data.lastProcStatus == 2) {
                if (data.template == instance) {
                    return false;
                }
            } else {
                return true;
            }
            --n;
        }
        return true;
    }

    private TemplateFactory.Instance findMatchingTemplate() throws SAXException {
        TemplateFactory.Instance instance = null;
        TemplateFactory.Instance[] instanceArray = null;
        int n = -1;
        Data data = this.dataStack.peek();
        boolean bl = data.lastProcStatus != 2;
        TemplateFactory.Instance[][] instanceArrayArray = new TemplateFactory.Instance[][]{((Data)data).targetGroup.visibleTemplates, ((Data)data).targetGroup.groupTemplates, this.globalTemplates};
        int n2 = 0;
        while (n2 < instanceArrayArray.length && instanceArray == null) {
            int n3 = 0;
            while (n3 < instanceArrayArray[n2].length) {
                if (instanceArrayArray[n2][n3].matches(this.context, true) && (bl || this.foundUnprocessedTemplate(instanceArrayArray[n2][n3]))) {
                    instanceArray = instanceArrayArray[n2];
                    n = n3;
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        if (instanceArray != null) {
            instance = instanceArray[n];
            double d = instance.getPriority();
            if (++n < instanceArray.length && d == instanceArray[n].getPriority()) {
                while (n < instanceArray.length && d == instanceArray[n].getPriority()) {
                    if (instanceArray[n].matches(this.context, false)) {
                        this.context.errorHandler.error("Ambigous template rule with priority " + d + ", found matching template rule already in line " + instance.lineNo, instanceArray[n].publicId, instanceArray[n].systemId, instanceArray[n].lineNo, instanceArray[n].colNo);
                    }
                    ++n;
                }
            }
        }
        return instance;
    }

    /*
     * Unable to fully structure code
     */
    private AbstractInstruction doProcessLoop(AbstractInstruction var1_1, SAXEvent var2_2, boolean var3_3) throws SAXException {
        this.processStatus = 0;
        while (var1_1 != null && this.processStatus == 0) {
            block3: {
                if (!this.getClass().equals(Processor.class$net$sf$joost$stx$Processor == null ? Processor.class$("net.sf.joost.stx.Processor") : Processor.class$net$sf$joost$stx$Processor)) ** GOTO lbl11
                while (var1_1 != null && this.processStatus == 0) {
                    this.processStatus = var1_1.process(this.context);
                    var1_1 = var1_1.next;
                }
                break block3;
lbl-1000:
                // 1 sources

                {
                    this.processStatus = var3_3 != false && var1_1.getNode() instanceof ProcessBase != false ? (int)var1_1.process(this.context) : this.processInstruction(var1_1, var2_2);
                    var1_1 = var1_1.next;
lbl11:
                    // 2 sources

                    ** while (var1_1 != null && this.processStatus == 0)
                }
            }
            if (this.processStatus != 4) continue;
            this.processAttributes(var2_2.attrs);
            this.processStatus = 0;
        }
        return var1_1;
    }

    protected int processInstruction(AbstractInstruction abstractInstruction, SAXEvent sAXEvent) throws SAXException {
        return abstractInstruction.process(this.context);
    }

    private void processEvent() throws SAXException {
        block40: {
            SAXEvent sAXEvent;
            block39: {
                TemplateFactory.Instance instance;
                sAXEvent = (SAXEvent)this.eventStack.peek();
                if (this.dataStack.peek().lastProcStatus == 3) {
                    this.processSiblings();
                }
                if ((instance = this.findMatchingTemplate()) == null) break block39;
                AbstractInstruction abstractInstruction = instance;
                this.context.localVars.clear();
                Hashtable hashtable = this.context.passedParameters;
                abstractInstruction = this.doProcessLoop(abstractInstruction, sAXEvent, false);
                switch (this.processStatus) {
                    case 0: {
                        if (sAXEvent.type == 1 || sAXEvent.type == 0) {
                            this.skipDepth = 1;
                            this.collectedCharacters.setLength(0);
                        }
                        break block40;
                    }
                    case 1: {
                        this.dataStack.push(new Data(1, instance, abstractInstruction, hashtable, this.context));
                        if (this.context.targetHandler != null) {
                            this.startExternDocument();
                            if (this.collectedCharacters.length() > 0) {
                                this.context.targetHandler.characters(this.collectedCharacters.toString().toCharArray(), 0, this.collectedCharacters.length());
                                this.collectedCharacters.setLength(0);
                            }
                            this.skipDepth = 1;
                        }
                        break block40;
                    }
                    case 2: {
                        this.dataStack.push(new Data(2, instance, abstractInstruction, hashtable, this.context));
                        if (this.context.targetHandler != null) {
                            switch (sAXEvent.type) {
                                case 1: {
                                    this.startExternDocument();
                                    this.context.targetHandler.startElement(sAXEvent.uri, sAXEvent.lName, sAXEvent.qName, sAXEvent.attrs);
                                    this.skipDepth = 1;
                                    break;
                                }
                                case 2: {
                                    this.startExternDocument();
                                    this.context.targetHandler.characters(sAXEvent.value.toCharArray(), 0, sAXEvent.value.length());
                                    this.endExternDocument();
                                    break;
                                }
                                case 3: {
                                    this.startExternDocument();
                                    this.context.targetHandler.startCDATA();
                                    this.context.targetHandler.characters(sAXEvent.value.toCharArray(), 0, sAXEvent.value.length());
                                    this.context.targetHandler.endCDATA();
                                    this.endExternDocument();
                                    break;
                                }
                                case 4: {
                                    this.startExternDocument();
                                    this.context.targetHandler.processingInstruction(sAXEvent.qName, sAXEvent.value);
                                    this.endExternDocument();
                                    break;
                                }
                                case 5: {
                                    this.startExternDocument();
                                    this.context.targetHandler.comment(sAXEvent.value.toCharArray(), 0, sAXEvent.value.length());
                                    this.endExternDocument();
                                    break;
                                }
                                case 0: {
                                    this.context.targetHandler.startDocument();
                                    this.skipDepth = 1;
                                    break;
                                }
                                case 6: {
                                    break;
                                }
                                default: {
                                    log.error((Object)("Unexpected event: " + sAXEvent));
                                    break;
                                }
                            }
                        } else {
                            this.processEvent();
                        }
                        if (sAXEvent.type == 2 || sAXEvent.type == 3 || sAXEvent.type == 5 || sAXEvent.type == 4 || sAXEvent.type == 6) {
                            this.dataStack.pop();
                            abstractInstruction = this.doProcessLoop(abstractInstruction, sAXEvent, false);
                            switch (this.processStatus) {
                                case 1: 
                                case 2: {
                                    NodeBase nodeBase = abstractInstruction.getNode();
                                    this.context.errorHandler.error("Encountered `" + nodeBase.qName + "' after stx:process-self", nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
                                }
                                case -1: {
                                    throw new SAXException("Non-recoverable error");
                                }
                                case 3: {
                                    this.dataStack.push(new Data(3, instance, abstractInstruction, hashtable, this.context, sAXEvent));
                                }
                            }
                        }
                        break block40;
                    }
                    case 3: {
                        if (sAXEvent.type == 1 || sAXEvent.type == 0) {
                            this.skipDepth = 1;
                            this.collectedCharacters.setLength(0);
                        }
                        this.dataStack.push(new Data(3, instance, abstractInstruction, hashtable, this.context, sAXEvent));
                        break block40;
                    }
                    case -1: {
                        throw new SAXException("Non-recoverable error");
                    }
                    default: {
                        log.error((Object)("Unexpected return value from process() " + this.processStatus));
                        throw new SAXException("Unexpected return value from process() " + this.processStatus);
                    }
                }
            }
            GroupBase groupBase = this.context.targetGroup;
            switch (sAXEvent.type) {
                case 0: {
                    this.dataStack.push(new Data(this.dataStack.peek()));
                    break;
                }
                case 1: {
                    if ((groupBase.passThrough & 1) != 0) {
                        this.emitter.startElement(sAXEvent.uri, sAXEvent.lName, sAXEvent.qName, sAXEvent.attrs, sAXEvent.namespaces, groupBase.publicId, groupBase.systemId, groupBase.lineNo, groupBase.colNo);
                    }
                    this.dataStack.push(new Data(this.dataStack.peek()));
                    break;
                }
                case 2: {
                    if ((groupBase.passThrough & 2) == 0) break;
                    this.emitter.characters(sAXEvent.value.toCharArray(), 0, sAXEvent.value.length());
                    break;
                }
                case 3: {
                    if ((groupBase.passThrough & 2) == 0) break;
                    this.emitter.startCDATA(groupBase.publicId, groupBase.systemId, groupBase.lineNo, groupBase.colNo);
                    this.emitter.characters(sAXEvent.value.toCharArray(), 0, sAXEvent.value.length());
                    this.emitter.endCDATA();
                    break;
                }
                case 5: {
                    if ((groupBase.passThrough & 4) == 0) break;
                    this.emitter.comment(sAXEvent.value.toCharArray(), 0, sAXEvent.value.length(), groupBase.publicId, groupBase.systemId, groupBase.lineNo, groupBase.colNo);
                    break;
                }
                case 4: {
                    if ((groupBase.passThrough & 8) == 0) break;
                    this.emitter.processingInstruction(sAXEvent.qName, sAXEvent.value, groupBase.publicId, groupBase.systemId, groupBase.lineNo, groupBase.colNo);
                    break;
                }
                case 6: {
                    if ((groupBase.passThrough & 0x10) == 0) break;
                    this.emitter.addAttribute(sAXEvent.uri, sAXEvent.qName, sAXEvent.lName, sAXEvent.value, groupBase.publicId, groupBase.systemId, groupBase.lineNo, groupBase.colNo);
                    break;
                }
                default: {
                    log.warn((Object)("no default action for " + sAXEvent));
                }
            }
        }
    }

    private void processLastElement(boolean bl) throws SAXException {
        String string = this.collectedCharacters.toString();
        if (string.length() == 0 || this.context.targetGroup.stripSpace && string.trim().length() == 0) {
            if (bl) {
                this.lastElement.enableChildNodes(true);
            }
        } else {
            this.lastElement.value = string;
            this.lastElement.enableChildNodes(true);
        }
        ((SAXEvent)this.eventStack.peek()).countElement(this.lastElement.uri, this.lastElement.lName);
        this.eventStack.push(this.lastElement);
        this.lastElement = null;
        this.processEvent();
    }

    private void processCharacters() throws SAXException {
        SAXEvent sAXEvent;
        String string = this.collectedCharacters.toString();
        if (this.skipDepth > 0 && this.context.targetHandler != null) {
            if (this.insideCDATA) {
                this.context.targetHandler.startCDATA();
                this.context.targetHandler.characters(string.toCharArray(), 0, string.length());
                this.context.targetHandler.endCDATA();
            } else {
                this.context.targetHandler.characters(string.toCharArray(), 0, string.length());
            }
            this.collectedCharacters.setLength(0);
            return;
        }
        if (this.context.targetGroup.stripSpace && string.trim().length() == 0) {
            this.collectedCharacters.setLength(0);
            return;
        }
        if (this.insideCDATA) {
            ((SAXEvent)this.eventStack.peek()).countCDATA();
            sAXEvent = SAXEvent.newCDATA(string);
        } else {
            ((SAXEvent)this.eventStack.peek()).countText();
            sAXEvent = SAXEvent.newText(string);
        }
        this.eventStack.push(sAXEvent);
        this.processEvent();
        this.eventStack.pop();
        this.collectedCharacters.setLength(0);
    }

    private void processAttributes(Attributes attributes) throws SAXException {
        Object object;
        this.dataStack.push(new Data(4, null, null, null, this.context));
        int n = 0;
        while (n < attributes.getLength()) {
            object = SAXEvent.newAttribute(attributes, n);
            this.eventStack.push(object);
            this.processEvent();
            this.eventStack.pop();
            ++n;
        }
        object = this.dataStack.pop();
        this.context.position = ((Data)object).contextPosition;
        this.context.currentGroup = ((Data)object).currentGroup;
        this.context.localVars = ((Data)object).localVars;
    }

    private void processSiblings() throws SAXException {
        Data data;
        int n = 0;
        do {
            int n2 = this.dataStack.size() - 1;
            Data data2 = this.dataStack.peek();
            Hashtable hashtable = this.context.localVars;
            data = null;
            do {
                this.context.localVars = data2.localVars;
                if (data2.psiblings.matches(this.context)) continue;
                data = data2;
                n = n2;
            } while ((data2 = this.dataStack.elementAt(--n2)).lastProcStatus == 3);
            this.context.localVars = hashtable;
            if (data == null) continue;
            this.clearProcessSiblings(data, false);
        } while (data != null && this.dataStack.size() == n + 1 && this.dataStack.peek().lastProcStatus == 3);
    }

    private void clearProcessSiblings() throws SAXException {
        Data data;
        Data data2 = null;
        int n = this.dataStack.size() - 1;
        while ((data = this.dataStack.elementAt(n)).lastProcStatus == 3) {
            data2 = data;
            --n;
        }
        if (data2 != null) {
            this.clearProcessSiblings(data2, true);
        }
    }

    private void clearProcessSiblings(Data data, boolean bl) throws SAXException {
        Data data2;
        Object e = null;
        e = !bl ? (Object)this.eventStack.pop() : (Object)this.eventStack.peek();
        Hashtable hashtable = this.context.localVars;
        do {
            data2 = this.dataStack.pop();
            this.eventStack.push(data2.sibEvent);
            this.context.position = data2.contextPosition;
            this.context.localVars = data2.localVars;
            AbstractInstruction abstractInstruction = data2.instruction;
            do {
                abstractInstruction = this.doProcessLoop(abstractInstruction, (SAXEvent)e, false);
                switch (this.processStatus) {
                    case 1: 
                    case 2: {
                        NodeBase nodeBase = abstractInstruction.getNode();
                        this.context.errorHandler.error("Encountered `" + nodeBase.qName + "' after stx:process-siblings", nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
                    }
                    case -1: {
                        throw new SAXException("Non-recoverable error");
                    }
                }
            } while (this.processStatus == 3 && (bl || data2 != data));
            if (this.processStatus == 3) {
                data.instruction = abstractInstruction;
                data.targetGroup = this.context.targetGroup;
                data.psiblings = this.context.psiblings;
                data.localVars = this.context.localVars;
                this.context.localVars = hashtable;
                this.dataStack.push(data);
            }
            this.eventStack.pop();
        } while (data2 != data);
        if (!bl) {
            this.eventStack.push(e);
        }
    }

    private void startExternDocument() throws SAXException {
        try {
            this.context.targetHandler.startDocument();
            Enumeration enumeration = this.inScopeNamespaces.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.equals("xml")) continue;
                this.context.targetHandler.startPrefixMapping(string, (String)this.inScopeNamespaces.get(string));
            }
        }
        catch (RuntimeException runtimeException) {
            StringWriter stringWriter = null;
            stringWriter = new StringWriter();
            runtimeException.printStackTrace(new PrintWriter(stringWriter));
            NodeBase nodeBase = this.context.currentInstruction;
            this.context.errorHandler.fatalError("External processing failed: " + stringWriter, nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
        }
    }

    private void endExternDocument() throws SAXException {
        try {
            Enumeration enumeration = this.inScopeNamespaces.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.equals("xml")) continue;
                this.context.targetHandler.endPrefixMapping(string);
            }
            this.context.targetHandler.endDocument();
            this.context.targetHandler = null;
        }
        catch (RuntimeException runtimeException) {
            StringWriter stringWriter = null;
            stringWriter = new StringWriter();
            runtimeException.printStackTrace(new PrintWriter(stringWriter));
            NodeBase nodeBase = this.context.currentInstruction;
            this.context.errorHandler.fatalError("External processing failed: " + stringWriter, nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
        }
    }

    public void startDocument() throws SAXException {
        if (this.innerProcStack.empty()) {
            this.transformNode.initGroupVariables(this.context);
            this.emitter.startDocument();
        } else {
            this.innerProcStack.push(this.eventStack);
            this.context.ancestorStack = this.eventStack = new Stack();
        }
        this.eventStack.push(SAXEvent.newRoot());
        this.processEvent();
    }

    public void endDocument() throws SAXException {
        if (this.collectedCharacters.length() != 0) {
            this.processCharacters();
        }
        if (this.skipDepth == 1 && this.context.targetHandler != null && this.dataStack.peek().lastProcStatus == 1) {
            this.skipDepth = 0;
            this.endExternDocument();
        }
        if (this.skipDepth == 0) {
            this.clearProcessSiblings();
            Data data = this.dataStack.pop();
            this.context.currentGroup = data.currentGroup;
            this.context.targetGroup = data.targetGroup;
            short s = data.lastProcStatus;
            if (data.template != null) {
                if (s == 1 || s == 2) {
                    this.context.position = data.contextPosition;
                    this.context.localVars = data.localVars;
                    AbstractInstruction abstractInstruction = data.instruction;
                    abstractInstruction = this.doProcessLoop(abstractInstruction, (SAXEvent)this.eventStack.peek(), true);
                    switch (this.processStatus) {
                        case 1: 
                        case 2: {
                            NodeBase nodeBase = abstractInstruction.getNode();
                            this.context.errorHandler.error("Encountered `" + nodeBase.qName + "' after stx:process-" + (s == 1 ? "children" : "self"), nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
                        }
                        case -1: {
                            throw new SAXException("Non-recoverable error");
                        }
                    }
                } else {
                    log.error((Object)("encountered 'else' " + s));
                }
            }
        } else {
            --this.skipDepth;
            if (this.skipDepth == 0 && this.context.targetHandler != null) {
                this.endExternDocument();
            }
        }
        if (this.skipDepth == 0) {
            if (this.dataStack.peek().lastProcStatus == 2) {
                this.endDocument();
            } else {
                this.eventStack.pop();
                if (this.innerProcStack.empty()) {
                    this.emitter.endDocument(this.transformNode.publicId, this.transformNode.systemId, this.transformNode.lineNo, this.transformNode.colNo);
                } else {
                    this.eventStack = this.context.ancestorStack = (Stack)this.innerProcStack.pop();
                }
            }
        } else {
            log.error((Object)("skipDepth at document end: " + this.skipDepth));
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.lastElement != null) {
            this.processLastElement(true);
        }
        if (this.collectedCharacters.length() != 0) {
            this.processCharacters();
        }
        if (this.skipDepth > 0) {
            ++this.skipDepth;
            if (this.context.targetHandler != null) {
                this.context.targetHandler.startElement(string, string2, string3, attributes);
            }
            return;
        }
        this.lastElement = SAXEvent.newElement(string, string2, string3, attributes, this.inScopeNamespaces);
        if (!this.nsContextActive) {
            this.namespaceContext.push(this.inScopeNamespaces);
            this.inScopeNamespaces = (Hashtable)this.inScopeNamespaces.clone();
        }
        this.nsContextActive = false;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.lastElement != null) {
            this.processLastElement(false);
        }
        if (this.collectedCharacters.length() != 0) {
            this.processCharacters();
        }
        if (this.skipDepth == 1 && this.context.targetHandler != null && this.dataStack.peek().lastProcStatus == 1) {
            this.skipDepth = 0;
            this.endExternDocument();
        }
        if (this.skipDepth == 0) {
            this.clearProcessSiblings();
            Data data = this.dataStack.pop();
            short s = data.lastProcStatus;
            this.context.currentGroup = data.currentGroup;
            this.context.targetGroup = this.dataStack.peek().targetGroup;
            if (data.template == null) {
                if ((((Data)data).targetGroup.passThrough & 1) != 0) {
                    this.emitter.endElement(string, string2, string3, ((Data)data).targetGroup.publicId, ((Data)data).targetGroup.systemId, ((Data)data).targetGroup.lineNo, ((Data)data).targetGroup.colNo);
                }
            } else if (s == 1 || s == 2) {
                this.context.position = data.contextPosition;
                this.context.localVars = data.localVars;
                Data data2 = this.dataStack.peek();
                AbstractInstruction abstractInstruction = data.instruction;
                abstractInstruction = this.doProcessLoop(abstractInstruction, (SAXEvent)this.eventStack.peek(), true);
                switch (this.processStatus) {
                    case 1: 
                    case 2: {
                        NodeBase nodeBase = abstractInstruction.getNode();
                        this.context.errorHandler.error("Encountered `" + nodeBase.qName + "' after stx:process-" + (s == 1 ? "children" : "self"), nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
                        throw new SAXException("Non-recoverable error");
                    }
                    case 3: {
                        this.dataStack.push(new Data(3, data.template, abstractInstruction, data.passedParams, this.context, (SAXEvent)this.eventStack.peek()));
                        break;
                    }
                    case -1: {
                        throw new SAXException("Non-recoverable error");
                    }
                }
            } else {
                log.error((Object)("encountered 'else' " + s));
            }
        } else {
            --this.skipDepth;
            if (this.context.targetHandler != null) {
                this.context.targetHandler.endElement(string, string2, string3);
                if (this.skipDepth == 0) {
                    this.endExternDocument();
                }
            }
        }
        if (this.skipDepth == 0) {
            if (this.dataStack.peek().lastProcStatus == 2) {
                this.endElement(string, string2, string3);
            } else {
                this.eventStack.pop();
                this.inScopeNamespaces = (Hashtable)this.namespaceContext.pop();
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.skipDepth > 0) {
            if (this.context.targetHandler != null) {
                this.context.targetHandler.characters(cArray, n, n2);
            }
            return;
        }
        this.collectedCharacters.append(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.insideDTD) {
            return;
        }
        if (this.lastElement != null) {
            this.processLastElement(true);
        }
        if (this.collectedCharacters.length() != 0) {
            this.processCharacters();
        }
        if (this.skipDepth > 0) {
            if (this.context.targetHandler != null) {
                this.context.targetHandler.processingInstruction(string, string2);
            }
            return;
        }
        ((SAXEvent)this.eventStack.peek()).countPI(string);
        this.eventStack.push(SAXEvent.newPI(string, string2));
        this.processEvent();
        this.eventStack.pop();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.lastElement != null) {
            this.processLastElement(true);
        }
        if (this.skipDepth > 0) {
            if (this.context.targetHandler != null) {
                this.context.targetHandler.startPrefixMapping(string, string2);
            }
            return;
        }
        if (!this.nsContextActive) {
            this.namespaceContext.push(this.inScopeNamespaces);
            this.inScopeNamespaces = (Hashtable)this.inScopeNamespaces.clone();
            this.nsContextActive = true;
        }
        if (string2.equals("")) {
            this.inScopeNamespaces.remove(string);
        } else {
            this.inScopeNamespaces.put(string, string2);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
        if (this.context.targetHandler != null) {
            this.context.targetHandler.endPrefixMapping(string);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.context.locator = locator;
    }

    public void startDTD(String string, String string2, String string3) {
        this.insideDTD = true;
    }

    public void endDTD() {
        this.insideDTD = false;
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        if (!this.context.targetGroup.recognizeCdata) {
            return;
        }
        if (this.skipDepth > 0) {
            if (this.context.targetHandler != null) {
                this.context.targetHandler.startCDATA();
            }
            return;
        }
        if (this.collectedCharacters.length() != 0) {
            if (this.lastElement != null) {
                this.processLastElement(true);
            }
            this.processCharacters();
            if (this.skipDepth > 0) {
                if (this.context.targetHandler != null) {
                    this.context.targetHandler.startCDATA();
                }
                return;
            }
        }
        this.insideCDATA = true;
    }

    public void endCDATA() throws SAXException {
        if (!this.context.targetGroup.recognizeCdata) {
            return;
        }
        if (this.skipDepth > 0) {
            if (this.context.targetHandler != null) {
                this.context.targetHandler.endCDATA();
            }
            return;
        }
        if (this.lastElement != null) {
            this.processLastElement(true);
        }
        this.processCharacters();
        this.insideCDATA = false;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.insideDTD) {
            return;
        }
        if (this.lastElement != null) {
            this.processLastElement(true);
        }
        if (this.collectedCharacters.length() != 0) {
            this.processCharacters();
        }
        if (this.skipDepth > 0) {
            if (this.context.targetHandler != null) {
                this.context.targetHandler.comment(cArray, n, n2);
            }
            return;
        }
        ((SAXEvent)this.eventStack.peek()).countComment();
        this.eventStack.push(SAXEvent.newComment(new String(cArray, n, n2)));
        this.processEvent();
        this.eventStack.pop();
    }

    public Stack getEventStack() {
        return this.eventStack;
    }

    protected DataStack getDataStack() {
        return this.dataStack;
    }

    public Context getContext() {
        return this.context;
    }

    public Emitter getEmitter() {
        return this.emitter;
    }

    protected SAXEvent getLastElement() {
        return this.lastElement;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class DataStack {
        private Data[] stack = new Data[32];
        private int objCount = 0;

        void push(Data data) {
            if (this.objCount == this.stack.length) {
                Data[] dataArray = new Data[2 * this.objCount];
                System.arraycopy(this.stack, 0, dataArray, 0, this.objCount);
                this.stack = dataArray;
            }
            this.stack[this.objCount++] = data;
        }

        Data peek() {
            return this.stack[this.objCount - 1];
        }

        Data pop() {
            return this.stack[--this.objCount];
        }

        public int size() {
            return this.objCount;
        }

        Data elementAt(int n) {
            return this.stack[n];
        }

        public Data[] getStack() {
            return this.stack;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(91);
            int n = 0;
            while (n < this.objCount) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.stack[n].toString());
                ++n;
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }

    public final class Data {
        private short lastProcStatus;
        public TemplateFactory.Instance template;
        private AbstractInstruction instruction;
        public GroupBase currentGroup;
        private long contextPosition;
        private GroupBase targetGroup;
        private Hashtable localVars;
        private Hashtable passedParams;
        private PSiblingsFactory.Instance psiblings;
        private SAXEvent sibEvent;

        Data(short s, TemplateFactory.Instance instance, AbstractInstruction abstractInstruction, Hashtable hashtable, Context context, SAXEvent sAXEvent) {
            this.lastProcStatus = s;
            this.template = instance;
            this.instruction = abstractInstruction;
            this.currentGroup = context.currentGroup;
            this.contextPosition = context.position;
            this.targetGroup = context.targetGroup;
            this.localVars = (Hashtable)context.localVars.clone();
            this.passedParams = hashtable;
            this.psiblings = context.psiblings;
            this.sibEvent = sAXEvent;
        }

        Data(short s, TemplateFactory.Instance instance, AbstractInstruction abstractInstruction, Hashtable hashtable, Context context) {
            this.lastProcStatus = s;
            this.template = instance;
            this.instruction = abstractInstruction;
            this.currentGroup = context.currentGroup;
            this.contextPosition = context.position;
            this.targetGroup = context.targetGroup;
            this.localVars = (Hashtable)context.localVars.clone();
            this.passedParams = hashtable;
        }

        Data(Context context) {
            this.targetGroup = context.targetGroup;
        }

        Data(Data data) {
            this.targetGroup = data.targetGroup;
            this.currentGroup = data.currentGroup;
        }

        public Hashtable getPassedParams() {
            return this.passedParams;
        }

        public Hashtable getLocalVars() {
            return this.localVars;
        }

        public GroupBase getTargetGroup() {
            return this.targetGroup;
        }

        public String toString() {
            return "Data{" + this.template + "," + this.contextPosition + "," + Arrays.asList(this.targetGroup.visibleTemplates) + "," + this.lastProcStatus + "}";
        }
    }
}

