/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.util.HashSet;
import java.util.Hashtable;
import net.sf.joost.emitter.StringEmitter;
import net.sf.joost.grammar.Tree;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.GroupBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.instruction.VariableBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import net.sf.joost.stx.Value;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class VariableFactory
extends FactoryBase {
    private HashSet attrNames = new HashSet();

    public VariableFactory() {
        this.attrNames.add("name");
        this.attrNames.add("select");
        this.attrNames.add("keep-value");
    }

    public String getName() {
        return "variable";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        String string2 = FactoryBase.getAttribute(string, attributes, "name", parseContext);
        String string3 = FactoryBase.getExpandedName(string2, parseContext);
        String string4 = attributes.getValue("select");
        Tree tree = string4 != null ? FactoryBase.parseExpr(string4, parseContext) : null;
        int n = FactoryBase.getEnumAttValue("keep-value", attributes, FactoryBase.YESNO_VALUES, parseContext);
        if (n != -1 && !(nodeBase instanceof GroupBase)) {
            throw new SAXParseException("Attribute `keep-value' is not allowed for local variables", parseContext.locator);
        }
        boolean bl = n == 0;
        FactoryBase.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(string, parseContext, string2, string3, tree, bl, nodeBase);
    }

    public class Instance
    extends VariableBase {
        private String varName;
        private Tree select;

        protected Instance(String string, ParseContext parseContext, String string2, String string3, Tree tree, boolean bl, NodeBase nodeBase) {
            super(string, nodeBase, parseContext, string3, bl, tree == null);
            this.varName = string2;
            this.select = tree;
            this.keepValue = bl;
        }

        public short process(Context context) throws SAXException {
            if (this.select != null) {
                Value value = this.select.evaluate(context, this);
                this.processVar(value, context);
            } else {
                super.process(context);
                context.emitter.pushEmitter(new StringEmitter(new StringBuffer(), "(`" + this.qName + "' started in line " + this.lineNo + ")"));
            }
            return 0;
        }

        public short processEnd(Context context) throws SAXException {
            Value value = new Value(((StringEmitter)context.emitter.popEmitter()).getBuffer().toString());
            this.processVar(value, context);
            return super.processEnd(context);
        }

        private void processVar(Value value, Context context) throws SAXException {
            Hashtable hashtable = this.parent instanceof GroupBase ? (Hashtable)((GroupBase)this.parent).groupVars.peek() : context.localVars;
            if (hashtable.get(this.expName) != null) {
                context.errorHandler.error("Variable `" + this.varName + "' already declared", this.publicId, this.systemId, this.lineNo, this.colNo);
                return;
            }
            hashtable.put(this.expName, value);
            if (hashtable == context.localVars) {
                this.parent.declareVariable(this.expName);
            }
        }
    }
}

