/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.util.HashSet;
import net.sf.joost.grammar.Tree;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.GroupBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.instruction.TemplateBase;
import net.sf.joost.instruction.TransformFactory;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class TemplateFactory
extends FactoryBase {
    private HashSet attrNames = new HashSet();

    public TemplateFactory() {
        this.attrNames.add("match");
        this.attrNames.add("priority");
        this.attrNames.add("visibility");
        this.attrNames.add("public");
        this.attrNames.add("new-scope");
    }

    public String getName() {
        return "template";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        double d;
        if (nodeBase == null || !(nodeBase instanceof GroupBase)) {
            throw new SAXParseException("`" + string + "' must be a top level " + "element or a child of stx:group", parseContext.locator);
        }
        GroupBase groupBase = (GroupBase)nodeBase;
        String string2 = FactoryBase.getAttribute(string, attributes, "match", parseContext);
        Tree tree = FactoryBase.parsePattern(string2, parseContext);
        String string3 = attributes.getValue("priority");
        if (string3 != null) {
            try {
                d = Double.parseDouble(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXParseException("The priority value `" + string3 + "' is not a number", parseContext.locator);
            }
        } else {
            d = TemplateFactory.computePriority(tree);
        }
        int n = FactoryBase.getEnumAttValue("visibility", attributes, TemplateBase.VISIBILITY_VALUES, parseContext);
        if (n == -1) {
            n = 0;
        }
        int n2 = FactoryBase.getEnumAttValue("public", attributes, FactoryBase.YESNO_VALUES, parseContext);
        boolean bl = nodeBase instanceof TransformFactory.Instance ? n2 != 1 : n2 == 0;
        boolean bl2 = FactoryBase.getEnumAttValue("new-scope", attributes, FactoryBase.YESNO_VALUES, parseContext) == 0;
        FactoryBase.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(string, nodeBase, parseContext, tree, d, n, bl, bl2);
    }

    private static double computePriority(Tree tree) {
        if (tree.type == 4) {
            return Double.NaN;
        }
        if (tree.type == 5 || tree.type == 30 || tree.type == 100 || tree.type == 12 && tree.value != "") {
            return 0.0;
        }
        if (tree.type == 7 || tree.type == 8 || tree.type == 33 || tree.type == 32) {
            return -0.25;
        }
        if (tree.type == 6 || tree.type == 31 || tree.type == 12 || tree.type == 11 || tree.type == 10 || tree.type == 9) {
            return -0.5;
        }
        return 0.5;
    }

    public final class Instance
    extends TemplateBase
    implements Cloneable,
    Comparable {
        private Tree match;
        private double priority;

        protected Instance(String string, NodeBase nodeBase, ParseContext parseContext, Tree tree, double d, int n, boolean bl, boolean bl2) throws SAXParseException {
            super(string, nodeBase, parseContext, n, bl, bl2);
            this.match = tree;
            this.priority = d;
        }

        public boolean matches(Context context, boolean bl) throws SAXException {
            context.currentInstruction = this;
            context.currentGroup = this.parentGroup;
            return this.match.matches(context, context.ancestorStack.size(), bl);
        }

        public Instance split() throws SAXException {
            if (this.match.type != 4) {
                return null;
            }
            Instance instance = null;
            try {
                instance = (Instance)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new SAXException("Can't split " + this, cloneNotSupportedException);
            }
            instance.match = this.match.right;
            if (Double.isNaN(instance.priority)) {
                instance.priority = TemplateFactory.computePriority(instance.match);
            }
            this.match = this.match.left;
            if (Double.isNaN(this.priority)) {
                this.priority = TemplateFactory.computePriority(this.match);
            }
            return instance;
        }

        public double getPriority() {
            return this.priority;
        }

        public Tree getMatchPattern() {
            return this.match;
        }

        public int compareTo(Object object) {
            double d = ((Instance)object).priority;
            return d < this.priority ? -1 : (d > this.priority ? 1 : 0);
        }

        public String toString() {
            return "template:" + this.lineNo + " " + this.match + " " + this.priority;
        }
    }
}

