/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.util.HashSet;
import java.util.Hashtable;
import net.sf.joost.emitter.BufferEmitter;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.GroupBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ResultBufferFactory
extends FactoryBase {
    private HashSet attrNames = new HashSet();

    public ResultBufferFactory() {
        this.attrNames.add("name");
        this.attrNames.add("clear");
    }

    public String getName() {
        return "result-buffer";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        String string2 = FactoryBase.getAttribute(string, attributes, "name", parseContext);
        String string3 = "@" + FactoryBase.getExpandedName(string2, parseContext);
        boolean bl = FactoryBase.getEnumAttValue("clear", attributes, FactoryBase.YESNO_VALUES, parseContext) == 0;
        FactoryBase.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(string, nodeBase, parseContext, string2, string3, bl);
    }

    public final class Instance
    extends NodeBase {
        private String bufName;
        private String expName;
        private boolean clear;

        protected Instance(String string, NodeBase nodeBase, ParseContext parseContext, String string2, String string3, boolean bl) {
            super(string, nodeBase, parseContext, true);
            this.bufName = string2;
            this.expName = string3;
            this.clear = bl;
        }

        public short process(Context context) throws SAXException {
            super.process(context);
            Object v = context.localVars.get(this.expName);
            if (v == null) {
                GroupBase groupBase = context.currentGroup;
                while (v == null && groupBase != null) {
                    v = ((Hashtable)groupBase.groupVars.peek()).get(this.expName);
                    groupBase = groupBase.parentGroup;
                }
            }
            if (v == null) {
                context.errorHandler.error("Can't fill an undeclared buffer `" + this.bufName + "'", this.publicId, this.systemId, this.lineNo, this.colNo);
                return 0;
            }
            if (context.emitter.isEmitterActive((BufferEmitter)v)) {
                context.errorHandler.error("Buffer `" + this.bufName + "' acts already as result buffer", this.publicId, this.systemId, this.lineNo, this.colNo);
                return 0;
            }
            if (this.clear) {
                ((BufferEmitter)v).clear();
            }
            context.emitter.pushEmitter((BufferEmitter)v);
            return 0;
        }

        public short processEnd(Context context) throws SAXException {
            ((BufferEmitter)context.emitter.popEmitter()).filled();
            return super.processEnd(context);
        }
    }
}

