/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.io.StringReader;
import java.util.HashSet;
import net.sf.joost.Constants;
import net.sf.joost.grammar.ExprParser;
import net.sf.joost.grammar.PatternParser;
import net.sf.joost.grammar.Tree;
import net.sf.joost.grammar.Yylex;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.stx.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class FactoryBase
implements Constants {
    protected static final String[] YESNO_VALUES = new String[]{"yes", "no"};
    protected static final int YES_VALUE = 0;
    protected static final int NO_VALUE = 1;
    private static final int ATT_STATE = 0;
    private static final int LBRACE_STATE = 1;
    private static final int RBRACE_STATE = 2;
    private static final int EXPR_STATE = 3;
    private static final int STR_STATE = 4;

    public abstract String getName();

    public abstract NodeBase createNode(NodeBase var1, String var2, Attributes var3, ParseContext var4) throws SAXException;

    protected static String getAttribute(String string, Attributes attributes, String string2, ParseContext parseContext) throws SAXParseException {
        String string3 = attributes.getValue(string2);
        if (string3 == null) {
            throw new SAXParseException("`" + string + "' must have a `" + string2 + "' attribute", parseContext.locator);
        }
        return string3;
    }

    protected static int getEnumAttValue(String string, Attributes attributes, String[] stringArray, ParseContext parseContext) throws SAXParseException {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return -1;
        }
        string2 = string2.trim();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string2)) {
                return n;
            }
            ++n;
        }
        if (stringArray.length == 2) {
            throw new SAXParseException("Value of attribute `" + string + "' must be either `" + stringArray[0] + "' or `" + stringArray[1] + "' (found `" + string2 + "')", parseContext.locator);
        }
        String string3 = "Value of attribute `" + string + "' must be one of ";
        int n2 = 0;
        while (n2 < stringArray.length - 1) {
            string3 = string3 + "`" + stringArray[n2] + "', ";
            ++n2;
        }
        string3 = string3 + "or `" + stringArray[stringArray.length - 1] + "' (found `" + string2 + "')";
        throw new SAXParseException(string3, parseContext.locator);
    }

    protected static void checkAttributes(String string, Attributes attributes, HashSet hashSet, ParseContext parseContext) throws SAXParseException {
        int n = attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            if ("".equals(attributes.getURI(n2)) && (hashSet == null || !hashSet.contains(attributes.getQName(n2)))) {
                throw new SAXParseException("`" + string + "' must not have a `" + attributes.getQName(n2) + "' attribute", parseContext.locator);
            }
            ++n2;
        }
    }

    protected static String getExpandedName(String string, ParseContext parseContext) throws SAXParseException {
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = (string = string.trim()).indexOf(58);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = (String)parseContext.nsSet.get(string2);
            if (string3 == null) {
                throw new SAXParseException("Undeclared prefix `" + string2 + "'", parseContext.locator);
            }
            stringBuffer.append(string3);
            string = string.substring(n + 1);
        }
        return stringBuffer.append('}').append(string).toString();
    }

    protected static Tree parsePattern(String string, ParseContext parseContext) throws SAXParseException {
        Tree tree;
        StringReader stringReader = new StringReader(string);
        Yylex yylex = new Yylex(stringReader);
        PatternParser patternParser = new PatternParser(yylex, parseContext);
        try {
            tree = (Tree)patternParser.parse().value;
            if (yylex.withinComment > 0) {
                throw new SAXParseException("Syntax error, encountered end of pattern within a comment.", parseContext.locator);
            }
        }
        catch (SAXParseException sAXParseException) {
            throw sAXParseException;
        }
        catch (Exception exception) {
            if (patternParser.errorToken.sym == 0) {
                if (yylex.withinComment > 0) {
                    throw new SAXParseException(exception.getMessage() + "Encountered end of pattern within a comment.", parseContext.locator);
                }
                if (yylex.last != null) {
                    throw new SAXParseException(exception.getMessage() + "Encountered end of pattern after `" + yylex.last.value + "'.", parseContext.locator);
                }
                throw new SAXParseException(exception.getMessage() + "Found empty pattern.", parseContext.locator);
            }
            throw new SAXParseException(exception.getMessage() + "Found `" + yylex.last.value + "'.", parseContext.locator);
        }
        return tree;
    }

    public static Tree parseExpr(String string, ParseContext parseContext) throws SAXParseException {
        Tree tree;
        StringReader stringReader = new StringReader(string);
        Yylex yylex = new Yylex(stringReader);
        ExprParser exprParser = new ExprParser(yylex, parseContext);
        try {
            tree = (Tree)exprParser.parse().value;
            if (yylex.withinComment > 0) {
                throw new SAXParseException("Syntax error, encountered end of expression within a comment.", parseContext.locator);
            }
        }
        catch (SAXParseException sAXParseException) {
            throw sAXParseException;
        }
        catch (Exception exception) {
            if (exprParser.errorToken.sym == 0) {
                if (yylex.withinComment > 0) {
                    throw new SAXParseException(exception.getMessage() + "Encountered end of expression within a comment.", parseContext.locator);
                }
                if (yylex.last != null) {
                    throw new SAXParseException(exception.getMessage() + "Encountered end of expression after `" + yylex.last.value + "'.", parseContext.locator);
                }
                throw new SAXParseException(exception.getMessage() + "Found empty expression.", parseContext.locator);
            }
            throw new SAXParseException(exception.getMessage() + "Found `" + yylex.last.value + "'.", parseContext.locator);
        }
        return tree;
    }

    protected static Tree parseAVT(String string, ParseContext parseContext) throws SAXParseException {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        Tree tree = null;
        int n2 = 0;
        char c = '\u0000';
        int n3 = 0;
        while (n3 < n) {
            char c2 = string.charAt(n3);
            block0 : switch (n2) {
                case 0: {
                    switch (c2) {
                        case '{': {
                            n2 = 1;
                            break block0;
                        }
                        case '}': {
                            n2 = 2;
                            break block0;
                        }
                    }
                    stringBuffer.append(c2);
                    break;
                }
                case 1: {
                    if (c2 == '{') {
                        stringBuffer.append(c2);
                        n2 = 0;
                        break;
                    }
                    if (stringBuffer.length() != 0) {
                        tree = new Tree(36, tree, new Tree(16, stringBuffer.toString()));
                        stringBuffer.setLength(0);
                    }
                    n2 = 3;
                    --n3;
                    break;
                }
                case 2: {
                    if (c2 == '}') {
                        stringBuffer.append(c2);
                        n2 = 0;
                        break;
                    }
                    throw new SAXParseException("Invalid attribute value template: found unmatched `}' at position " + n3, parseContext.locator);
                }
                case 3: {
                    switch (c2) {
                        case '}': {
                            tree = new Tree(36, tree, FactoryBase.parseExpr(stringBuffer.toString(), parseContext));
                            stringBuffer.setLength(0);
                            n2 = 0;
                            break block0;
                        }
                        case '\'': {
                            stringBuffer.append(c2);
                            n2 = 4;
                            c = c2;
                            break block0;
                        }
                    }
                }
                case 4: {
                    if (c2 == c) {
                        n2 = 3;
                    }
                    stringBuffer.append(c2);
                    break;
                }
            }
            ++n3;
        }
        switch (n2) {
            case 1: 
            case 3: {
                throw new SAXParseException("Invalid attribute value template: missing '}'.", parseContext.locator);
            }
            case 2: {
                throw new SAXParseException("Invalid attribute value template: found single `}' at the end.", parseContext.locator);
            }
            case 4: {
                throw new SAXParseException("Invalid attribute value template: unterminated string.", parseContext.locator);
            }
        }
        if (stringBuffer.length() != 0) {
            tree = new Tree(36, tree, new Tree(16, stringBuffer.toString()));
        }
        if (tree == null) {
            tree = new Tree(16, "");
        }
        return tree;
    }
}

