/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;
import net.sf.joost.grammar.Tree;
import net.sf.joost.instruction.AbstractInstruction;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.MatchFactory;
import net.sf.joost.instruction.NoMatchFactory;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.instruction.TextNode;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class AnalyzeTextFactory
extends FactoryBase {
    public static String REGEX_GROUP = "%REGEX-GROUP";
    private HashSet attrNames = new HashSet();

    public AnalyzeTextFactory() {
        this.attrNames.add("select");
    }

    public String getName() {
        return "analyze-text";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        String string2 = FactoryBase.getAttribute(string, attributes, "select", parseContext);
        Tree tree = FactoryBase.parseExpr(string2, parseContext);
        FactoryBase.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(string, nodeBase, parseContext, tree);
    }

    public final class Instance
    extends NodeBase {
        private Tree select;
        private AbstractInstruction successor;
        private Vector mVector = new Vector();
        private MatchFactory.Instance[] matchChildren;
        private NodeBase noMatchChild;
        private int maxSubstringLength;
        private int firstIndex;
        private String text;
        private boolean continued = false;
        protected String[] capSubstr;
        protected String[] noMatchStr;

        protected Instance(String string, NodeBase nodeBase, ParseContext parseContext, Tree tree) {
            super(string, nodeBase, parseContext, true);
            this.select = tree;
        }

        public void insert(NodeBase nodeBase) throws SAXParseException {
            if (nodeBase instanceof TextNode) {
                if (((TextNode)nodeBase).isWhitespaceNode()) {
                    return;
                }
                throw new SAXParseException("`" + this.qName + "' may only contain stx:match and stx:no-match children " + "(encountered text)", nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
            }
            if (nodeBase instanceof MatchFactory.Instance) {
                this.mVector.add(nodeBase);
            } else if (nodeBase instanceof NoMatchFactory.Instance) {
                if (this.noMatchChild != null) {
                    throw new SAXParseException("`" + this.qName + "' must have at most one `" + nodeBase.qName + "' child", nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
                }
                this.noMatchChild = nodeBase;
            } else {
                throw new SAXParseException("`" + this.qName + "' may only contain stx:match and stx:no-match children " + "(encountered `" + nodeBase.qName + "')", nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
            }
        }

        public boolean compile(int n) throws SAXParseException {
            if (n == 0) {
                return true;
            }
            if (this.mVector.size() == 0) {
                throw new SAXParseException("`" + this.qName + "' must have at least one stx:match child", this.publicId, this.systemId, this.lineNo, this.colNo);
            }
            this.matchChildren = new MatchFactory.Instance[this.mVector.size()];
            this.mVector.toArray(this.matchChildren);
            this.mVector = null;
            this.successor = this.nodeEnd.next;
            this.nodeEnd.next = this;
            return false;
        }

        public short process(Context context) throws SAXException {
            if (this.continued) {
                this.text = (String)this.localFieldStack.pop();
                this.continued = false;
            } else {
                this.text = this.select.evaluate((Context)context, (NodeBase)this).convertToString().string;
                if (context.localVars.get(REGEX_GROUP) == null) {
                    context.localVars.put(REGEX_GROUP, new Stack());
                }
                this.capSubstr = new String[1];
                this.noMatchStr = new String[1];
            }
            if (this.text.length() != 0) {
                this.firstIndex = this.text.length();
                this.maxSubstringLength = -1;
                int n = -1;
                int n2 = 0;
                while (n2 < this.matchChildren.length) {
                    String string = this.matchChildren[n2].regex.evaluate((Context)context, (NodeBase)this.matchChildren[n2]).string;
                    int n3 = this.text.indexOf(string);
                    if (n3 != -1 && n3 <= this.firstIndex && (n3 < this.firstIndex || string.length() > this.maxSubstringLength)) {
                        this.firstIndex = n3;
                        this.maxSubstringLength = string.length();
                        n = n2;
                    }
                    ++n2;
                }
                if (n != -1) {
                    this.capSubstr[0] = this.text.substring(this.firstIndex, this.firstIndex + this.maxSubstringLength);
                    this.noMatchStr[0] = this.text.substring(0, this.firstIndex);
                    this.localFieldStack.push(this.text.substring(this.firstIndex + this.maxSubstringLength));
                    if (this.noMatchChild != null && this.firstIndex != 0) {
                        this.next = this.noMatchChild;
                        this.noMatchChild.nodeEnd.next = this.matchChildren[n];
                    } else {
                        this.next = this.matchChildren[n];
                    }
                } else if (this.noMatchChild != null) {
                    this.noMatchStr[0] = this.text;
                    this.next = this.noMatchChild;
                    this.noMatchChild.nodeEnd.next = this.successor;
                } else {
                    this.next = this.successor;
                }
            } else {
                this.next = this.successor;
            }
            return 0;
        }

        public short processEnd(Context context) throws SAXException {
            this.continued = true;
            return 0;
        }
    }
}

