/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.process.extended;

import java.util.Stack;
import net.sourceforge.chaperon.common.Decoder;
import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.extended.ExtendedGrammar;
import net.sourceforge.chaperon.model.extended.Pattern;
import net.sourceforge.chaperon.model.extended.PatternIterator;
import net.sourceforge.chaperon.process.ParseException;
import net.sourceforge.chaperon.process.extended.NonterminalStackNode;
import net.sourceforge.chaperon.process.extended.StackNode;
import net.sourceforge.chaperon.process.extended.StackNodeList;
import net.sourceforge.chaperon.process.extended.StackNodeSet;
import net.sourceforge.chaperon.process.extended.TerminalStackNode;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class ExtendedDirectParserProcessor
implements ContentHandler,
LexicalHandler {
    private static final String NS = "http://chaperon.sourceforge.net/schema/text/1.0";
    private static final String TEXT = "text";
    public static final String NS_OUTPUT = "http://chaperon.sourceforge.net/schema/syntaxtree/2.0";
    private static final String OUTPUT = "output";
    private ContentHandler contentHandler = null;
    private LexicalHandler lexicalHandler = null;
    private Locator locator = null;
    private LocatorImpl locatorImpl = null;
    private static final int STATE_OUTER = 0;
    private static final int STATE_INNER = 1;
    private int state = 0;
    private ExtendedGrammar grammar;
    private boolean flatten = false;
    private StackNodeSet current = new StackNodeSet();
    private StackNodeSet next = new StackNodeSet();
    private Log log;
    private StackNodeList root;
    private String source;
    private int line = 1;
    private int column = 1;
    private static final int MAXWATCHDOG = 1000;
    private ParseException exception = null;

    public ExtendedDirectParserProcessor() {
    }

    public ExtendedDirectParserProcessor(ExtendedGrammar grammar, Log log) {
        this.setExtendedGrammar(grammar);
        this.log = log;
    }

    public void setExtendedGrammar(ExtendedGrammar grammar) {
        this.grammar = grammar;
        Violations violations = grammar.validate();
        if (violations != null && violations.getViolationCount() > 0) {
            throw new IllegalArgumentException("Grammar is not valid: " + violations.getViolation(0));
        }
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("grammar:\n" + grammar));
        }
        grammar.update();
        if (this.log != null && this.log.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Successors:\n");
            PatternIterator i = grammar.getAllPattern().getPattern();
            while (i.hasNext()) {
                Pattern pattern = i.next();
                if (!pattern.getSuccessors().hasNext()) continue;
                buffer.append(pattern + "->{");
                PatternIterator j = pattern.getSuccessors();
                while (j.hasNext()) {
                    buffer.append(j.next());
                    if (!j.hasNext()) continue;
                    buffer.append(",");
                }
                buffer.append("}\n");
            }
            buffer.append("\nAscending successors:\n");
            PatternIterator i2 = grammar.getAllPattern().getPattern();
            while (i2.hasNext()) {
                Pattern pattern = i2.next();
                if (!pattern.getAscendingSuccessors().hasNext()) continue;
                buffer.append(pattern + "->{");
                PatternIterator j = pattern.getAscendingSuccessors();
                while (j.hasNext()) {
                    buffer.append(j.next());
                    if (!j.hasNext()) continue;
                    buffer.append(",");
                }
                buffer.append("}\n");
            }
            buffer.append("\nDescending successors:\n");
            PatternIterator i3 = grammar.getAllPattern().getPattern();
            while (i3.hasNext()) {
                Pattern pattern = i3.next();
                if (!pattern.getDescendingSuccessors().hasNext()) continue;
                buffer.append(pattern + "->{");
                PatternIterator j = pattern.getDescendingSuccessors();
                while (j.hasNext()) {
                    buffer.append(j.next());
                    if (!j.hasNext()) continue;
                    buffer.append(",");
                }
                buffer.append("}\n");
            }
            this.log.debug((Object)buffer.toString());
        }
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        if (locator != null) {
            this.locatorImpl = new LocatorImpl(locator);
            this.contentHandler.setDocumentLocator(this.locatorImpl);
        }
    }

    public void startDocument() throws SAXException {
        this.locatorImpl.setLineNumber(this.locator.getLineNumber());
        this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        this.contentHandler.startDocument();
        this.state = 0;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.locatorImpl.setLineNumber(this.locator.getLineNumber());
        this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        if (this.state == 1) {
            throw new SAXException("Unexpected element " + qName);
        }
        if (this.state == 0) {
            if (namespaceURI != null && namespaceURI.equals(NS)) {
                if (!localName.equals(TEXT)) {
                    throw new SAXException("Unknown element " + qName);
                }
            } else {
                this.contentHandler.startElement(namespaceURI, localName, qName, atts);
                return;
            }
        }
        this.source = atts.getValue("source") != null ? atts.getValue("source") : (this.locator != null ? this.locator.getSystemId() : "unknown");
        this.column = atts.getValue("column") != null ? Integer.parseInt(atts.getValue("column")) : (this.locator != null ? this.locator.getColumnNumber() : 1);
        this.line = atts.getValue("line") != null ? Integer.parseInt(atts.getValue("line")) : (this.locator != null ? this.locator.getLineNumber() : 1);
        this.state = 1;
        this.current.clear();
        this.current.push(new TerminalStackNode(null, 0, this.grammar.getStartPattern(), null));
        this.next.clear();
        this.exception = null;
        this.contentHandler.startPrefixMapping("", NS_OUTPUT);
        this.contentHandler.startElement(NS_OUTPUT, OUTPUT, OUTPUT, new AttributesImpl());
    }

    public void characters(char[] text, int textstart, int textlength) throws SAXException {
        this.locatorImpl.setLineNumber(this.locator.getLineNumber());
        this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        if (this.state == 0) {
            this.contentHandler.characters(text, textstart, textlength);
            return;
        }
        if (this.exception != null) {
            return;
        }
        int position = textstart;
        while (position < textstart + textlength) {
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("===================================\nProcess " + Decoder.toChar(text[position])));
            }
            if (this.current.isEmpty()) {
                throw new IllegalStateException("Parsing process is aborted");
            }
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)this.getStatesAsString());
            }
            while (!this.current.isEmpty()) {
                StackNode node = this.current.pop();
                boolean expand = this.shift(node, text, position);
                PatternIterator successors = node.pattern.getDescendingSuccessors();
                while (successors.hasNext()) {
                    Pattern nextPattern = successors.next();
                    if (!nextPattern.contains(text[position]) || expand && nextPattern.getDefinition() == node.pattern.getDefinition()) continue;
                    this.reduce(node.pattern.getDefinition().getSymbol(), node, null);
                    break;
                }
                this.reduceEmpty(node);
                if (this.current.watchdog <= 1000 && this.next.watchdog <= 1000) continue;
                if (this.log != null && this.log.isInfoEnabled()) {
                    this.log.info((Object)this.getStatesAsString());
                }
                throw new ParseException("Aborted parsing because of a high ambiguous grammar", this.source, this.line, this.column);
            }
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)this.getStatesAsString());
            }
            if (this.next.isEmpty()) {
                if (this.log != null && this.log.isInfoEnabled()) {
                    this.log.info((Object)this.getStatesAsString());
                }
                throw new ParseException("Character " + Decoder.toChar(text[position]) + " is not expected", this.source, this.line, this.column);
            }
            this.swapStacks();
            this.increasePosition(text, position, position + 1);
            ++position;
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.locatorImpl.setLineNumber(this.locator.getLineNumber());
        this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        if (this.state == 0) {
            this.contentHandler.endElement(namespaceURI, localName, qName);
            return;
        }
        if (this.state == 1) {
            if (namespaceURI != null && namespaceURI.equals(NS)) {
                if (!localName.equals(TEXT)) {
                    throw new SAXException("Unknown element " + qName);
                }
            } else {
                throw new SAXException("Unexpected element " + qName);
            }
        }
        this.state = 0;
        if (this.exception != null) {
            this.exception.toXML(this.contentHandler);
            this.contentHandler.endElement(NS_OUTPUT, OUTPUT, OUTPUT);
            this.contentHandler.endPrefixMapping("");
            return;
        }
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)"===================================\nProcess end of text");
        }
        this.root = null;
        Pattern eot = this.grammar.getEndPattern();
        while (!this.current.isEmpty()) {
            StackNode node = this.current.pop();
            PatternIterator nextPattern = node.pattern.getDescendingSuccessors();
            while (nextPattern.hasNext()) {
                if (nextPattern.next() != eot) continue;
                this.reduce(node.pattern.getDefinition().getSymbol(), node, null);
                break;
            }
            this.reduceEmpty(node);
            if (this.current.watchdog <= 1000 && this.next.watchdog <= 1000) continue;
            if (this.log != null && this.log.isInfoEnabled()) {
                this.log.info((Object)this.getStatesAsString());
            }
            throw new ParseException("Aborted parsing because of a high ambiguous grammar", this.source, this.line, this.column);
        }
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)this.getStatesAsString());
        }
        if (this.root == null) {
            if (this.log != null && this.log.isInfoEnabled()) {
                this.log.info((Object)this.getStatesAsString());
            }
            throw new ParseException("Document is incomplete", this.source, this.line, this.column);
        }
        this.fireEvents();
        this.contentHandler.endElement(NS_OUTPUT, OUTPUT, OUTPUT);
        this.contentHandler.endPrefixMapping("");
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.locatorImpl.setLineNumber(this.locator.getLineNumber());
        this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        if (this.state == 0) {
            this.contentHandler.ignorableWhitespace(ch, start, length);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.locatorImpl.setLineNumber(this.locator.getLineNumber());
        this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.locatorImpl.setLineNumber(this.locator.getLineNumber());
        this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        this.contentHandler.endPrefixMapping(prefix);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.locatorImpl.setLineNumber(this.locator.getLineNumber());
        this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        if (this.state == 0) {
            this.contentHandler.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        this.locatorImpl.setLineNumber(this.locator.getLineNumber());
        this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        if (this.state == 0) {
            this.contentHandler.skippedEntity(name);
        }
    }

    public void endDocument() throws SAXException {
        this.locatorImpl.setLineNumber(this.locator.getLineNumber());
        this.locatorImpl.setColumnNumber(this.locator.getColumnNumber());
        this.contentHandler.endDocument();
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.lexicalHandler.startDTD(name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        this.lexicalHandler.endDTD();
    }

    public void startEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, len);
        }
    }

    private String getStatesAsString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("current:\n");
        buffer.append(this.current);
        buffer.append(this.current.dump());
        buffer.append("Count of states:");
        buffer.append(this.current.size());
        buffer.append("\nnext:\n");
        buffer.append(this.next);
        buffer.append(this.next.dump());
        buffer.append("Count of states:");
        buffer.append(this.next.size());
        return buffer.toString();
    }

    private void swapStacks() {
        StackNodeSet dummy = this.next;
        this.next = this.current;
        this.current = dummy;
        this.next.clear();
    }

    private boolean shift(StackNode node, char[] text, int position) {
        boolean expand = false;
        PatternIterator i = node.pattern.getSuccessors();
        while (i.hasNext()) {
            Pattern nextPattern = i.next();
            if (!nextPattern.contains(text[position]) || node.last.expand && node instanceof NonterminalStackNode && node.last.pattern.getDefinition() == nextPattern.getDefinition()) continue;
            TerminalStackNode newNode = new TerminalStackNode(text, position, nextPattern, node);
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("shift " + newNode));
            }
            this.next.push(newNode);
            expand = true;
            node.expand = true;
        }
        PatternIterator i2 = node.pattern.getAscendingSuccessors();
        while (i2.hasNext()) {
            Pattern firstPattern = i2.next();
            if (!firstPattern.contains(text[position]) || node.last.expand && node instanceof NonterminalStackNode && node.last.pattern.getDefinition() == firstPattern.getDefinition()) continue;
            TerminalStackNode newNode = new TerminalStackNode(text, position, firstPattern, node);
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("shift " + newNode));
            }
            this.next.push(newNode);
        }
        return expand;
    }

    private void reduce(String symbol, StackNode node, StackNodeList list) {
        if (node.sibling != null) {
            this.reduce(symbol, node.sibling, list);
        }
        list = new StackNodeList(node, list);
        while (node.ancestor.pattern.hasSuccessor(node.pattern)) {
            node = node.ancestor;
            if (node.sibling != null) {
                this.reduce(symbol, node.sibling, list);
            }
            list = new StackNodeList(node, list);
        }
        PatternIterator i = node.ancestor.pattern.getSuccessors();
        while (i.hasNext()) {
            Pattern nextPattern = i.next();
            if (!symbol.equals(nextPattern.getSymbol())) continue;
            NonterminalStackNode newNode = new NonterminalStackNode(list, nextPattern, node.ancestor);
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("reduce " + newNode + " with " + list));
            }
            this.current.push(newNode);
        }
        PatternIterator i2 = node.ancestor.pattern.getAscendingSuccessors();
        while (i2.hasNext()) {
            Pattern firstPattern = i2.next();
            if (!symbol.equals(firstPattern.getSymbol())) continue;
            NonterminalStackNode newNode = new NonterminalStackNode(list, firstPattern, node.ancestor);
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("reduce " + newNode + " with " + list));
            }
            this.current.push(newNode);
        }
        if (this.root == null && node.ancestor.pattern == this.grammar.getStartPattern() && symbol.equals(this.grammar.getStartSymbol())) {
            this.root = list;
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("accept " + symbol + " with " + list));
            }
        }
    }

    private void reduceEmpty(StackNode node) {
        PatternIterator i = node.pattern.getSuccessors();
        while (i.hasNext()) {
            Pattern nextPattern = i.next();
            if (nextPattern.getSymbol() == null || !this.grammar.isNullable(nextPattern.getSymbol())) continue;
            NonterminalStackNode newNode = new NonterminalStackNode(null, nextPattern, node);
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("reduce " + newNode));
            }
            this.current.push(newNode);
        }
        PatternIterator i2 = node.pattern.getAscendingSuccessors();
        while (i2.hasNext()) {
            Pattern firstPattern = i2.next();
            if (firstPattern.getSymbol() == null || !this.grammar.isNullable(firstPattern.getSymbol()) || firstPattern == node.pattern) continue;
            NonterminalStackNode newNode = new NonterminalStackNode(null, firstPattern, node);
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("reduce " + newNode));
            }
            this.current.push(newNode);
        }
    }

    private void increasePosition(char[] text, int position, int lastposition) {
        int i = position;
        while (i < lastposition) {
            if (text[i] == '\n') {
                this.column = 1;
                ++this.line;
            } else if (text[i] == '\r' && (i == text.length - 1 || text[i + 1] != '\n')) {
                this.column = 1;
                ++this.line;
            } else {
                ++this.column;
            }
            ++i;
        }
    }

    private void fireEvents() throws SAXException {
        String symbol = this.grammar.getStartSymbol();
        this.contentHandler.startElement(NS_OUTPUT, symbol, symbol, new AttributesImpl());
        Stack<StackNodeList> stack = new Stack<StackNodeList>();
        StackNodeList next = this.root;
        char[] text = null;
        int position = 0;
        int lastposition = 0;
        this.line = 1;
        this.column = 1;
        NonterminalStackNode skip = null;
        if (this.locatorImpl != null) {
            this.locatorImpl.setLineNumber(this.line);
            this.locatorImpl.setColumnNumber(this.column);
        }
        while (next != null) {
            NonterminalStackNode nonterminal;
            if (next.node instanceof NonterminalStackNode) {
                if (text != null) {
                    if (skip == null) {
                        this.contentHandler.characters(text, position, lastposition + 1 - position);
                    }
                    this.increasePosition(text, position, lastposition + 1 - position);
                    if (this.locatorImpl != null) {
                        this.locatorImpl.setLineNumber(this.line);
                        this.locatorImpl.setColumnNumber(this.column);
                    }
                    text = null;
                }
                nonterminal = (NonterminalStackNode)next.node;
                if (skip == null && nonterminal.isOmitable()) {
                    skip = nonterminal;
                }
                if (skip == null && !nonterminal.isReleaseable()) {
                    AttributesImpl atts = new AttributesImpl();
                    this.contentHandler.startElement(NS_OUTPUT, nonterminal.pattern.getSymbol(), nonterminal.pattern.getSymbol(), atts);
                }
                stack.push(next);
                next = nonterminal.definition;
            } else {
                TerminalStackNode terminal = (TerminalStackNode)next.node;
                if (text == null) {
                    text = terminal.text;
                    position = terminal.position;
                } else if (text != terminal.text) {
                    if (skip == null) {
                        this.contentHandler.characters(text, position, lastposition + 1 - position);
                    }
                    this.increasePosition(text, position, lastposition + 1 - position);
                    if (this.locatorImpl != null) {
                        this.locatorImpl.setLineNumber(this.line);
                        this.locatorImpl.setColumnNumber(this.column);
                    }
                    text = terminal.text;
                    position = terminal.position;
                }
                lastposition = terminal.position;
                next = next.next;
            }
            while (next == null && !stack.isEmpty()) {
                next = (StackNodeList)stack.pop();
                if (text != null) {
                    if (skip == null) {
                        this.contentHandler.characters(text, position, lastposition + 1 - position);
                    }
                    this.increasePosition(text, position, lastposition + 1 - position);
                    if (this.locatorImpl != null) {
                        this.locatorImpl.setLineNumber(this.line);
                        this.locatorImpl.setColumnNumber(this.column);
                    }
                    text = null;
                }
                nonterminal = (NonterminalStackNode)next.node;
                if (skip == null && !nonterminal.isReleaseable()) {
                    this.contentHandler.endElement(NS_OUTPUT, nonterminal.pattern.getSymbol(), nonterminal.pattern.getSymbol());
                }
                if (skip == nonterminal) {
                    skip = null;
                }
                next = next.next;
            }
        }
        if (text != null) {
            if (skip == null) {
                this.contentHandler.characters(text, position, lastposition + 1 - position);
            }
            this.increasePosition(text, position, lastposition + 1 - position);
            if (this.locatorImpl != null) {
                this.locatorImpl.setLineNumber(this.line);
                this.locatorImpl.setColumnNumber(this.column);
            }
            text = null;
        }
        this.contentHandler.endElement(NS_OUTPUT, symbol, symbol);
    }
}

