/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.htmlcleaner;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.cyberneko.dtd.parsers.DOMParser;
import org.outerj.daisy.htmlcleaner.ElementDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;

class XhtmlDescriptorBuilder {
    XhtmlDescriptorBuilder() {
    }

    public Map build() throws Exception {
        DOMParser parser = new DOMParser();
        URL dtdURL = this.getClass().getClassLoader().getResource("org/outerj/daisy/htmlcleaner/xhtml1-strict.dtd");
        InputSource inputSource = new InputSource();
        inputSource.setByteStream(dtdURL.openStream());
        inputSource.setSystemId(dtdURL.toExternalForm());
        parser.parse(inputSource);
        Document document = parser.getDocument();
        Element dtdElement = document.getDocumentElement();
        Element externalSubset = this.findChildElement(dtdElement, "externalSubset");
        Element[] elementDecls = this.findChildElements(externalSubset, "elementDecl");
        HashMap<String, ElementDescriptor> elementDescriptors = new HashMap<String, ElementDescriptor>();
        for (int i = 0; i < elementDecls.length; ++i) {
            Element elementDecl = elementDecls[i];
            String name = elementDecl.getAttribute("ename");
            elementDescriptors.put(name, new ElementDescriptor(name));
        }
        Element[] attlists = this.findChildElements(externalSubset, "attlist");
        for (int i = 0; i < attlists.length; ++i) {
            Element attlist = attlists[i];
            String ename = attlist.getAttribute("ename");
            Element[] attributeDecls = this.findChildElements(attlist, "attributeDecl");
            ElementDescriptor descriptor = (ElementDescriptor)elementDescriptors.get(ename);
            for (int j = 0; j < attributeDecls.length; ++j) {
                String aname = attributeDecls[j].getAttribute("aname");
                if (aname.equals("xmlns") || aname.startsWith("xml:")) continue;
                descriptor.addAttribute(aname);
            }
        }
        Element[] contentModels = this.findChildElements(externalSubset, "contentModel");
        for (int i = 0; i < contentModels.length; ++i) {
            Element contentModel = contentModels[i];
            String ename = contentModel.getAttribute("ename");
            Element[] elements = this.findDescendants(contentModel, "element");
            ElementDescriptor descriptor = (ElementDescriptor)elementDescriptors.get(ename);
            for (int j = 0; j < elements.length; ++j) {
                String name = elements[j].getAttribute("name");
                descriptor.addChild(name);
            }
        }
        return elementDescriptors;
    }

    private Element findChildElement(Element element, String name) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals(name)) continue;
            return (Element)node;
        }
        throw new RuntimeException("Did not find expected element: " + name);
    }

    private Element[] findChildElements(Element element, String name) {
        ArrayList<Node> foundElements = new ArrayList<Node>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals(name)) continue;
            foundElements.add(node);
        }
        return foundElements.toArray(new Element[foundElements.size()]);
    }

    private Element[] findDescendants(Element element, String name) {
        ArrayList<Element> foundElements = new ArrayList<Element>();
        TreeWalker walker = ((DocumentTraversal)((Object)element.getOwnerDocument())).createTreeWalker(element, 1, null, false);
        while (walker.nextNode() != null) {
            Element currentEl = (Element)walker.getCurrentNode();
            if (!currentEl.getNodeName().equals(name)) continue;
            foundElements.add(currentEl);
        }
        return foundElements.toArray(new Element[foundElements.size()]);
    }
}

