/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;

public abstract class Searcher
implements Searchable {
    private Similarity similarity = Similarity.getDefault();

    public final Hits search(Query query) throws IOException {
        return this.search(query, (Filter)null);
    }

    public Hits search(Query query, Filter filter) throws IOException {
        return new Hits(this, query, filter);
    }

    public Hits search(Query query, Sort sort) throws IOException {
        return new Hits(this, query, null, sort);
    }

    public Hits search(Query query, Filter filter, Sort sort) throws IOException {
        return new Hits(this, query, filter, sort);
    }

    public void search(Query query, HitCollector results) throws IOException {
        this.search(query, (Filter)null, results);
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }
}

