/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.HyphenationEvent;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfFont;
import java.awt.Color;
import java.util.HashMap;

public class PdfChunk
implements SplitCharacter {
    private static final char[] singleSpace = new char[]{' '};
    private static final PdfChunk[] thisChunk = new PdfChunk[1];
    private static final float ITALIC_ANGLE = 0.21256f;
    private static final HashMap keysAttributes = new HashMap();
    private static final HashMap keysNoStroke = new HashMap();
    protected String value = "";
    protected String encoding = "Cp1252";
    protected PdfFont font;
    protected BaseFont baseFont;
    protected SplitCharacter splitCharacter;
    protected HashMap attributes = new HashMap();
    protected HashMap noStroke = new HashMap();
    protected boolean newlineSplit;
    protected Image image;
    protected float offsetX;
    protected float offsetY;
    protected boolean changeLeading = false;

    PdfChunk(String string, PdfChunk pdfChunk) {
        PdfChunk.thisChunk[0] = this;
        this.value = string;
        this.font = pdfChunk.font;
        this.attributes = pdfChunk.attributes;
        this.noStroke = pdfChunk.noStroke;
        this.baseFont = pdfChunk.baseFont;
        Object[] objectArray = (Object[])this.attributes.get("IMAGE");
        if (objectArray == null) {
            this.image = null;
        } else {
            this.image = (Image)objectArray[0];
            this.offsetX = ((Float)objectArray[1]).floatValue();
            this.offsetY = ((Float)objectArray[2]).floatValue();
            this.changeLeading = (Boolean)objectArray[3];
        }
        this.encoding = this.font.getFont().getEncoding();
        this.splitCharacter = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
        if (this.splitCharacter == null) {
            this.splitCharacter = this;
        }
    }

    PdfChunk(Chunk chunk, PdfAction pdfAction) {
        Object object;
        Object[] objectArray;
        PdfChunk.thisChunk[0] = this;
        this.value = chunk.content();
        Font font = chunk.font();
        float f = font.size();
        if (f == -1.0f) {
            f = 12.0f;
        }
        this.baseFont = font.getBaseFont();
        int n = font.style();
        if (n == -1) {
            n = 0;
        }
        if (this.baseFont == null) {
            this.baseFont = font.getCalculatedBaseFont(false);
        } else {
            if ((n & 1) != 0) {
                this.attributes.put("TEXTRENDERMODE", new Object[]{new Integer(2), new Float(f / 30.0f), null});
            }
            if ((n & 2) != 0) {
                this.attributes.put("SKEW", new float[]{0.0f, 0.21256f});
            }
        }
        this.font = new PdfFont(this.baseFont, f);
        HashMap hashMap = chunk.getAttributes();
        if (hashMap != null) {
            objectArray = hashMap.keySet().iterator();
            while (objectArray.hasNext()) {
                object = objectArray.next();
                if (keysAttributes.containsKey(object)) {
                    this.attributes.put(object, hashMap.get(object));
                    continue;
                }
                if (!keysNoStroke.containsKey(object)) continue;
                this.noStroke.put(object, hashMap.get(object));
            }
            if ("".equals(hashMap.get("GENERICTAG"))) {
                this.attributes.put("GENERICTAG", chunk.content());
            }
        }
        if (font.isUnderlined()) {
            objectArray = new Object[]{null, new float[]{0.0f, 0.06666667f, 0.0f, -0.33333334f, 0.0f}};
            object = Chunk.addToArray((Object[][])this.attributes.get("UNDERLINE"), objectArray);
            this.attributes.put("UNDERLINE", object);
        }
        if (font.isStrikethru()) {
            objectArray = new Object[]{null, new float[]{0.0f, 0.06666667f, 0.0f, 0.33333334f, 0.0f}};
            object = Chunk.addToArray((Object[][])this.attributes.get("UNDERLINE"), objectArray);
            this.attributes.put("UNDERLINE", object);
        }
        if (pdfAction != null) {
            this.attributes.put("ACTION", pdfAction);
        }
        this.noStroke.put("COLOR", font.color());
        this.noStroke.put("ENCODING", this.font.getFont().getEncoding());
        objectArray = (Object[])this.attributes.get("IMAGE");
        if (objectArray == null) {
            this.image = null;
        } else {
            this.attributes.remove("HSCALE");
            this.image = (Image)objectArray[0];
            this.offsetX = ((Float)objectArray[1]).floatValue();
            this.offsetY = ((Float)objectArray[2]).floatValue();
            this.changeLeading = (Boolean)objectArray[3];
        }
        this.font.setImage(this.image);
        object = (Float)this.attributes.get("HSCALE");
        if (object != null) {
            this.font.setHorizontalScaling(((Float)object).floatValue());
        }
        this.encoding = this.font.getFont().getEncoding();
        this.splitCharacter = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
        if (this.splitCharacter == null) {
            this.splitCharacter = this;
        }
    }

    public char getUnicodeEquivalent(char c) {
        return this.baseFont.getUnicodeEquivalent(c);
    }

    protected int getWord(String string, int n) {
        int n2 = string.length();
        while (n < n2 && Character.isLetter(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    PdfChunk split(float f) {
        Object object;
        char c;
        int n;
        this.newlineSplit = false;
        if (this.image != null) {
            if (this.image.scaledWidth() > f) {
                PdfChunk pdfChunk = new PdfChunk("\ufffc", this);
                this.value = "";
                this.attributes = new HashMap();
                this.image = null;
                this.font = PdfFont.getDefaultFont();
                return pdfChunk;
            }
            return null;
        }
        HyphenationEvent hyphenationEvent = (HyphenationEvent)this.noStroke.get("HYPHENATION");
        int n2 = -1;
        float f2 = 0.0f;
        int n3 = -1;
        float f3 = 0.0f;
        int n4 = this.value.length();
        char[] cArray = this.value.toCharArray();
        char c2 = '\u0000';
        BaseFont baseFont = this.font.getFont();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(' ') != ' ') {
            for (n = 0; n < n4; ++n) {
                c = cArray[n];
                c2 = baseFont.getUnicodeEquivalent(c);
                if (c2 == '\n') {
                    this.newlineSplit = true;
                    String string = this.value.substring(n + 1);
                    this.value = this.value.substring(0, n);
                    if (this.value.length() < 1) {
                        this.value = "\u0001";
                    }
                    PdfChunk pdfChunk = new PdfChunk(string, this);
                    return pdfChunk;
                }
                f2 += this.font.width(c);
                if (c2 == ' ') {
                    n3 = n + 1;
                    f3 = f2;
                }
                if (!(f2 > f)) {
                    if (!this.splitCharacter.isSplitCharacter(0, n, n4, cArray, thisChunk)) continue;
                    n2 = n + 1;
                    continue;
                }
                break;
            }
        } else {
            while (n < n4) {
                c2 = cArray[n];
                if (c2 == '\r' || c2 == '\n') {
                    this.newlineSplit = true;
                    int n5 = 1;
                    if (c2 == '\r' && n + 1 < n4 && cArray[n + 1] == '\n') {
                        n5 = 2;
                    }
                    String string = this.value.substring(n + n5);
                    this.value = this.value.substring(0, n);
                    if (this.value.length() < 1) {
                        this.value = " ";
                    }
                    PdfChunk pdfChunk = new PdfChunk(string, this);
                    return pdfChunk;
                }
                f2 += this.font.width(c2);
                if (c2 == ' ') {
                    n3 = n + 1;
                    f3 = f2;
                }
                if (!(f2 > f)) {
                    if (this.splitCharacter.isSplitCharacter(0, n, n4, cArray, null)) {
                        n2 = n + 1;
                    }
                    ++n;
                    continue;
                }
                break;
            }
        }
        if (n == n4) {
            return null;
        }
        if (n2 < 0) {
            String string = this.value;
            this.value = "";
            PdfChunk pdfChunk = new PdfChunk(string, this);
            return pdfChunk;
        }
        if (n3 > n2 && this.splitCharacter.isSplitCharacter(0, 0, 1, singleSpace, null)) {
            n2 = n3;
        }
        if (hyphenationEvent != null && n3 < n && (c = this.getWord(this.value, n3)) > n3) {
            object = hyphenationEvent.getHyphenatedWordPre(this.value.substring(n3, c), this.font.getFont(), this.font.size(), f - f3);
            String string = hyphenationEvent.getHyphenatedWordPost();
            if (((String)object).length() > 0) {
                String string2 = string + this.value.substring(c);
                this.value = this.trim(this.value.substring(0, n3) + (String)object);
                PdfChunk pdfChunk = new PdfChunk(string2, this);
                return pdfChunk;
            }
        }
        String string = this.value.substring(n2);
        this.value = this.trim(this.value.substring(0, n2));
        object = new PdfChunk(string, this);
        return object;
    }

    PdfChunk truncate(float f) {
        char c;
        int n;
        if (this.image != null) {
            if (this.image.scaledWidth() > f) {
                PdfChunk pdfChunk = new PdfChunk("", this);
                this.value = "";
                this.attributes.remove("IMAGE");
                this.image = null;
                this.font = PdfFont.getDefaultFont();
                return pdfChunk;
            }
            return null;
        }
        float f2 = 0.0f;
        if (f < this.font.width()) {
            String string = this.value.substring(1);
            this.value = this.value.substring(0, 1);
            PdfChunk pdfChunk = new PdfChunk(string, this);
            return pdfChunk;
        }
        int n2 = this.value.length();
        for (n = 0; n < n2 && !((f2 += this.font.width(c = this.value.charAt(n))) > f); ++n) {
        }
        if (n == n2) {
            return null;
        }
        if (n == 0) {
            n = 1;
        }
        String string = this.value.substring(n);
        this.value = this.value.substring(0, n);
        PdfChunk pdfChunk = new PdfChunk(string, this);
        return pdfChunk;
    }

    PdfFont font() {
        return this.font;
    }

    Color color() {
        return (Color)this.noStroke.get("COLOR");
    }

    float width() {
        return this.font.width(this.value);
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit;
    }

    public float getWidthCorrected(float f, float f2) {
        if (this.image != null) {
            return this.image.scaledWidth() + f;
        }
        int n = 0;
        int n2 = -1;
        while ((n2 = this.value.indexOf(32, n2 + 1)) >= 0) {
            ++n;
        }
        return this.width() + ((float)this.value.length() * f + (float)n * f2);
    }

    public float trimLastSpace() {
        BaseFont baseFont = this.font.getFont();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(' ') != ' ') {
            if (this.value.length() > 1 && this.value.endsWith("\u0001")) {
                this.value = this.value.substring(0, this.value.length() - 1);
                return this.font.width('\u0001');
            }
        } else if (this.value.length() > 1 && this.value.endsWith(" ")) {
            this.value = this.value.substring(0, this.value.length() - 1);
            return this.font.width(' ');
        }
        return 0.0f;
    }

    Object getAttribute(String string) {
        if (this.attributes.containsKey(string)) {
            return this.attributes.get(string);
        }
        return this.noStroke.get(string);
    }

    boolean isAttribute(String string) {
        if (this.attributes.containsKey(string)) {
            return true;
        }
        return this.noStroke.containsKey(string);
    }

    boolean isStroked() {
        return this.attributes.size() > 0;
    }

    boolean isImage() {
        return this.image != null;
    }

    Image getImage() {
        return this.image;
    }

    void setImageOffsetX(float f) {
        this.offsetX = f;
    }

    float getImageOffsetX() {
        return this.offsetX;
    }

    void setImageOffsetY(float f) {
        this.offsetY = f;
    }

    float getImageOffsetY() {
        return this.offsetY;
    }

    void setValue(String string) {
        this.value = string;
    }

    public String toString() {
        return this.value;
    }

    boolean isSpecialEncoding() {
        return this.encoding.equals("UnicodeBigUnmarked") || this.encoding.equals("Identity-H");
    }

    String getEncoding() {
        return this.encoding;
    }

    int length() {
        return this.value.length();
    }

    public boolean isSplitCharacter(int n, int n2, int n3, char[] cArray, PdfChunk[] pdfChunkArray) {
        char c = pdfChunkArray == null ? cArray[n2] : pdfChunkArray[Math.min(n2, pdfChunkArray.length - 1)].getUnicodeEquivalent(cArray[n2]);
        if (c <= ' ' || c == '-') {
            return true;
        }
        if (c < '\u2e80') {
            return false;
        }
        return c >= '\u2e80' && c < '\ud7a0' || c >= '\uf900' && c < '\ufb00' || c >= '\ufe30' && c < '\ufe50' || c >= '\uff61' && c < '\uffa0';
    }

    boolean isExtSplitCharacter(int n, int n2, int n3, char[] cArray, PdfChunk[] pdfChunkArray) {
        return this.splitCharacter.isSplitCharacter(n, n2, n3, cArray, pdfChunkArray);
    }

    String trim(String string) {
        BaseFont baseFont = this.font.getFont();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(' ') != ' ') {
            while (string.endsWith("\u0001")) {
                string = string.substring(0, string.length() - 1);
            }
        } else {
            while (string.endsWith(" ") || string.endsWith("\t")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public boolean changeLeading() {
        return this.changeLeading;
    }

    float getCharWidth(char c) {
        if (PdfChunk.noPrint(c)) {
            return 0.0f;
        }
        return this.font.width(c);
    }

    public static boolean noPrint(char c) {
        return c >= '\u200b' && c <= '\u200f' || c >= '\u202a' && c <= '\u202e';
    }

    static {
        keysAttributes.put("ACTION", null);
        keysAttributes.put("UNDERLINE", null);
        keysAttributes.put("REMOTEGOTO", null);
        keysAttributes.put("LOCALGOTO", null);
        keysAttributes.put("LOCALDESTINATION", null);
        keysAttributes.put("GENERICTAG", null);
        keysAttributes.put("NEWPAGE", null);
        keysAttributes.put("IMAGE", null);
        keysAttributes.put("BACKGROUND", null);
        keysAttributes.put("PDFANNOTATION", null);
        keysAttributes.put("SKEW", null);
        keysAttributes.put("HSCALE", null);
        keysNoStroke.put("SUBSUPSCRIPT", null);
        keysNoStroke.put("SPLITCHARACTER", null);
        keysNoStroke.put("HYPHENATION", null);
        keysNoStroke.put("TEXTRENDERMODE", null);
    }
}

