/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.publisher;

import de.tivano.flash.swf.common.SWFColorRGB;
import de.tivano.flash.swf.common.SWFColorRGBA;
import de.tivano.flash.swf.common.SWFDefineTextField;
import de.tivano.flash.swf.common.SWFFont;
import de.tivano.flash.swf.common.SWFRectangle;
import de.tivano.flash.swf.common.SWFTopLevelDataType;
import de.tivano.flash.swf.publisher.FontKey;
import de.tivano.flash.swf.publisher.SWFGenericWriter;
import de.tivano.flash.swf.publisher.SWFTagHandlerBase;
import de.tivano.flash.swf.publisher.SWFTagWriter;
import de.tivano.flash.swf.publisher.SWFWriterException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.Attributes;

public class XMLTextHandler
extends SWFTagHandlerBase {
    private static final SWFColorRGB DEFAULT_COLOR = new SWFColorRGB("000000");
    private boolean isSelectable;
    private boolean hasLayout;
    private int leftMargin;
    private int rightMargin;
    private int indent;
    private int lineSpacing;
    private String varName;
    private int id;
    private boolean hasBorder;
    private SWFRectangle bounds;
    private FontKey nextFont;
    private static final FontKey DEFAULT_FONT = new FontKey("Times new roman", 0);
    private int alpha;
    private FormattedText content;
    private LinkedList textStack = new LinkedList();
    static /* synthetic */ Class class$de$tivano$flash$swf$publisher$XMLTextMarkupParHandler;

    private FormattedText getCurrentText() {
        return (FormattedText)this.textStack.getLast();
    }

    public XMLTextHandler() {
        this.registerElementHandler("P", class$de$tivano$flash$swf$publisher$XMLTextMarkupParHandler == null ? (class$de$tivano$flash$swf$publisher$XMLTextMarkupParHandler = XMLTextHandler.class$("de.tivano.flash.swf.publisher.XMLTextMarkupParHandler")) : class$de$tivano$flash$swf$publisher$XMLTextMarkupParHandler);
    }

    public int getFontLayout() {
        return this.getCurrentText().getFontStyle();
    }

    public void changeFontName(String name) {
        if (!this.content.hasFontName()) {
            this.content.setFontName(name);
        }
        this.getCurrentText().setFontName(name);
    }

    public void changeFontLayout(int layout) {
        if (!this.content.hasFontStyle()) {
            this.content.setFontStyle(layout);
        }
        this.getCurrentText().setFontStyle(layout);
    }

    public void changeFontSize(int size) {
        if (!this.content.hasFontSize()) {
            this.content.setFontSize(size);
        }
        this.getCurrentText().setFontSize(size);
    }

    public void changeAlign(int align) {
        if (!this.content.hasAlign()) {
            this.content.setAlign(align);
        }
        this.getCurrentText().setAlign(align);
    }

    public void changeColor(SWFColorRGB color) {
        if (!this.content.hasColor()) {
            this.content.setColor(color);
        }
        this.getCurrentText().setColor(color);
    }

    public void addText(char[] ch, int start, int length) throws SWFWriterException {
        this.getCurrentText().add(ch, start, length);
    }

    public void finishCurrentText() {
        this.textStack.removeLast();
    }

    public void startNewText(boolean newline) {
        InnerFormattedText newText = new InnerFormattedText();
        this.getCurrentText().add(newText);
        newText.setIsParagraph(newline);
        this.textStack.addLast(newText);
    }

    protected void startElement(String name, Attributes attrib) throws SWFWriterException {
        this.content = new FormattedText();
        this.textStack.clear();
        this.textStack.addLast(this.content);
        this.hasLayout = false;
        this.leftMargin = 0;
        this.rightMargin = 0;
        this.indent = 0;
        this.lineSpacing = 0;
        this.alpha = 255;
        try {
            String tmp = attrib.getValue("", "id");
            if (tmp != null) {
                this.id = Integer.parseInt(tmp);
            }
            this.varName = (tmp = attrib.getValue("", "name")) != null ? tmp : "";
            try {
                this.bounds = new SWFRectangle(Integer.parseInt(attrib.getValue("", "xmin")), Integer.parseInt(attrib.getValue("", "xmax")), Integer.parseInt(attrib.getValue("", "ymin")), Integer.parseInt(attrib.getValue("", "ymax")));
            }
            catch (Exception e) {
                this.fatalError("Text bounds must be specified");
            }
            tmp = attrib.getValue("", "alpha");
            if (tmp != null) {
                this.alpha = Integer.parseInt(tmp.substring(1, 3), 16);
            }
            if ((tmp = attrib.getValue("", "indent")) != null) {
                this.hasLayout = true;
                this.indent = Math.round(Float.parseFloat(tmp) * 20.0f);
            }
            if ((tmp = attrib.getValue("", "leftmargin")) != null) {
                this.hasLayout = true;
                this.leftMargin = Math.round(Float.parseFloat(tmp) * 20.0f);
            }
            if ((tmp = attrib.getValue("", "rightmargin")) != null) {
                this.hasLayout = true;
                this.rightMargin = Math.round(Float.parseFloat(tmp) * 20.0f);
            }
            if ((tmp = attrib.getValue("", "linespacing")) != null) {
                this.hasLayout = true;
                this.lineSpacing = Math.round(Float.parseFloat(tmp) * 20.0f);
            }
            this.hasBorder = "yes".equals(attrib.getValue("", "border"));
            this.isSelectable = "yes".equals(attrib.getValue("", "selectable"));
        }
        catch (SWFWriterException e) {
            throw e;
        }
        catch (Exception e) {
            this.fatalError(e);
        }
    }

    protected SWFTagWriter createDataObject() throws SWFWriterException {
        return new SWFGenericWriter(this.getTextData(false));
    }

    public SWFTopLevelDataType getTextData(boolean forceTextField) throws SWFWriterException {
        if (forceTextField || this.isSelectable) {
            return this.createDefineTextField();
        }
        return this.createDefineTextField();
    }

    protected SWFTopLevelDataType createDefineTextField() throws SWFWriterException {
        boolean useHTML = this.getSWFWriter().getFlashVersion() >= 5 && this.content.multiLayout();
        SWFDefineTextField data = new SWFDefineTextField();
        SWFFont font = this.content.getFont();
        data.setID(this.id);
        data.setBounds(this.bounds);
        data.setSelectable(this.isSelectable);
        data.setHTML(useHTML);
        data.setHasBorder(this.hasBorder);
        data.setVarName(this.varName);
        data.setFontID(font.getFontID());
        data.setFontHeight(this.content.getFontSize());
        data.setTextColor(new SWFColorRGBA(this.content.getColor(), this.alpha));
        data.setReadonly(true);
        data.setUseOutlines(font.hasMetrics());
        try {
            data.setText(this.content.getBytes(font.getCanonicalEncodingName(), useHTML));
        }
        catch (UnsupportedEncodingException e) {
            this.fatalError(e);
        }
        if (this.hasLayout) {
            data.setTextAlign(this.content.getAlign());
            data.setLeftMargin(this.leftMargin);
            data.setRightMargin(this.rightMargin);
            data.setTextIndent(this.indent);
            data.setLineSpacing(this.lineSpacing);
        }
        return data;
    }

    static /* synthetic */ SWFColorRGB access$000() {
        return DEFAULT_COLOR;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InnerFormattedText
    extends FormattedText {
        private InnerFormattedText() {
        }

        protected void collectHTMLContent(StringBuffer buf) throws SWFWriterException {
            Iterator entries;
            if (this.isParagraph()) {
                buf.append("<P ALIGN=\"" + this.getAlignString() + "\">");
            }
            if ((entries = this.content.iterator()).hasNext()) {
                boolean insertFont;
                boolean bl = insertFont = this.hasFontName() || this.hasFontSize() || this.hasColor();
                if (insertFont) {
                    buf.append("<FONT");
                    if (this.hasFontName()) {
                        buf.append(" FACE=\"").append(this.getFontName()).append("\"");
                    }
                    if (this.hasFontSize()) {
                        buf.append(" SIZE=\"").append((double)this.getFontSize() / 20.0).append("\"");
                    }
                    if (this.hasColor()) {
                        buf.append(" COLOR=\"#").append(this.getColor().toHexString()).append("\"");
                    }
                    buf.append(">");
                }
                if (this.hasFontStyleBold) {
                    buf.append("<B>");
                }
                if (this.hasFontStyleItalic) {
                    buf.append("<I>");
                }
                super.collectHTMLContent(buf);
                if (this.hasFontStyleItalic) {
                    buf.append("</I>");
                }
                if (this.hasFontStyleBold) {
                    buf.append("</B>");
                }
                if (insertFont) {
                    buf.append("</FONT>");
                }
            }
            if (this.isParagraph()) {
                buf.append("</P>");
            }
        }
    }

    private class FormattedText {
        private FontKey fontKey = new FontKey("Times New Roman", 0);
        private SWFFont font = null;
        private SWFColorRGB color = XMLTextHandler.access$000();
        private int fontSize = 240;
        private int align = 0;
        private boolean isParagraph = false;
        protected List content = new ArrayList();
        private StringBuffer currentText = null;
        private boolean hasFontName = false;
        private boolean hasFontSize = false;
        protected boolean hasFontStyleBold = false;
        protected boolean hasFontStyleItalic = false;
        private boolean hasFontStyle = false;
        private boolean hasColor = false;
        private boolean hasAlign = false;

        public void setFontName(String value) {
            this.fontKey.setName(value);
            this.hasFontName = true;
        }

        public void setFontStyle(int value) {
            this.fontKey.setLayout(value);
            this.hasFontStyleBold = (value & 1) != 0;
            this.hasFontStyleItalic = (value & 2) != 0;
            this.hasFontStyle = true;
        }

        public void setColor(SWFColorRGB value) {
            this.color = value;
            this.hasColor = true;
        }

        public void setFontSize(int value) {
            this.fontSize = value;
            this.hasFontSize = true;
        }

        public void setAlign(int value) {
            this.align = value;
            this.hasAlign = true;
        }

        public void setIsParagraph(boolean value) {
            this.isParagraph = value;
        }

        public boolean hasFontName() {
            return this.hasFontName;
        }

        public boolean hasFontStyle() {
            return this.hasFontStyle;
        }

        public boolean hasFontSize() {
            return this.hasFontSize;
        }

        public boolean hasColor() {
            return this.hasColor;
        }

        public boolean hasAlign() {
            return this.hasAlign;
        }

        public boolean isParagraph() {
            return this.isParagraph;
        }

        public boolean isEmpty() {
            return this.content.isEmpty();
        }

        public String getFontName() {
            return this.fontKey.getName();
        }

        public int getFontStyle() {
            return this.fontKey.getLayout();
        }

        public int getFontSize() {
            return this.fontSize;
        }

        public SWFColorRGB getColor() {
            return this.color;
        }

        public int getAlign() {
            return this.align;
        }

        public SWFFont getFont() throws SWFWriterException {
            if (this.font == null) {
                this.font = (SWFFont)XMLTextHandler.this.getSWFWriter().getContextMap().get(this.fontKey);
                if (this.font == null) {
                    XMLTextHandler.this.fatalError("Font not found: " + this.getFontName() + " (" + this.getStyleString() + ")");
                }
            }
            return this.font;
        }

        public String getAlignString() {
            switch (this.align) {
                case 0: {
                    return "LEFT";
                }
                case 1: {
                    return "RIGHT";
                }
                case 2: {
                    return "CENTER";
                }
                case 3: {
                    return "JUSTIFY";
                }
            }
            return "LEFT";
        }

        public String getStyleString() {
            switch (this.fontKey.getLayout()) {
                case 0: {
                    return "standard";
                }
                case 1: {
                    return "bold";
                }
                case 2: {
                    return "italic";
                }
                case 3: {
                    return "bold,italic";
                }
            }
            return "unknown: " + this.fontKey.getLayout();
        }

        public void add(FormattedText newText) {
            newText.fontKey.setName(this.getFontName());
            newText.fontKey.setLayout(this.getFontStyle());
            newText.align = this.getAlign();
            newText.color = this.getColor();
            newText.fontSize = this.getFontSize();
            this.content.add(newText);
            this.currentText = null;
        }

        public void add(char[] ch, int start, int length) {
            if (length == 0) {
                return;
            }
            if (this.currentText == null) {
                this.currentText = new StringBuffer();
                this.content.add(this.currentText);
            }
            this.currentText.append(ch, start, length);
        }

        private boolean isLayoutCompatible(FormattedText other) {
            return !(this.hasFontName() && !this.getFontName().equals(other.getFontName()) || this.hasColor() && !this.getColor().equals(other.getColor()) || this.hasAlign() && this.getAlign() != other.getAlign() || this.hasFontSize() && this.getFontSize() != other.getFontSize() || this.hasFontStyle() && this.getFontStyle() != other.getFontStyle());
        }

        public boolean multiLayout() {
            Iterator entries = this.content.iterator();
            while (entries.hasNext()) {
                FormattedText t;
                Object obj = entries.next();
                if (!(obj instanceof FormattedText) || !(t = (FormattedText)obj).multiLayout() && t.isLayoutCompatible(this)) continue;
                return true;
            }
            return false;
        }

        public byte[] getBytes(String encoding, boolean useHTML) throws UnsupportedEncodingException, SWFWriterException {
            StringBuffer buf = new StringBuffer();
            if (useHTML) {
                this.collectHTMLContent(buf);
            } else {
                this.collectPlainContent(buf);
            }
            return buf.toString().getBytes(encoding);
        }

        private void collectPlainContent(StringBuffer buf) throws SWFWriterException {
            Iterator entries = this.content.iterator();
            while (entries.hasNext()) {
                Object obj = entries.next();
                if (obj instanceof StringBuffer) {
                    StringBuffer text = (StringBuffer)obj;
                    this.getFont().markUsed(text);
                    buf.append((Object)((StringBuffer)obj));
                    continue;
                }
                ((FormattedText)obj).collectPlainContent(buf);
            }
            if (this.isParagraph()) {
                buf.append('\r');
            }
        }

        protected void collectHTMLContent(StringBuffer buf) throws SWFWriterException {
            Iterator entries = this.content.iterator();
            while (entries.hasNext()) {
                Object obj = entries.next();
                if (obj instanceof StringBuffer) {
                    StringBuffer text = (StringBuffer)obj;
                    int i = 0;
                    while (i < text.length()) {
                        char ch = text.charAt(i);
                        this.getFont().markUsed(ch);
                        switch (ch) {
                            case '\u00a0': {
                                buf.append("&nbsp;");
                                break;
                            }
                            case '\"': {
                                buf.append("&quot;");
                                break;
                            }
                            case '<': {
                                buf.append("&lt;");
                                break;
                            }
                            case '>': {
                                buf.append("&gt;");
                                break;
                            }
                            case '&': {
                                buf.append("&amp;");
                                break;
                            }
                            default: {
                                buf.append(ch);
                            }
                        }
                        ++i;
                    }
                    continue;
                }
                ((FormattedText)obj).collectHTMLContent(buf);
            }
        }
    }
}

