/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.publisher;

import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFFileHeader;
import de.tivano.flash.swf.common.SWFRectangle;
import de.tivano.flash.swf.common.SWFTagHeader;
import de.tivano.flash.swf.publisher.SWFTagWriter;
import de.tivano.flash.swf.publisher.SWFWriterException;
import de.tivano.flash.swf.publisher.XMLHandlerBase;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SWFWriter
extends XMLHandlerBase
implements ContentHandler {
    private BitOutputStream out = null;
    private boolean closeOut = false;
    private XMLHandlerBase currentHandler = this;
    private Locator locator;
    private List swfData = new ArrayList();
    private SWFFileHeader fileHeader = new SWFFileHeader();
    private Map context = new HashMap();
    static /* synthetic */ Class class$de$tivano$flash$swf$publisher$XMLRawDataHandler;
    static /* synthetic */ Class class$de$tivano$flash$swf$publisher$XMLShowFrameHandler;
    static /* synthetic */ Class class$de$tivano$flash$swf$publisher$XMLFontHandler;
    static /* synthetic */ Class class$de$tivano$flash$swf$publisher$XMLTextHandler;
    static /* synthetic */ Class class$de$tivano$flash$swf$publisher$XMLTextInputHandler;

    public SWFWriter(OutputStream out) {
        this(out, true);
    }

    public SWFWriter(OutputStream out, boolean close) {
        this();
        this.setOutputStream(out, close);
    }

    public SWFWriter() {
        this.setCurrentXMLHandler(this);
        this.registerElementHandler("RawData", class$de$tivano$flash$swf$publisher$XMLRawDataHandler == null ? (class$de$tivano$flash$swf$publisher$XMLRawDataHandler = SWFWriter.class$("de.tivano.flash.swf.publisher.XMLRawDataHandler")) : class$de$tivano$flash$swf$publisher$XMLRawDataHandler);
        this.registerElementHandler("ShowFrame", class$de$tivano$flash$swf$publisher$XMLShowFrameHandler == null ? (class$de$tivano$flash$swf$publisher$XMLShowFrameHandler = SWFWriter.class$("de.tivano.flash.swf.publisher.XMLShowFrameHandler")) : class$de$tivano$flash$swf$publisher$XMLShowFrameHandler);
        this.registerElementHandler("Font", class$de$tivano$flash$swf$publisher$XMLFontHandler == null ? (class$de$tivano$flash$swf$publisher$XMLFontHandler = SWFWriter.class$("de.tivano.flash.swf.publisher.XMLFontHandler")) : class$de$tivano$flash$swf$publisher$XMLFontHandler);
        this.registerElementHandler("Text", class$de$tivano$flash$swf$publisher$XMLTextHandler == null ? (class$de$tivano$flash$swf$publisher$XMLTextHandler = SWFWriter.class$("de.tivano.flash.swf.publisher.XMLTextHandler")) : class$de$tivano$flash$swf$publisher$XMLTextHandler);
        this.registerElementHandler("TextInput", class$de$tivano$flash$swf$publisher$XMLTextInputHandler == null ? (class$de$tivano$flash$swf$publisher$XMLTextInputHandler = SWFWriter.class$("de.tivano.flash.swf.publisher.XMLTextInputHandler")) : class$de$tivano$flash$swf$publisher$XMLTextInputHandler);
    }

    public void setOutputStream(OutputStream out) {
        this.setOutputStream(out, false);
    }

    public void setOutputStream(OutputStream out, boolean close) {
        this.out = new BitOutputStream(out);
        this.closeOut = close;
    }

    public void setCurrentXMLHandler(XMLHandlerBase handler) {
        this.currentHandler = handler;
    }

    protected SWFWriter getSWFWriter() {
        return this;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        if (this.out == null) {
            throw new IllegalStateException("No output stream specified!");
        }
        Iterator data = this.swfData.iterator();
        SWFTagHeader endTag = new SWFTagHeader(0, 0L);
        long totalSize = endTag.length() / 8L;
        int frameCount = 0;
        while (data.hasNext()) {
            SWFTagWriter tag = (SWFTagWriter)data.next();
            try {
                totalSize += tag.getTotalLength();
            }
            catch (Exception e) {
                if (e instanceof SAXException) {
                    throw (SAXException)e;
                }
                throw new SWFWriterException(e.getMessage(), this.getDocumentLocator(), e);
            }
            if (tag.getTypeID() != 1) continue;
            ++frameCount;
        }
        try {
            this.fileHeader.setFrameCount(frameCount);
            this.fileHeader.setFileSize(totalSize + this.fileHeader.length() / 8L);
            this.fileHeader.write(this.out);
            data = this.swfData.iterator();
            while (data.hasNext()) {
                ((SWFTagWriter)data.next()).write(this.out);
            }
            endTag.write(this.out);
            if (this.closeOut) {
                this.out.close();
            } else {
                this.out.padAndFlush();
            }
        }
        catch (IOException e) {
            throw new SWFWriterException("Error writing data", this.locator, e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.currentHandler.dispatch(localName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.currentHandler.endElementInternal();
    }

    protected void dispatch(String name, Attributes attrib) throws SWFWriterException {
        if (name.equals("SWF")) {
            this.startElementInternal(name, attrib, this);
        } else {
            super.dispatch(name, attrib);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentHandler.handleText(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    protected void dispatchDefault(String name, Attributes attrib) throws SWFWriterException {
        throw new SWFWriterException("Unknown element: " + name, this.locator);
    }

    public void addData(SWFTagWriter data) {
        this.swfData.add(data);
    }

    public int getFlashVersion() {
        return this.fileHeader.getVersion();
    }

    protected void startElement(String name, Attributes attrib) throws SWFWriterException {
        if (!name.equals("SWF")) {
            this.fatalError("Illegal element for this handler: " + name);
        }
        this.fileHeader.setVersion(Integer.parseInt(attrib.getValue("", "version")));
        this.fileHeader.setFrameRate(Double.parseDouble(attrib.getValue("", "framerate")));
        String tmp = attrib.getValue("", "x");
        double x = (tmp != null ? Double.parseDouble(tmp) : 0.0) * 20.0;
        tmp = attrib.getValue("", "y");
        double y = (tmp != null ? Double.parseDouble(tmp) : 0.0) * 20.0;
        double width = Double.parseDouble(attrib.getValue("", "width")) * 20.0;
        double height = Double.parseDouble(attrib.getValue("", "height")) * 20.0;
        this.fileHeader.setMovieSize(new SWFRectangle((int)Math.round(x), (int)Math.round(x + width), (int)Math.round(y), (int)Math.round(y + height)));
    }

    protected Map getContextMap() {
        return this.context;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

