/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.publisher;

import java.io.IOException;
import java.io.OutputStream;

public class Base64Decoder {
    OutputStream out;
    int buffer = 0;
    int validBits = 0;

    public Base64Decoder(OutputStream out) {
        this.out = out;
    }

    public void write(char[] data, int start, int length) throws IOException {
        int i = start;
        while (i < start + length) {
            this.write(data[i]);
            ++i;
        }
    }

    public void write(char data) throws IOException {
        int value;
        if (data >= 'A' && data <= 'Z') {
            value = data - 65;
        } else if (data >= 'a' && data <= 'z') {
            value = (byte)(data - 97 + 26);
        } else if (data >= '0' && data <= '9') {
            value = (byte)(data - 48 + 52);
        } else if (data == '+') {
            value = 62;
        } else if (data == '/') {
            value = 63;
        } else {
            if (data == '=') {
                return;
            }
            if (Character.isSpace(data)) {
                return;
            }
            throw new IllegalArgumentException("Not a legal base64 character: " + data);
        }
        this.validBits += 6;
        this.buffer <<= 6;
        this.buffer |= value & 0x3F;
        if (this.validBits == 24) {
            this.out.write(this.buffer >>> 16 & 0xFF);
            this.out.write(this.buffer >>> 8 & 0xFF);
            this.out.write(this.buffer & 0xFF);
            this.buffer = 0;
            this.validBits = 0;
        }
    }

    public void close() throws IOException {
        this.writeRemaining();
        this.out.close();
    }

    public void flush() throws IOException {
        this.writeRemaining();
        this.buffer = 0;
        this.validBits = 0;
        this.out.flush();
    }

    private void writeRemaining() throws IOException {
        switch (this.validBits) {
            case 18: {
                this.out.write(this.buffer >>> 8 & 0xFF);
                this.out.write(this.buffer & 0xFF);
                break;
            }
            case 12: {
                this.out.write(this.buffer & 0xFF);
                break;
            }
            case 6: {
                this.buffer <<= 2;
                this.out.write(this.buffer & 0xFF);
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException("Got " + this.validBits + " bits left at the end of decoding. " + "This should never happen. Please debug.");
            }
        }
    }
}

