/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.parser;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.SWFTagHeader;
import de.tivano.flash.swf.parser.SWFAttributes;
import de.tivano.flash.swf.parser.SWFReader;
import de.tivano.flash.swf.parser.SWFTagReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class SWFTagReaderBase
implements SWFTagReader {
    private static final Attributes EMPTY_ATTRIBUTES = new SWFAttributes();
    private SWFReader saxDriver = null;

    public void setSAXDriver(SWFReader driver) {
        this.saxDriver = driver;
    }

    protected SWFReader getSAXDriver() {
        if (this.saxDriver == null) {
            throw new IllegalStateException("No SWFReader associated with this SWFTagReader");
        }
        return this.saxDriver;
    }

    protected void startElement(String name, Attributes attrib) throws SAXException {
        if (attrib == null) {
            attrib = EMPTY_ATTRIBUTES;
        }
        this.getSAXDriver().getContentHandler().startElement("", name, name, attrib);
    }

    protected void emptyElement(String name, Attributes attrib) throws SAXException {
        this.startElement(name, attrib);
        this.endElement(name);
    }

    protected void endElement(String name) throws SAXException {
        this.getSAXDriver().getContentHandler().endElement("", name, name);
    }

    protected void characters(char[] ch, int start, int length) throws SAXException {
        this.getSAXDriver().getContentHandler().characters(ch, start, length);
    }

    protected void characters(char[] ch) throws SAXException {
        this.characters(ch, 0, ch.length);
    }

    protected SWFAttributes createAttributes() {
        return new SWFAttributes();
    }

    public abstract void parse(BitInputStream var1, SWFTagHeader var2) throws SAXException, IOException;

    protected Map getContextMap() {
        return this.getSAXDriver().getContextMap();
    }

    protected OutputStream getRawDataOutputStream() {
        return new Base64DataOutputStream();
    }

    protected void warning(String msg) throws SAXException {
        try {
            this.getSAXDriver().getErrorHandler().warning(this.createSAXParseException(msg));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void error(String msg) throws SAXException {
        this.getSAXDriver().getErrorHandler().error(this.createSAXParseException(msg));
    }

    protected void fatalError(String msg) throws SAXException {
        this.getSAXDriver().getErrorHandler().fatalError(this.createSAXParseException(msg));
    }

    private SAXParseException createSAXParseException(String msg) {
        return new SAXParseException(msg, null);
    }

    protected double fromTwips(double value) {
        return value / 20.0;
    }

    private class Base64DataOutputStream
    extends OutputStream {
        private final char[] BASE64_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        private final int LINE_LENGTH = 76;
        char[] buffer = new char[77];
        private int bufPos = 0;
        private int currentTriplet = 0;
        private int bytesLeft = 0;

        private Base64DataOutputStream() {
        }

        public void write(int b) throws IOException {
            ++this.bytesLeft;
            this.currentTriplet <<= 8;
            this.currentTriplet |= b & 0xFF;
            if (this.bytesLeft == 3) {
                this.buffer[this.bufPos++] = this.BASE64_TABLE[this.currentTriplet >>> 18 & 0x3F];
                this.buffer[this.bufPos++] = this.BASE64_TABLE[this.currentTriplet >>> 12 & 0x3F];
                this.buffer[this.bufPos++] = this.BASE64_TABLE[this.currentTriplet >>> 6 & 0x3F];
                this.buffer[this.bufPos++] = this.BASE64_TABLE[this.currentTriplet & 0x3F];
                this.bytesLeft = 0;
                if (this.bufPos == 76) {
                    this.buffer[this.bufPos++] = 10;
                    try {
                        SWFTagReaderBase.this.characters(this.buffer, 0, this.bufPos);
                    }
                    catch (SAXException e) {
                        throw new SAXIOException(e);
                    }
                    this.bufPos = 0;
                }
            }
        }

        public void flush() throws IOException {
            switch (this.bytesLeft) {
                case 2: {
                    this.buffer[this.bufPos++] = this.BASE64_TABLE[this.currentTriplet >>> 12 & 0x3F];
                    this.buffer[this.bufPos++] = this.BASE64_TABLE[this.currentTriplet >>> 6 & 0x3F];
                    this.buffer[this.bufPos++] = this.BASE64_TABLE[this.currentTriplet & 0x3F];
                    this.buffer[this.bufPos++] = 61;
                    break;
                }
                case 1: {
                    this.buffer[this.bufPos++] = this.BASE64_TABLE[this.currentTriplet >>> 6 & 0x3F];
                    this.buffer[this.bufPos++] = this.BASE64_TABLE[this.currentTriplet & 0x3F];
                    this.buffer[this.bufPos++] = 61;
                    this.buffer[this.bufPos++] = 61;
                }
            }
            this.buffer[this.bufPos++] = 10;
            try {
                SWFTagReaderBase.this.characters(this.buffer, 0, this.bufPos);
            }
            catch (SAXException e) {
                throw new SAXIOException(e);
            }
            this.bufPos = 0;
            this.bytesLeft = 0;
        }

        public void close() throws IOException {
            this.flush();
        }
    }

    public static class SAXIOException
    extends IOException {
        private final SAXException CAUSE;

        public SAXIOException(SAXException cause) {
            super(cause.getMessage());
            this.CAUSE = cause;
        }

        public SAXException getSAXCause() {
            return this.CAUSE;
        }
    }
}

