/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.parser;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.SWFFileHeader;
import de.tivano.flash.swf.common.SWFFormatException;
import de.tivano.flash.swf.common.SWFTagHeader;
import de.tivano.flash.swf.parser.SWFAnyTagReader;
import de.tivano.flash.swf.parser.SWFAttributes;
import de.tivano.flash.swf.parser.SWFDefineFont2Reader;
import de.tivano.flash.swf.parser.SWFDefineFontInfoReader;
import de.tivano.flash.swf.parser.SWFDefineFontReader;
import de.tivano.flash.swf.parser.SWFDefineTextFieldReader;
import de.tivano.flash.swf.parser.SWFIgnoreTagReader;
import de.tivano.flash.swf.parser.SWFShowFrameReader;
import de.tivano.flash.swf.parser.SWFTagReader;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class SWFReader
implements XMLReader {
    private XMLReader xmlReader = null;
    private ContentHandler contentHandler = null;
    private DTDHandler dtdHandler = null;
    private ErrorHandler errorHandler = null;
    private EntityResolver entityResolver = null;
    private Map tagReaderMap = new HashMap();
    private Map context = new HashMap();
    public final Integer TAGID_DEFAULT = new Integer(-1);

    public SWFReader() {
        this.registerTagReader(this.TAGID_DEFAULT, (SWFTagReader)new SWFAnyTagReader());
        this.registerTagReader(0, (SWFTagReader)new SWFIgnoreTagReader());
        this.registerTagReader(1, (SWFTagReader)new SWFShowFrameReader());
        this.registerTagReader(48, (SWFTagReader)new SWFDefineFont2Reader());
        this.registerTagReader(10, (SWFTagReader)new SWFDefineFontReader());
        this.registerTagReader(13, (SWFTagReader)new SWFDefineFontInfoReader());
        this.registerTagReader(37, (SWFTagReader)new SWFDefineTextFieldReader());
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.xmlReader != null) {
            return this.xmlReader.getFeature(name);
        }
        throw new SAXNotRecognizedException(name);
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.xmlReader == null) {
            throw new SAXNotRecognizedException(name);
        }
        this.xmlReader.setFeature(name, value);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.xmlReader != null) {
            return this.xmlReader.getProperty(name);
        }
        throw new SAXNotRecognizedException(name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.xmlReader == null) {
            throw new SAXNotRecognizedException(name);
        }
        this.xmlReader.setProperty(name, value);
    }

    public void setEntityResolver(EntityResolver resolver) {
        if (resolver == null) {
            throw new NullPointerException();
        }
        this.entityResolver = resolver;
        if (this.xmlReader != null) {
            this.xmlReader.setEntityResolver(resolver);
        }
    }

    public EntityResolver getEntityResolver() {
        if (this.xmlReader != null) {
            return this.xmlReader.getEntityResolver();
        }
        return this.entityResolver;
    }

    public void setDTDHandler(DTDHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.dtdHandler = handler;
        if (this.xmlReader != null) {
            this.xmlReader.setDTDHandler(handler);
        }
    }

    public DTDHandler getDTDHandler() {
        if (this.xmlReader != null) {
            return this.xmlReader.getDTDHandler();
        }
        return this.dtdHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.contentHandler = handler;
        if (this.xmlReader != null) {
            this.xmlReader.setContentHandler(handler);
        }
    }

    public ContentHandler getContentHandler() {
        if (this.xmlReader != null) {
            return this.xmlReader.getContentHandler();
        }
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.errorHandler = handler;
        if (this.xmlReader != null) {
            this.xmlReader.setErrorHandler(handler);
        }
    }

    public ErrorHandler getErrorHandler() {
        if (this.xmlReader != null) {
            return this.xmlReader.getErrorHandler();
        }
        return this.errorHandler;
    }

    private void delegateParsing(InputSource input) throws SAXException, IOException {
        if (this.xmlReader == null) {
            throw new SAXException("Cannot handle XML input without a wrapped XMLReader");
        }
        this.xmlReader.parse(input);
    }

    public void parse(InputSource input) throws IOException, SAXException {
        InputStream in = input.getByteStream();
        if (input.getCharacterStream() != null) {
            this.delegateParsing(input);
        } else if (in == null) {
            in = new FileInputStream(input.getSystemId());
        }
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
            input.setByteStream(in);
        }
        byte[] buffer = new byte[29];
        in.mark(29);
        in.read(buffer);
        in.reset();
        try {
            SWFFileHeader dummy = new SWFFileHeader(buffer);
        }
        catch (SWFFormatException e) {
            this.delegateParsing(input);
        }
        BitInputStream bits = new BitInputStream(in);
        try {
            this.parse(bits);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            bits.close();
            throw throwable;
        }
        bits.close();
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    private void parse(BitInputStream input) throws IOException, SAXException {
        ContentHandler handler = this.getContentHandler();
        handler.startDocument();
        this.parseStartOfFile(input);
        try {
            while (true) {
                SWFTagHeader nextTag = new SWFTagHeader(input);
                this.getTagReader(nextTag).parse(input, nextTag);
            }
        }
        catch (EOFException eOFException) {
            this.parseEndOfFile(input);
            handler.endDocument();
            return;
        }
    }

    protected void parseStartOfFile(BitInputStream input) throws IOException, SAXException {
        ContentHandler handler = this.getContentHandler();
        SWFFileHeader header = new SWFFileHeader(input);
        SWFAttributes attr = new SWFAttributes();
        attr.addAttribute("version", header.getVersion());
        attr.addAttribute("framerate", header.getFrameRate());
        double x = (double)header.getMovieSize().getXMin() / 20.0;
        double y = (double)header.getMovieSize().getYMin() / 20.0;
        double width = (double)header.getMovieSize().getXMax() / 20.0 - x;
        double height = (double)header.getMovieSize().getYMax() / 20.0 - y;
        attr.addAttribute("width", width);
        attr.addAttribute("height", height);
        if (x != 0.0 || y != 0.0) {
            attr.addAttribute("x", x);
            attr.addAttribute("y", y);
        }
        handler.startElement("", "SWF", "SWF", attr);
    }

    protected void parseEndOfFile(BitInputStream input) throws IOException, SAXException {
        this.getContentHandler().endElement("", "SWF", "SWF");
    }

    public SWFTagReader registerTagReader(Integer tagID, SWFTagReader handler) {
        handler.setSAXDriver(this);
        return this.tagReaderMap.put(tagID, handler);
    }

    public SWFTagReader registerTagReader(int tagID, SWFTagReader handler) {
        return this.registerTagReader(new Integer(tagID), handler);
    }

    public SWFTagReader getTagReader(Integer tagID) {
        SWFTagReader reader = (SWFTagReader)this.tagReaderMap.get(tagID);
        if (reader == null) {
            reader = (SWFTagReader)this.tagReaderMap.get(this.TAGID_DEFAULT);
        }
        if (reader == null) {
            throw new IllegalStateException("No default SWF tag reader registered. This should never happen.");
        }
        return reader;
    }

    public SWFTagReader getTagReader(SWFTagHeader header) {
        SWFTagReader reader = (SWFTagReader)this.tagReaderMap.get(header.getIDAsInteger());
        if (reader == null) {
            reader = (SWFTagReader)this.tagReaderMap.get(this.TAGID_DEFAULT);
        }
        return reader;
    }

    protected Map getContextMap() {
        return this.context;
    }
}

