/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFFillStyle;
import de.tivano.flash.swf.common.SWFFormatException;
import de.tivano.flash.swf.common.SWFLineStyle;
import de.tivano.flash.swf.common.SWFMoveTo;
import de.tivano.flash.swf.common.SWFShapeRecord;
import java.io.EOFException;
import java.io.IOException;

public class SWFStateChange
extends SWFShapeRecord {
    protected static final int TYPE_MOVE_TO = 1;
    protected static final int TYPE_FILL_STYLE_0 = 2;
    protected static final int TYPE_FILL_STYLE_1 = 4;
    protected static final int TYPE_LINE_STYLE = 8;
    protected static final int TYPE_DEFINE_STYLE = 16;
    private static final SWFFillStyle[] EMPTY_FILL_STYLES = new SWFFillStyle[0];
    private static final SWFLineStyle[] EMPTY_LINE_STYLES = new SWFLineStyle[0];
    private int type;
    private int fillBits = 0;
    private int lineBits = 0;
    private int newStyleFillBits = 0;
    private int newStyleLineBits = 0;
    private SWFMoveTo moveTo = null;
    private int fillStyle0 = 0;
    private int fillStyle1 = 0;
    private int lineStyle = 0;
    private SWFFillStyle[] fillStyles = EMPTY_FILL_STYLES;
    private SWFLineStyle[] lineStyles = EMPTY_LINE_STYLES;

    public SWFStateChange(BitInputStream input, int fillBits, int lineBits, boolean useRGBA) throws IOException {
        try {
            this.fillBits = fillBits;
            this.lineBits = lineBits;
            this.type = (int)input.readUBits(5);
            if ((this.type & 1) != 0) {
                this.moveTo = new SWFMoveTo(input);
            }
            if ((this.type & 2) != 0) {
                this.fillStyle0 = (int)input.readUBits(fillBits);
            }
            if ((this.type & 4) != 0) {
                this.fillStyle1 = (int)input.readUBits(fillBits);
            }
            if ((this.type & 8) != 0) {
                this.lineStyle = (int)input.readUBits(lineBits);
            }
            if ((this.type & 0x10) != 0) {
                int count = input.readUByte();
                if (count == 255) {
                    count = input.readUW16LSB();
                }
                this.fillStyles = new SWFFillStyle[count];
                int i = 0;
                while (i < count) {
                    this.fillStyles[i] = SWFFillStyle.parse(input, useRGBA);
                    ++i;
                }
                count = input.readUByte();
                if (count == 255) {
                    count = input.readUW16LSB();
                }
                this.lineStyles = new SWFLineStyle[count];
                int i2 = 0;
                while (i2 < count) {
                    this.lineStyles[i2] = SWFLineStyle.parse(input, useRGBA);
                    ++i2;
                }
                this.newStyleFillBits = (int)input.readUBits(4);
                this.newStyleLineBits = (int)input.readUBits(4);
            }
        }
        catch (EOFException e) {
            throw new SWFFormatException("Could not read a complete state change record.");
        }
    }

    public boolean isEndOfShape() {
        return this.type == 0;
    }

    public boolean hasMoveTo() {
        return (this.type & 1) != 0;
    }

    public boolean hasFillStyle0() {
        return (this.type & 2) != 0;
    }

    public boolean hasFillStyle1() {
        return (this.type & 4) != 0;
    }

    public boolean hasLineStyle() {
        return (this.type & 8) != 0;
    }

    public boolean hasNewStyles() {
        return (this.type & 0x10) != 0;
    }

    public SWFMoveTo getMoveTo() {
        return this.moveTo;
    }

    public int getFillStyle0() {
        return this.fillStyle0;
    }

    public int getFillStyle1() {
        return this.fillStyle1;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public int getFillStyleCount() {
        return this.fillStyles.length;
    }

    public SWFFillStyle getNewFillStyle(int idx) {
        return this.fillStyles[idx];
    }

    public int getFillBits() {
        return this.fillBits;
    }

    public int getNewStyleFillBits() {
        return this.newStyleFillBits;
    }

    public int getLineStyleCount() {
        return this.lineStyles.length;
    }

    public SWFLineStyle getNewLineStyle(int idx) {
        return this.lineStyles[idx];
    }

    public int getLineBits() {
        return this.lineBits;
    }

    public int getNewStyleLineBits() {
        return this.newStyleLineBits;
    }

    public long length() {
        int length = 6;
        if (this.hasMoveTo()) {
            length = (int)((long)length + this.getMoveTo().length());
        }
        if (this.hasFillStyle0()) {
            length += this.fillBits;
        }
        if (this.hasFillStyle1()) {
            length += this.fillBits;
        }
        if (this.hasLineStyle()) {
            length += this.lineBits;
        }
        if (this.hasNewStyles()) {
            length += 16;
            if (this.getFillStyleCount() >= 255) {
                length += 16;
            }
            if (this.getLineStyleCount() >= 255) {
                length += 16;
            }
            int i = 0;
            while (i < this.getFillStyleCount()) {
                length = (int)((long)length + this.getNewFillStyle(i).length());
                ++i;
            }
            int i2 = 0;
            while (i2 < this.getLineStyleCount()) {
                length = (int)((long)length + this.getNewLineStyle(i2).length());
                ++i2;
            }
        }
        return length;
    }

    public void write(BitOutputStream out) throws IOException {
        out.writeBits(0L, 1);
        out.writeBit(this.hasNewStyles());
        out.writeBit(this.hasLineStyle());
        out.writeBit(this.hasFillStyle1());
        out.writeBit(this.hasFillStyle0());
        out.writeBit(this.hasMoveTo());
        if (this.hasMoveTo()) {
            this.getMoveTo().write(out);
        }
        if (this.hasFillStyle0()) {
            out.writeBits(this.getFillStyle0(), this.fillBits);
        }
        if (this.hasFillStyle1()) {
            out.writeBits(this.getFillStyle1(), this.fillBits);
        }
        if (this.hasLineStyle()) {
            out.writeBits(this.getLineStyle(), this.lineBits);
        }
        if (this.hasNewStyles()) {
            if (this.getFillStyleCount() >= 255) {
                out.writeBits(255L, 8);
                out.writeW16LSB(this.getFillStyleCount());
            } else {
                out.writeBits(this.getFillStyleCount(), 8);
            }
            int i = 0;
            while (i < this.getFillStyleCount()) {
                this.getNewFillStyle(i).write(out);
                ++i;
            }
            if (this.getLineStyleCount() >= 255) {
                out.writeBits(255L, 8);
                out.writeW16LSB(this.getLineStyleCount());
            } else {
                out.writeBits(this.getLineStyleCount(), 8);
            }
            int i2 = 0;
            while (i2 < this.getLineStyleCount()) {
                this.getNewLineStyle(i2).write(out);
                ++i2;
            }
            out.writeBits(this.getFillBits(), 4);
            out.writeBits(this.getLineBits(), 4);
        }
    }
}

