/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFDataType;
import de.tivano.flash.swf.common.SWFDataTypeBase;
import de.tivano.flash.swf.common.SWFFormatException;
import de.tivano.flash.swf.common.SWFShapeRecord;
import de.tivano.flash.swf.common.SWFStateChange;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class SWFShape
extends SWFDataTypeBase {
    private final int FILL_BITS;
    private final int LINE_BITS;
    private ArrayList records = new ArrayList();
    public int rawSize;

    public SWFShape(BitInputStream input, boolean useRGBA) throws IOException {
        try {
            SWFShapeRecord record;
            this.FILL_BITS = (int)input.readUBits(4);
            this.LINE_BITS = (int)input.readUBits(4);
            int currentFillBits = this.FILL_BITS;
            int currentLineBits = this.LINE_BITS;
            do {
                SWFStateChange s;
                if ((record = SWFShapeRecord.parse(input, currentFillBits, currentLineBits, useRGBA)) instanceof SWFStateChange && (s = (SWFStateChange)record).hasNewStyles()) {
                    currentFillBits = s.getNewStyleFillBits();
                    currentLineBits = s.getNewStyleLineBits();
                }
                this.records.add(record);
            } while (!(record instanceof SWFStateChange) || !((SWFStateChange)record).isEndOfShape());
        }
        catch (EOFException e) {
            throw new SWFFormatException("Premature end of file encoutered while reading a shape");
        }
    }

    public SWFShape(byte[] input, boolean useRGBA) throws IOException {
        this(new BitInputStream(new ByteArrayInputStream(input)), useRGBA);
        this.rawSize = input.length;
    }

    public Iterator getShapeRecords() {
        return new ReadOnlyIterator(((AbstractList)this.records).iterator());
    }

    public long length() {
        long length = 8L;
        Iterator entries = this.getShapeRecords();
        while (entries.hasNext()) {
            length += ((SWFDataType)entries.next()).length();
        }
        return length;
    }

    public void write(BitOutputStream out) throws IOException {
        out.writeBits(this.FILL_BITS, 4);
        out.writeBits(this.LINE_BITS, 4);
        Iterator entries = this.getShapeRecords();
        while (entries.hasNext()) {
            ((SWFDataType)entries.next()).write(out);
        }
    }

    private static class ReadOnlyIterator
    implements Iterator {
        private final Iterator DELEGATE;

        public ReadOnlyIterator(Iterator delegate) {
            this.DELEGATE = delegate;
        }

        public boolean hasNext() {
            return this.DELEGATE.hasNext();
        }

        public Object next() {
            return this.DELEGATE.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

