/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.SWFDefineFont2;
import de.tivano.flash.swf.common.SWFRectangle;
import de.tivano.flash.swf.common.SWFShape;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SWFFont {
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNKNOWN = 0;
    public static final int ANSI = 1;
    public static final int SHIFT_JIS = 2;
    public static final int UNICODE = 3;
    private Map encodingTable = new HashMap();
    private List glyphTable = new ArrayList();
    private List kerningTable = new ArrayList();
    private int fontID;
    private String fontName;
    private int layout;
    int encoding;
    private int ascent;
    private int descent;
    private int leading;
    private boolean hasMetrics = false;

    public boolean hasMetrics() {
        return this.hasMetrics;
    }

    public int getAscent() {
        return this.ascent;
    }

    public void setAscent(int ascent) {
        this.ascent = ascent;
        this.hasMetrics = true;
    }

    public int getDescent() {
        return this.descent;
    }

    public void setDescent(int descent) {
        this.descent = descent;
        this.hasMetrics = true;
    }

    public int getLeading() {
        return this.leading;
    }

    public void setLeading(int leading) {
        this.leading = leading;
        this.hasMetrics = true;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public static String getCanonicalEncodingName(int encoding) {
        switch (encoding) {
            case 1: {
                return "ISO-8859-1";
            }
            case 3: {
                return "UTF-16BE";
            }
            case 2: {
                return "SJIS";
            }
        }
        throw new IllegalStateException("Illegal font encoding: " + encoding);
    }

    public String getCanonicalEncodingName() {
        return SWFFont.getCanonicalEncodingName(this.getEncoding());
    }

    public void setEncoding(int encoding) {
        switch (encoding) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.encoding = encoding;
                return;
            }
        }
        throw new IllegalArgumentException("Illegal font encoding: " + encoding);
    }

    public int getLayout() {
        return this.layout;
    }

    public void setLayout(int layout) {
        if ((layout & 0xFFFFFFFC) != 0) {
            throw new IllegalArgumentException(layout + " is not a combination of SWFFont.BOLD and SWFFont.ITALIC");
        }
        this.layout = layout;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String name) {
        this.fontName = name;
    }

    public int getFontID() {
        return this.fontID;
    }

    public void setFontID(int id) {
        this.fontID = id;
    }

    protected Glyph getGlyph(int index) {
        return (Glyph)this.glyphTable.get(index);
    }

    protected Glyph getGlyph(Character c) {
        return (Glyph)this.encodingTable.get(c);
    }

    protected Glyph createGlyph(boolean marked) {
        return new Glyph(marked);
    }

    public void addGlyph(Character charcode, int advance, SWFRectangle bounds, SWFShape shape, boolean marked) {
        Glyph glyph = this.createGlyph(marked);
        glyph.setCharacter(charcode);
        glyph.setAdvance(advance);
        glyph.setBounds(bounds);
        glyph.setShape(shape);
    }

    public void addGlyph(Character charcode, SWFShape shape, boolean marked) {
        Glyph glyph = this.createGlyph(marked);
        glyph.setCharacter(charcode);
        glyph.setShape(shape);
    }

    public void addGlyph(Character charcode, int advance, boolean marked) {
        Glyph glyph = this.createGlyph(marked);
        glyph.setCharacter(charcode);
        glyph.setAdvance(advance);
    }

    public void addGlyph(String charcode, int advance, boolean marked) {
        this.addGlyph(new Character(charcode.charAt(0)), advance, marked);
    }

    public void addGlyph() {
        Glyph glyph = this.createGlyph(true);
    }

    public void addGlyph(Character charcode, boolean marked) {
        Glyph glyph = this.createGlyph(marked);
        glyph.setCharacter(charcode);
    }

    public void addGlyph(String charcode, boolean marked) {
        Glyph glyph = this.createGlyph(marked);
        glyph.setCharacter(new Character(charcode.charAt(0)));
    }

    public int getGlyphIndex(char c) {
        return this.getGlyphIndex(new Character(c));
    }

    public int getGlyphIndex(Character c) {
        Glyph glyph = this.getGlyph(c);
        if (glyph == null) {
            return -1;
        }
        return glyph.getIndex();
    }

    public void markUsed(char c) {
        this.getGlyphIndex(c);
    }

    public void markUsed(StringBuffer str) {
        int i = 0;
        while (i < str.length()) {
            this.markUsed(str.charAt(i));
            ++i;
        }
    }

    public Character getCharCode(int glyph) {
        return this.getGlyph(glyph).getCharacter();
    }

    public void setCharCode(int glyph, Character charcode) {
        this.getGlyph(glyph).setCharacter(charcode);
    }

    public void setCharCode(int glyph, String charcode) {
        this.setCharCode(glyph, new Character(charcode.charAt(0)));
    }

    public String decode(byte[] chars) throws UnsupportedEncodingException {
        return new String(chars, this.getCanonicalEncodingName());
    }

    public byte[] encode(String input) throws UnsupportedEncodingException {
        return input.getBytes(this.getCanonicalEncodingName());
    }

    public byte[] encode(Character input) throws UnsupportedEncodingException {
        return input.toString().getBytes(this.getCanonicalEncodingName());
    }

    public int getAdvance(int glyph) {
        return this.getGlyph(glyph).getAdvance();
    }

    public SWFRectangle getBounds(int glyph) {
        return this.getGlyph(glyph).getBounds();
    }

    public SWFShape getShape(int glyph) {
        return this.getGlyph(glyph).getShape();
    }

    public int glyphCount() {
        return this.glyphTable.size();
    }

    public void addKerningInfo(String pair, int kern) throws UnsupportedEncodingException {
        this.hasMetrics = true;
        byte[] c1 = pair.substring(0, 1).getBytes(this.getCanonicalEncodingName());
        byte[] c2 = pair.substring(1, 2).getBytes(this.getCanonicalEncodingName());
        this.kerningTable.add(new SWFDefineFont2.KerningRecord(c1, c2, kern));
    }

    public int kerningCount() {
        return this.kerningTable.size();
    }

    public SWFDefineFont2.KerningRecord getKerningInfo(int n) {
        return (SWFDefineFont2.KerningRecord)this.kerningTable.get(n);
    }

    protected class Glyph {
        private int advance = 0;
        private Character character = null;
        private int index;
        private SWFShape shape = null;
        private SWFRectangle bounds = null;

        private Glyph(boolean addToTable) {
            if (addToTable) {
                this.index = SWFFont.this.glyphTable.size();
                SWFFont.this.glyphTable.add(this);
            } else {
                this.index = -1;
            }
        }

        public int getIndex() {
            if (this.index < 0) {
                this.index = SWFFont.this.glyphTable.size();
                SWFFont.this.glyphTable.add(this);
            }
            return this.index;
        }

        public Character getCharacter() {
            return this.character;
        }

        public void setCharacter(Character value) {
            Object entry = SWFFont.this.encodingTable.get(value);
            if (entry != null && entry != this) {
                throw new IllegalArgumentException("Encoding for '" + value + "' already present.");
            }
            if (this.character != null) {
                SWFFont.this.encodingTable.remove(this.character);
            }
            SWFFont.this.encodingTable.put(value, this);
            this.character = value;
        }

        public int getAdvance() {
            return this.advance;
        }

        public void setAdvance(int value) {
            this.advance = value;
            SWFFont.this.hasMetrics = true;
        }

        public SWFRectangle getBounds() {
            return this.bounds;
        }

        public void setBounds(SWFRectangle value) {
            this.bounds = value;
            SWFFont.this.hasMetrics |= value != null;
        }

        public SWFShape getShape() {
            return this.shape;
        }

        public void setShape(SWFShape value) {
            this.shape = value;
        }
    }
}

