/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFDataTypeBase;
import de.tivano.flash.swf.common.SWFFormatException;
import de.tivano.flash.swf.common.SWFRectangle;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;

public class SWFFileHeader
extends SWFDataTypeBase {
    public static final int MAX_LENGTH = 29;
    private static final byte[] SIGNATURE = new byte[]{70, 87, 83};
    private int version;
    private SWFRectangle boundingBox;
    private long fileSize;
    private int frameRate;
    private int frameCount;

    public SWFFileHeader(BitInputStream input) throws IOException {
        String FAIL_MSG = "Invalid SWF file header";
        if (!input.isAtByteBoundary()) {
            throw new SWFFormatException("The SWF file header must be byte-aligned");
        }
        byte[] signature = new byte[SIGNATURE.length];
        boolean failed = false;
        try {
            input.read(signature);
            this.version = input.readUByte();
            this.fileSize = input.readUW32LSB();
            this.boundingBox = new SWFRectangle(input);
            input.skipToByteBoundary();
            this.frameRate = input.readUW16LSB();
            this.frameCount = input.readUW16LSB();
        }
        catch (EOFException e) {
            throw new SWFFormatException("Invalid SWF file header");
        }
        catch (SWFFormatException e) {
            throw new SWFFormatException("Invalid SWF file header");
        }
        if (!Arrays.equals(signature, SIGNATURE)) {
            throw new SWFFormatException("Invalid SWF file header");
        }
    }

    public SWFFileHeader(byte[] input) throws IOException {
        this(new BitInputStream(new ByteArrayInputStream(input)));
    }

    public SWFFileHeader(int version, double frameRate, int frameCount, SWFRectangle movieSize) {
        this.version = version;
        this.frameRate = (int)SWFDataTypeBase.toFixed(frameRate);
        this.frameCount = frameCount;
        this.boundingBox = movieSize;
    }

    public SWFFileHeader() {
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public SWFRectangle getMovieSize() {
        return this.boundingBox;
    }

    public void setMovieSize(SWFRectangle bounds) {
        this.boundingBox = bounds;
    }

    public double getFrameRate() {
        return (double)this.frameRate / 256.0;
    }

    public int getFrameRateFixed() {
        return this.frameRate;
    }

    public void setFrameRate(double rate) {
        this.frameRate = (int)Math.round(rate * 256.0);
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public void setFrameCount(int count) {
        this.frameCount = count;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long size) {
        this.fileSize = size;
    }

    public long length() {
        return 96L + SWFDataTypeBase.paddedLength(this.getMovieSize().length());
    }

    public void write(BitOutputStream out) throws IOException {
        out.write(SIGNATURE);
        out.writeByte((byte)this.getVersion());
        out.writeW32LSB((int)this.getFileSize());
        this.getMovieSize().write(out);
        out.padToByteBoundary();
        out.writeW16LSB(this.getFrameRateFixed());
        out.writeW16LSB(this.getFrameCount());
    }
}

