/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFDataTypeBase;
import de.tivano.flash.swf.common.SWFFont;
import de.tivano.flash.swf.common.SWFFormatException;
import de.tivano.flash.swf.common.SWFRectangle;
import de.tivano.flash.swf.common.SWFShape;
import de.tivano.flash.swf.common.SWFTopLevelDataType;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class SWFDefineFont2
extends SWFDataTypeBase
implements SWFTopLevelDataType {
    public static final int TAG_TYPE = 48;
    private SWFShape[] shapeTable;
    private byte[][] codeTable;
    private int[] advanceTable;
    private SWFRectangle[] boundsTable;
    private KerningRecord[] kerningTable;
    private int layout = 0;
    private int encoding = 0;
    private String name = null;
    private int ascent = 0;
    private int descent = 0;
    private int leadingHeight = 0;
    private int fontID;
    private boolean hasLayoutInfo;
    private boolean hasWideCodes;

    public SWFDefineFont2(BitInputStream input) throws IOException {
        try {
            int i;
            this.fontID = input.readUW16LSB();
            this.hasLayoutInfo = input.readBit();
            int encodingRaw = (int)input.readUBits(3);
            switch (encodingRaw) {
                case 1: {
                    this.encoding = 1;
                    break;
                }
                case 2: {
                    this.encoding = 3;
                    break;
                }
                case 4: {
                    this.encoding = 2;
                    break;
                }
                default: {
                    throw new SWFFormatException("Illegal combination of font encoding flags encountered.");
                }
            }
            int offsetWidth = input.readBit() ? 32 : 16;
            this.hasWideCodes = input.readBit();
            if (input.readBit()) {
                this.layout |= 2;
            }
            if (input.readBit()) {
                this.layout |= 1;
            }
            input.skipBits(8L);
            byte[] nameRaw = new byte[input.readUByte()];
            input.read(nameRaw);
            this.name = new String(nameRaw, SWFFont.getCanonicalEncodingName(this.encoding));
            int glyphCount = input.readUW16LSB();
            this.shapeTable = new SWFShape[glyphCount];
            this.codeTable = new byte[glyphCount][this.hasWideCodes ? 2 : 1];
            this.advanceTable = new int[glyphCount];
            this.boundsTable = new SWFRectangle[glyphCount];
            input.skipBits((glyphCount + 1) * offsetWidth);
            int i2 = 0;
            while (i2 < this.shapeTable.length) {
                this.shapeTable[i2] = new SWFShape(input, false);
                input.skipToByteBoundary();
                ++i2;
            }
            int i3 = 0;
            while (i3 < this.codeTable.length) {
                if (this.hasWideCodes) {
                    this.codeTable[i3][1] = (byte)input.read();
                }
                this.codeTable[i3][0] = (byte)input.read();
                ++i3;
            }
            if (this.encoding == 2) {
                i = 0;
                while (i < this.codeTable.length) {
                    if (this.codeTable[i][0] == 0) {
                        byte[] newCode = new byte[]{this.codeTable[i][1]};
                        this.codeTable[i] = newCode;
                    }
                    ++i;
                }
            }
            if (this.hasGlyphLayout()) {
                this.ascent = input.readSW16LSB();
                this.descent = input.readSW16LSB();
                this.leadingHeight = input.readSW16LSB();
                i = 0;
                while (i < this.advanceTable.length) {
                    this.advanceTable[i] = input.readSW16LSB();
                    ++i;
                }
                int i4 = 0;
                while (i4 < this.boundsTable.length) {
                    this.boundsTable[i4] = new SWFRectangle(input);
                    input.skipToByteBoundary();
                    ++i4;
                }
                this.kerningTable = new KerningRecord[input.readUW16LSB()];
                int i5 = 0;
                while (i5 < this.kerningTable.length) {
                    byte[] char2;
                    byte[] char1;
                    if (this.hasWideCodes) {
                        char1 = new byte[]{(byte)input.readUByte(), (byte)input.readUByte()};
                        char2 = new byte[]{(byte)input.readUByte(), (byte)input.readUByte()};
                    } else {
                        char1 = new byte[]{(byte)input.readUByte()};
                        char2 = new byte[]{(byte)input.readUByte()};
                    }
                    this.kerningTable[i5] = new KerningRecord(char1, char2, input.readSW16LSB());
                    ++i5;
                }
            } else {
                this.kerningTable = new KerningRecord[0];
            }
        }
        catch (EOFException e) {
            throw new SWFFormatException("Premature end of file encoutered while reading a DefineFont2 tag");
        }
    }

    public SWFDefineFont2(SWFFont font) throws UnsupportedEncodingException {
        int i;
        int glyphCount = font.glyphCount();
        this.fontID = font.getFontID();
        this.name = font.getFontName();
        this.encoding = font.getEncoding();
        this.layout = font.getLayout();
        this.hasLayoutInfo = font.hasMetrics();
        this.shapeTable = new SWFShape[glyphCount];
        this.codeTable = new byte[glyphCount][];
        this.advanceTable = new int[glyphCount];
        this.boundsTable = new SWFRectangle[glyphCount];
        int i2 = 0;
        while (i2 < this.shapeTable.length) {
            this.shapeTable[i2] = font.getShape(i2);
            ++i2;
        }
        this.hasWideCodes = false;
        int i3 = 0;
        while (i3 < this.codeTable.length) {
            this.codeTable[i3] = font.encode(font.getCharCode(i3));
            this.hasWideCodes |= this.codeTable[i3].length > 1;
            ++i3;
        }
        if (this.hasLayoutInfo) {
            i = 0;
            while (i < glyphCount) {
                this.advanceTable[i] = font.getAdvance(i);
                this.boundsTable[i] = font.getBounds(i);
                ++i;
            }
            this.ascent = font.getAscent();
            this.descent = font.getDescent();
            this.leadingHeight = font.getLeading();
        }
        this.kerningTable = new KerningRecord[font.kerningCount()];
        i = 0;
        while (i < this.kerningTable.length) {
            this.kerningTable[i] = font.getKerningInfo(i);
            ++i;
        }
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getLeadingHeight() {
        return this.leadingHeight;
    }

    public boolean hasGlyphLayout() {
        return this.hasLayoutInfo;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public int getLayout() {
        return this.layout;
    }

    public String getName() {
        return this.name;
    }

    public int getID() {
        return this.fontID;
    }

    public int getGlyphCount() {
        return this.shapeTable.length;
    }

    public SWFShape getShape(int idx) {
        return this.shapeTable[idx];
    }

    public byte[] getCode(int idx) {
        return this.codeTable[idx];
    }

    public int getAdvance(int idx) {
        return this.advanceTable[idx];
    }

    public SWFRectangle getBounds(int idx) {
        return this.boundsTable[idx];
    }

    public int getKerningCount() {
        return this.kerningTable.length;
    }

    public KerningRecord getKerningRecord(int idx) {
        return this.kerningTable[idx];
    }

    public long length() {
        long length = 0L;
        int glyphCount = this.getGlyphCount();
        int charWidth = this.getCharWidth();
        int offsetWidth = 16;
        int i = 0;
        while (i < glyphCount) {
            long shapeLen = SWFDataTypeBase.paddedLength(this.getShape(i).length());
            length += shapeLen;
            if (shapeLen > 65535L) {
                offsetWidth = 32;
            }
            ++i;
        }
        length += (long)(56 + 8 * this.getName().length() + (glyphCount + 1) * offsetWidth + glyphCount * charWidth);
        if (this.hasGlyphLayout()) {
            int i2 = 0;
            while (i2 < glyphCount) {
                length += SWFDataTypeBase.paddedLength(this.getBounds(i2).length());
                ++i2;
            }
            length += (long)(64 + glyphCount * 16 + this.getKerningCount() * (2 * charWidth + 16));
        }
        return length;
    }

    private int getCharWidth() {
        return this.hasWideCodes ? 16 : 8;
    }

    public void write(BitOutputStream out) throws IOException {
        int glyphCount = this.getGlyphCount();
        boolean hasWideOffsets = false;
        int i = 0;
        while (i < glyphCount) {
            long shapeLen = SWFDataTypeBase.paddedLength(this.getShape(i).length());
            if (shapeLen > 65535L) {
                hasWideOffsets = true;
            }
            ++i;
        }
        out.writeW16LSB(this.getID());
        out.writeBit(this.hasGlyphLayout());
        switch (this.getEncoding()) {
            case 1: {
                out.writeBits(1L, 3);
                break;
            }
            case 3: {
                out.writeBits(2L, 3);
                break;
            }
            case 2: {
                out.writeBits(4L, 3);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal encoding value " + this.getEncoding() + " found. This should never happen. Please debug.");
            }
        }
        out.writeBit(hasWideOffsets);
        out.writeBit(this.getCharWidth() > 8);
        out.writeBit((this.getLayout() & 2) != 0);
        out.writeBit((this.getLayout() & 1) != 0);
        out.writeBits(0L, 8);
        byte[] nameRaw = this.getName().getBytes(SWFFont.getCanonicalEncodingName(this.getEncoding()));
        if (nameRaw.length > 255) {
            throw new IllegalStateException("Font name longer than 255 bytes found. This should never happen. Please debug.");
        }
        out.write(nameRaw.length);
        out.write(nameRaw);
        out.writeW16LSB(glyphCount);
        int offset = (hasWideOffsets ? 4 : 2) * (glyphCount + 1);
        if (hasWideOffsets) {
            out.writeW32LSB(offset);
        } else {
            out.writeW16LSB(offset);
        }
        int i2 = 0;
        while (i2 < glyphCount) {
            offset = (int)((long)offset + SWFDataTypeBase.paddedLength(this.getShape(i2).length()) / 8L);
            if (hasWideOffsets) {
                out.writeW32LSB(offset);
            } else {
                out.writeW16LSB(offset);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < glyphCount) {
            this.getShape(i3).write(out);
            out.padToByteBoundary();
            ++i3;
        }
        int i4 = 0;
        while (i4 < glyphCount) {
            byte[] code = this.getCode(i4);
            if (this.hasWideCodes && code.length == 1) {
                out.write(0);
            }
            out.write(code);
            ++i4;
        }
        if (this.hasGlyphLayout()) {
            out.writeW16LSB(this.getAscent());
            out.writeW16LSB(this.getDescent());
            out.writeW16LSB(this.getLeadingHeight());
            int i5 = 0;
            while (i5 < glyphCount) {
                out.writeW16LSB(this.getAdvance(i5));
                ++i5;
            }
            int i6 = 0;
            while (i6 < glyphCount) {
                this.getBounds(i6).write(out);
                out.padToByteBoundary();
                ++i6;
            }
            int kerningCount = this.getKerningCount();
            out.writeW16LSB(kerningCount);
            int i7 = 0;
            while (i7 < kerningCount) {
                KerningRecord entry = this.getKerningRecord(i7);
                out.write(entry.CHAR_1);
                out.write(entry.CHAR_2);
                out.writeW16LSB(entry.KERNING);
                ++i7;
            }
        }
    }

    public int getTagType() {
        return 48;
    }

    public static class KerningRecord {
        public final byte[] CHAR_1;
        public final byte[] CHAR_2;
        public final int KERNING;

        public KerningRecord(byte[] char1, byte[] char2, int kern) {
            this.CHAR_1 = char1;
            this.CHAR_2 = char2;
            this.KERNING = kern;
        }
    }
}

