/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFDataTypeBase;
import de.tivano.flash.swf.common.SWFFont;
import de.tivano.flash.swf.common.SWFFormatException;
import de.tivano.flash.swf.common.SWFShape;
import de.tivano.flash.swf.common.SWFTopLevelDataType;
import java.io.EOFException;
import java.io.IOException;

public class SWFDefineFont
extends SWFDataTypeBase
implements SWFTopLevelDataType {
    public static final int TAG_TYPE = 10;
    private SWFShape[] shapeTable;
    private int fontID;

    public SWFDefineFont(BitInputStream input) throws IOException {
        try {
            this.fontID = input.readUW16LSB();
            int glyphCount = input.readUW16LSB() / 2;
            this.shapeTable = new SWFShape[glyphCount];
            input.skipBits((glyphCount - 1) * 16);
            int i = 0;
            while (i < this.shapeTable.length) {
                this.shapeTable[i] = new SWFShape(input, false);
                input.skipToByteBoundary();
                ++i;
            }
        }
        catch (EOFException e) {
            throw new SWFFormatException("Premature end of file encoutered while reading a DefineFont tag");
        }
    }

    public SWFDefineFont(SWFFont font) {
        this.fontID = font.getFontID();
        this.shapeTable = new SWFShape[font.glyphCount()];
        int i = 0;
        while (i < this.shapeTable.length) {
            this.shapeTable[i] = font.getShape(i);
            ++i;
        }
    }

    public int getID() {
        return this.fontID;
    }

    public int getGlyphCount() {
        return this.shapeTable.length;
    }

    public SWFShape getShape(int idx) {
        return this.shapeTable[idx];
    }

    public long length() {
        int glyphCount = this.getGlyphCount();
        long shapeLength = 0L;
        int i = 0;
        while (i < glyphCount) {
            shapeLength += SWFDataTypeBase.paddedLength(this.getShape(i).length());
            ++i;
        }
        return (long)(16 + glyphCount * 16) + shapeLength;
    }

    public void write(BitOutputStream out) throws IOException {
        int glyphCount = this.getGlyphCount();
        out.writeW16LSB(this.getID());
        int offset = 2 * glyphCount;
        out.writeW16LSB(offset);
        int i = 0;
        while (i < glyphCount - 1) {
            offset = (int)((long)offset + SWFDataTypeBase.paddedLength(this.getShape(i).length()) / 8L);
            out.writeW16LSB(offset);
            ++i;
        }
        int i2 = 0;
        while (i2 < glyphCount) {
            this.getShape(i2).write(out);
            out.padToByteBoundary();
            ++i2;
        }
    }

    public int getTagType() {
        return 10;
    }
}

