/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFDataTypeBase;
import de.tivano.flash.swf.common.SWFFormatException;
import java.io.EOFException;
import java.io.IOException;

public class SWFColorRGB
extends SWFDataTypeBase {
    private final int RED;
    private final int GREEN;
    private final int BLUE;

    public SWFColorRGB(BitInputStream input) throws IOException {
        try {
            this.RED = input.readUByte();
            this.GREEN = input.readUByte();
            this.BLUE = input.readUByte();
        }
        catch (EOFException e) {
            throw new SWFFormatException("Premature end of file encoutered while reading a color structure");
        }
    }

    public SWFColorRGB(SWFColorRGB copy) {
        this.RED = copy.getRed();
        this.GREEN = copy.getGreen();
        this.BLUE = copy.getBlue();
    }

    public SWFColorRGB(String str) {
        try {
            if (str.length() < 6) {
                throw new IllegalArgumentException("Not a legal color representation: " + str);
            }
            this.RED = Integer.parseInt(str.substring(0, 2), 16);
            this.GREEN = Integer.parseInt(str.substring(2, 4), 16);
            this.BLUE = Integer.parseInt(str.substring(4, 6), 16);
            if (this.RED < 0 || this.GREEN < 0 || this.BLUE < 0) {
                throw new IllegalArgumentException("Not a legal color representation: " + str);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Not a legal color representation: " + str);
        }
    }

    public int getRed() {
        return this.RED;
    }

    public int getGreen() {
        return this.GREEN;
    }

    public int getBlue() {
        return this.BLUE;
    }

    public long length() {
        return 24L;
    }

    public void write(BitOutputStream out) throws IOException {
        out.write(this.getRed());
        out.write(this.getGreen());
        out.write(this.getBlue());
    }

    public String toHexString() {
        return this.toHex(this.getRed()) + this.toHex(this.getGreen()) + this.toHex(this.getBlue());
    }

    protected String toHex(int value) {
        String str = Integer.toHexString(value);
        return str.length() > 1 ? str : "0" + str;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SWFColorRGB) {
            SWFColorRGB other = (SWFColorRGB)obj;
            return other.getRed() == this.getRed() && other.getGreen() == this.getGreen() && other.getBlue() == this.getBlue();
        }
        return false;
    }
}

