/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.xupdate.unittests;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompareDocuments {
    public void compare(Node node, Node node2) throws Exception {
        this.compare(node, node2, "", true);
    }

    public void compare(Node node, Node node2, String string, boolean bl) throws Exception {
        if (node.getNodeType() == 9 && node2.getNodeType() == 9) {
            this.compare(((Document)node).getDocumentElement(), ((Document)node2).getDocumentElement(), string, bl);
            return;
        }
        if (bl) {
            System.err.print(string);
            switch (node.getNodeType()) {
                case 2: {
                    System.err.print("@");
                }
            }
            System.err.print(node + "[" + node.getNodeType() + "] <==> ");
            switch (node2.getNodeType()) {
                case 2: {
                    System.err.print("@");
                }
            }
            System.err.println(node2 + "[" + node2.getNodeType() + "]");
        }
        if (node.getNodeType() != node2.getNodeType()) {
            throw new Exception("different node types (" + node.getNodeType() + "!=" + node2.getNodeType() + ")...");
        }
        if (node.getNamespaceURI() == null ^ node2.getNamespaceURI() == null) {
            throw new Exception("only one node has a Namespace");
        }
        if (node.getNamespaceURI() != null && node2.getNamespaceURI() != null && !node.getNamespaceURI().equals(node2.getNamespaceURI())) {
            throw new Exception("different NamespaceURI's (" + node.getNamespaceURI() + "!=" + node2.getNamespaceURI() + ")...");
        }
        if (!node.getNodeName().equals(node2.getNodeName())) {
            throw new Exception("different node names (" + node.getNodeName() + "!=" + node2.getNodeName() + "...");
        }
        if (node.getNodeValue() != null && node2.getNodeValue() != null && !node.getNodeValue().equals(node2.getNodeValue())) {
            throw new Exception("different node values (" + node.getNodeValue() + "!=" + node2.getNodeValue() + ")...");
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        NamedNodeMap namedNodeMap2 = node2.getAttributes();
        if (namedNodeMap != null && namedNodeMap2 != null) {
            if (namedNodeMap.getLength() != namedNodeMap2.getLength()) {
                throw new Exception("different attribute counts...");
            }
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                this.compare(namedNodeMap.item(n), namedNodeMap2.item(n), string, bl);
                ++n;
            }
        }
        NodeList nodeList = node.getChildNodes();
        NodeList nodeList2 = node2.getChildNodes();
        if (nodeList.getLength() != nodeList2.getLength()) {
            throw new Exception("different child node counts(" + nodeList.getLength() + "!=" + nodeList2.getLength() + ")...");
        }
        Node node3 = node.getFirstChild();
        Node node4 = node2.getFirstChild();
        string = string + "    ";
        while (node3 != null) {
            this.compare(node3, node4, string, bl);
            node3 = node3.getNextSibling();
            node4 = node4.getNextSibling();
        }
    }
}

