/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.converter;

import java.util.ArrayList;
import org.jfor.jfor.converter.BuilderContext;
import org.jfor.jfor.converter.FoUnitsConverter;
import org.jfor.jfor.converter.ValueConversionException;
import org.jfor.jfor.interfaces.ITableColumnsInfo;

class TableContext
implements ITableColumnsInfo {
    private final BuilderContext m_context;
    private final ArrayList m_colWidths = new ArrayList();
    private int m_colIndex;

    TableContext(BuilderContext builderContext) {
        this.m_context = builderContext;
    }

    void setNextColumnWidth(String string) throws ValueConversionException {
        this.m_colWidths.add(new Float(FoUnitsConverter.getInstance().convertToTwips(string)));
    }

    public void selectFirstColumn() {
        this.m_colIndex = 0;
    }

    public void selectNextColumn() {
        ++this.m_colIndex;
    }

    public float getColumnWidth() {
        try {
            return ((Float)this.m_colWidths.get(this.m_colIndex)).floatValue();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.m_context.log.logWarning("fo:table-column width not defined,using 200.0");
            return 200.0f;
        }
    }

    public int getColumnIndex() {
        return this.m_colIndex;
    }

    public int getNumberOfColumns() {
        return this.m_colWidths.size();
    }
}

