/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.converter;

import java.io.IOException;
import org.jfor.jfor.converter.AbstractBuilder;
import org.jfor.jfor.converter.BuilderContext;
import org.jfor.jfor.converter.ConverterException;
import org.jfor.jfor.converter.IBuilder;
import org.jfor.jfor.converter.TextAttributesConverter;
import org.jfor.jfor.converter.TextBuilder;
import org.jfor.jfor.rtflib.rtfdoc.IRtfParagraphContainer;
import org.jfor.jfor.rtflib.rtfdoc.IRtfParagraphKeepTogetherContainer;
import org.jfor.jfor.rtflib.rtfdoc.RtfAttributes;
import org.jfor.jfor.rtflib.rtfdoc.RtfParagraph;
import org.jfor.jfor.rtflib.rtfdoc.RtfParagraphKeepTogether;
import org.jfor.jfor.rtflib.rtfdoc.RtfStyleSheetTable;
import org.xml.sax.Attributes;

class ParagraphBuilder
extends AbstractBuilder {
    public static final String TAG_FO_BLOCK = "fo:block";
    public static final String ATTRIBUTE_FO_KEEP_TOGETHER = "keep-together";
    private TextBuilder m_textBuilder;
    private Attributes m_attrib;
    private RtfParagraph m_para;
    private static boolean m_paraKeepOpen = false;
    private final ParagraphBuilder m_nestedInto;
    static /* synthetic */ Class class$org$jfor$jfor$rtflib$rtfdoc$IRtfParagraphKeepTogetherContainer;
    static /* synthetic */ Class class$org$jfor$jfor$rtflib$rtfdoc$IRtfParagraphContainer;

    ParagraphBuilder(BuilderContext builderContext) {
        super(builderContext);
        try {
            this.m_nestedInto = (ParagraphBuilder)this.m_context.getBuilder(this.getClass(), false);
        }
        catch (ConverterException converterException) {
            throw new Error("unexpected ConverterException in ParagraphBuilder constructor");
        }
    }

    public void start(String string, Attributes attributes) throws IOException {
        this.m_attrib = attributes;
        if (attributes.getValue(ATTRIBUTE_FO_KEEP_TOGETHER) != null) {
            RtfParagraphKeepTogether rtfParagraphKeepTogether = this.startParagraphKeepTogether();
            rtfParagraphKeepTogether.setStatus(1);
            this.m_context.pushContainer(rtfParagraphKeepTogether);
            m_paraKeepOpen = true;
        }
        this.m_para = this.startParagraph(false);
        this.m_context.pushContainer(this.m_para);
    }

    public void end() throws IOException {
        this.m_context.popContainer();
        if (m_paraKeepOpen) {
            RtfParagraphKeepTogether rtfParagraphKeepTogether = this.startParagraphKeepTogether();
            rtfParagraphKeepTogether.setStatus(2);
            this.m_context.pushContainer(rtfParagraphKeepTogether);
            m_paraKeepOpen = false;
        }
        if (this.m_nestedInto != null) {
            this.m_nestedInto.nestedParagraphEnds();
        }
    }

    public void characters(String string) throws IOException {
        if (this.m_textBuilder != null) {
            this.m_textBuilder.characters(string);
        }
    }

    public IBuilder getBuilder(BuilderContext builderContext, String string, Attributes attributes) {
        if (string.equals(TAG_FO_BLOCK)) {
            return new ParagraphBuilder(builderContext);
        }
        return null;
    }

    private void nestedParagraphEnds() throws IOException {
        RtfParagraph rtfParagraph = this.startParagraph(true);
        this.m_context.replaceContainer(this.m_para, rtfParagraph);
        this.m_para = rtfParagraph;
    }

    private RtfParagraphKeepTogether startParagraphKeepTogether() throws IOException {
        IRtfParagraphKeepTogetherContainer iRtfParagraphKeepTogetherContainer = (IRtfParagraphKeepTogetherContainer)((Object)this.m_context.getContainer(class$org$jfor$jfor$rtflib$rtfdoc$IRtfParagraphKeepTogetherContainer == null ? (class$org$jfor$jfor$rtflib$rtfdoc$IRtfParagraphKeepTogetherContainer = ParagraphBuilder.class$("org.jfor.jfor.rtflib.rtfdoc.IRtfParagraphKeepTogetherContainer")) : class$org$jfor$jfor$rtflib$rtfdoc$IRtfParagraphKeepTogetherContainer, true, this));
        return iRtfParagraphKeepTogetherContainer.newParagraphKeepTogether();
    }

    private RtfParagraph startParagraph(boolean bl) throws IOException {
        String string;
        int n;
        IRtfParagraphContainer iRtfParagraphContainer = (IRtfParagraphContainer)((Object)this.m_context.getContainer(class$org$jfor$jfor$rtflib$rtfdoc$IRtfParagraphContainer == null ? (class$org$jfor$jfor$rtflib$rtfdoc$IRtfParagraphContainer = ParagraphBuilder.class$("org.jfor.jfor.rtflib.rtfdoc.IRtfParagraphContainer")) : class$org$jfor$jfor$rtflib$rtfdoc$IRtfParagraphContainer, true, this));
        RtfAttributes rtfAttributes = new RtfAttributes();
        String string2 = AbstractBuilder.getAttribute(this.m_attrib, TAG_FO_BLOCK, "jfor-class", false);
        if (string2 == null) {
            string2 = RtfStyleSheetTable.getInstance().getDefaultStyleName();
        }
        if (string2 != null && (n = RtfStyleSheetTable.getInstance().addStyleToAttributes(string2, rtfAttributes)) == RtfStyleSheetTable.STATUS_DEFAULT) {
            this.m_context.log.logWarning("jfor-class '" + string2 + "' is not defined, set to default.");
        }
        RtfParagraph rtfParagraph = iRtfParagraphContainer.newParagraph(TextAttributesConverter.convertAttributes(this.m_attrib, rtfAttributes, this.m_context.log));
        if (!bl && AbstractBuilder.hasAttributeValue(this.m_attrib, "break-before", "page")) {
            rtfParagraph.newPageBreak();
        }
        if (!bl && (string = AbstractBuilder.getAttribute(this.m_attrib, TAG_FO_BLOCK, "id", false)) != null) {
            rtfParagraph.newBookmark(string);
        }
        this.m_textBuilder = new TextBuilder(this.m_context, rtfParagraph);
        return rtfParagraph;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

