/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.value;

import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.value.BinaryValue;
import org.apache.jackrabbit.value.BooleanValue;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.DoubleValue;
import org.apache.jackrabbit.value.LongValue;
import org.apache.jackrabbit.value.ReferenceValue;
import org.apache.jackrabbit.value.StringValue;
import org.apache.jackrabbit.value.ValueHelper;

public class ValueFactoryImpl
implements ValueFactory {
    public Value createValue(boolean value) {
        return new BooleanValue(value);
    }

    public Value createValue(Calendar value) {
        return new DateValue(value);
    }

    public Value createValue(double value) {
        return new DoubleValue(value);
    }

    public Value createValue(InputStream value) {
        return new BinaryValue(value);
    }

    public Value createValue(long value) {
        return new LongValue(value);
    }

    public Value createValue(Node value) throws RepositoryException {
        return new ReferenceValue(value);
    }

    public Value createValue(String value) {
        return new StringValue(value);
    }

    public Value createValue(String value, int type) throws ValueFormatException {
        return ValueHelper.convert(value, type);
    }
}

