/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.xml.DocViewImportHandler;
import org.apache.jackrabbit.core.xml.Importer;
import org.apache.jackrabbit.core.xml.SysViewImportHandler;
import org.apache.jackrabbit.name.AbstractNamespaceResolver;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class ImportHandler
extends DefaultHandler {
    private static Logger log = LoggerFactory.getLogger((Class)ImportHandler.class);
    protected final Importer importer;
    protected final NamespaceRegistryImpl nsReg;
    protected final NamespaceResolver nsResolver;
    protected Locator locator;
    protected ContentHandler targetHandler;
    protected boolean systemViewXML;
    protected boolean initialized;
    protected final NamespaceContext nsContext;
    protected boolean nsContextStarted;

    public ImportHandler(Importer importer, NamespaceResolver nsResolver, NamespaceRegistryImpl nsReg) {
        this.importer = importer;
        this.nsResolver = nsResolver;
        this.nsReg = nsReg;
        this.nsContext = new NamespaceContext();
    }

    public void warning(SAXParseException e) throws SAXException {
        log.warn("warning encountered at line: " + e.getLineNumber() + ", column: " + e.getColumnNumber() + " while parsing XML stream", (Throwable)e);
    }

    public void error(SAXParseException e) throws SAXException {
        log.error("error encountered at line: " + e.getLineNumber() + ", column: " + e.getColumnNumber() + " while parsing XML stream: " + e.toString());
    }

    public void fatalError(SAXParseException e) throws SAXException {
        log.error("fatal error encountered at line: " + e.getLineNumber() + ", column: " + e.getColumnNumber() + " while parsing XML stream: " + e.toString());
        throw e;
    }

    public void startDocument() throws SAXException {
        this.systemViewXML = false;
        this.initialized = false;
        this.targetHandler = null;
        this.nsContext.reset();
        this.nsContext.pushContext();
        try {
            String[] uris = this.nsReg.getURIs();
            for (int i = 0; i < uris.length; ++i) {
                this.nsContext.declarePrefix(this.nsResolver.getPrefix(uris[i]), uris[i]);
            }
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
        this.nsContextStarted = false;
    }

    public void endDocument() throws SAXException {
        this.targetHandler.endDocument();
        this.nsContext.reset();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!this.nsContextStarted) {
            this.nsContext.pushContext();
            this.nsContextStarted = true;
        }
        try {
            this.nsContext.getPrefix(uri);
        }
        catch (NamespaceException nse) {
            String newPrefix = "".equals(prefix) ? this.nsReg.getUniquePrefix(uri) : prefix;
            try {
                this.nsReg.registerNamespace(newPrefix, uri);
            }
            catch (RepositoryException re) {
                throw new SAXException((Exception)((Object)re));
            }
        }
        this.nsContext.declarePrefix(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.nsContextStarted) {
            this.nsContext.pushContext();
        } else {
            this.nsContextStarted = false;
        }
        if (!this.initialized) {
            this.systemViewXML = "http://www.jcp.org/jcr/sv/1.0".equals(namespaceURI);
            this.targetHandler = this.systemViewXML ? new SysViewImportHandler(this.importer, this.nsContext) : new DocViewImportHandler(this.importer, this.nsContext);
            this.targetHandler.startDocument();
            this.initialized = true;
        }
        this.targetHandler.startElement(namespaceURI, localName, qName, atts);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.targetHandler.characters(ch, start, length);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.nsContext.popContext();
        this.targetHandler.endElement(namespaceURI, localName, qName);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    class NamespaceContext
    extends AbstractNamespaceResolver {
        private final NamespaceSupport nsContext = new NamespaceSupport();
        private static final String DUMMY_DEFAULT_URI = " ";

        NamespaceContext() {
        }

        void popContext() {
            this.nsContext.popContext();
        }

        void pushContext() {
            this.nsContext.pushContext();
        }

        void reset() {
            this.nsContext.reset();
        }

        boolean declarePrefix(String prefix, String uri) {
            if ("".equals(uri)) {
                uri = DUMMY_DEFAULT_URI;
            }
            return this.nsContext.declarePrefix(prefix, uri);
        }

        public String getURI(String prefix) throws NamespaceException {
            String uri = this.nsContext.getURI(prefix);
            if (uri == null) {
                throw new NamespaceException("unknown prefix");
            }
            if (DUMMY_DEFAULT_URI.equals(uri)) {
                return "";
            }
            return uri;
        }

        public String getPrefix(String uri) throws NamespaceException {
            String prefix;
            if ("".equals(uri)) {
                uri = DUMMY_DEFAULT_URI;
            }
            if ((prefix = this.nsContext.getPrefix(uri)) == null) {
                if (uri.equals(this.nsContext.getURI(""))) {
                    return "";
                }
                throw new NamespaceException("unknown uri");
            }
            return prefix;
        }
    }
}

