/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Stack;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.xml.Importer;
import org.apache.jackrabbit.core.xml.TargetImportHandler;
import org.apache.jackrabbit.name.NameException;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.util.ISO9075;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class DocViewImportHandler
extends TargetImportHandler {
    private static Logger log = LoggerFactory.getLogger((Class)DocViewImportHandler.class);
    private final Stack stack = new Stack();
    private TargetImportHandler.BufferedStringValue textHandler = new TargetImportHandler.BufferedStringValue();

    DocViewImportHandler(Importer importer, NamespaceResolver nsContext) {
        super(importer, nsContext);
    }

    private void appendCharacters(char[] ch, int start, int length) throws SAXException {
        if (this.textHandler == null) {
            this.textHandler = new TargetImportHandler.BufferedStringValue();
        }
        try {
            this.textHandler.append(ch, start, length);
        }
        catch (IOException ioe) {
            String msg = "internal error while processing internal buffer data";
            log.error(msg, (Throwable)ioe);
            throw new SAXException(msg, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCharacters() throws SAXException {
        block8: {
            try {
                if (this.textHandler == null || this.textHandler.length() <= 0L) break block8;
                Reader reader = this.textHandler.reader();
                try {
                    int ch;
                    while ((ch = reader.read()) != -1 && ch <= 32) {
                    }
                    if (ch == -1) {
                        log.debug("ignoring pure whitespace character data...");
                        this.textHandler.dispose();
                        this.textHandler = null;
                        return;
                    }
                }
                finally {
                    reader.close();
                }
                Importer.NodeInfo node = new Importer.NodeInfo(QName.JCR_XMLTEXT, null, null, null);
                Importer.TextValue[] values = new Importer.TextValue[]{this.textHandler};
                ArrayList<Importer.PropInfo> props = new ArrayList<Importer.PropInfo>();
                Importer.PropInfo prop = new Importer.PropInfo(QName.JCR_XMLCHARACTERS, 1, values);
                props.add(prop);
                this.importer.startNode(node, props, this.nsContext);
                this.importer.endNode(node);
                this.textHandler.dispose();
                this.textHandler = null;
            }
            catch (IOException ioe) {
                String msg = "internal error while processing internal buffer data";
                log.error(msg, (Throwable)ioe);
                throw new SAXException(msg, ioe);
            }
            catch (RepositoryException re) {
                throw new SAXException((Exception)((Object)re));
            }
        }
    }

    public void startDocument() throws SAXException {
        try {
            this.importer.start();
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.processCharacters();
        try {
            QName nodeName = new QName(namespaceURI, localName);
            nodeName = ISO9075.decode(nodeName);
            NodeId id = null;
            QName nodeTypeName = null;
            QName[] mixinTypes = null;
            ArrayList<Importer.PropInfo> props = new ArrayList<Importer.PropInfo>(atts.getLength());
            for (int i = 0; i < atts.getLength(); ++i) {
                QName propName = new QName(atts.getURI(i), atts.getLocalName(i));
                propName = ISO9075.decode(propName);
                String attrValue = atts.getValue(i);
                if (propName.equals(QName.JCR_PRIMARYTYPE)) {
                    if (attrValue.length() <= 0) continue;
                    try {
                        nodeTypeName = QName.fromJCRName(attrValue, this.nsContext);
                        continue;
                    }
                    catch (NameException be) {
                        throw new SAXException("illegal jcr:primaryType value: " + attrValue, be);
                    }
                }
                if (propName.equals(QName.JCR_MIXINTYPES)) {
                    mixinTypes = this.parseNames(attrValue);
                    continue;
                }
                if (propName.equals(QName.JCR_UUID)) {
                    if (attrValue.length() <= 0) continue;
                    id = NodeId.valueOf(attrValue);
                    continue;
                }
                Importer.TextValue[] propValues = new Importer.TextValue[]{new TargetImportHandler.StringValue(atts.getValue(i))};
                props.add(new Importer.PropInfo(propName, 0, propValues));
            }
            Importer.NodeInfo node = new Importer.NodeInfo(nodeName, nodeTypeName, mixinTypes, id);
            this.importer.startNode(node, props, this.nsContext);
            this.stack.push(node);
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    private QName[] parseNames(String value) throws SAXException {
        String[] names = value.split("\\p{Space}+");
        QName[] qnames = new QName[names.length];
        for (int i = 0; i < names.length; ++i) {
            try {
                qnames[i] = this.nsContext.getQName(names[i]);
                continue;
            }
            catch (NameException ne) {
                throw new SAXException("Invalid name: " + names[i], ne);
            }
        }
        return qnames;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.appendCharacters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.appendCharacters(ch, start, length);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.processCharacters();
        Importer.NodeInfo node = (Importer.NodeInfo)this.stack.peek();
        try {
            this.importer.endNode(node);
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
        this.stack.pop();
    }

    public void endDocument() throws SAXException {
        try {
            this.importer.end();
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }
}

