/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.name.NameException;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.SessionNamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

abstract class AbstractSAXEventGenerator {
    private static Logger log = LoggerFactory.getLogger((Class)AbstractSAXEventGenerator.class);
    protected final Session session;
    protected final NamespaceResolver nsResolver;
    protected final ContentHandler contentHandler;
    protected final Node startNode;
    protected final boolean skipBinary;
    protected final boolean noRecurse;
    protected final String jcrPrimaryType;
    protected final String jcrMixinTypes;
    protected final String jcrUUID;
    protected final String jcrRoot;
    protected final String jcrXMLText;
    protected final String jcrXMLCharacters;

    protected AbstractSAXEventGenerator(Node node, boolean noRecurse, boolean skipBinary, ContentHandler contentHandler) throws RepositoryException {
        this.startNode = node;
        this.session = node.getSession();
        this.nsResolver = new SessionNamespaceResolver(this.session);
        this.contentHandler = contentHandler;
        this.skipBinary = skipBinary;
        this.noRecurse = noRecurse;
        try {
            this.jcrPrimaryType = QName.JCR_PRIMARYTYPE.toJCRName(this.nsResolver);
            this.jcrMixinTypes = QName.JCR_MIXINTYPES.toJCRName(this.nsResolver);
            this.jcrUUID = QName.JCR_UUID.toJCRName(this.nsResolver);
            this.jcrRoot = QName.JCR_ROOT.toJCRName(this.nsResolver);
            this.jcrXMLText = QName.JCR_XMLTEXT.toJCRName(this.nsResolver);
            this.jcrXMLCharacters = QName.JCR_XMLCHARACTERS.toJCRName(this.nsResolver);
        }
        catch (NameException e) {
            String msg = "internal error: failed to resolve namespace mappings";
            log.error(msg, (Throwable)e);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public void serialize() throws RepositoryException, SAXException {
        this.contentHandler.startDocument();
        this.startNamespaceDeclarations();
        this.process(this.startNode, 0);
        this.endNamespaceDeclarations();
        this.contentHandler.endDocument();
    }

    protected void startNamespaceDeclarations() throws RepositoryException, SAXException {
        String[] prefixes = this.session.getNamespacePrefixes();
        for (int i = 0; i < prefixes.length; ++i) {
            String prefix = prefixes[i];
            if ("xml".equals(prefix)) continue;
            String uri = this.session.getNamespaceURI(prefix);
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
    }

    protected void endNamespaceDeclarations() throws RepositoryException, SAXException {
        String[] prefixes = this.session.getNamespacePrefixes();
        for (int i = 0; i < prefixes.length; ++i) {
            String prefix = prefixes[i];
            if ("xml".equals(prefix)) continue;
            this.contentHandler.endPrefixMapping(prefix);
        }
    }

    protected void process(Node node, int level) throws RepositoryException, SAXException {
        this.entering(node, level);
        this.enteringProperties(node, level);
        if (!node.hasProperty(this.jcrPrimaryType)) {
            String msg = "internal error: missing jcr:primaryType property on node " + node.getPath();
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        this.process(node.getProperty(this.jcrPrimaryType), level + 1);
        if (node.hasProperty(this.jcrMixinTypes)) {
            this.process(node.getProperty(this.jcrMixinTypes), level + 1);
        }
        if (node.hasProperty(this.jcrUUID)) {
            this.process(node.getProperty(this.jcrUUID), level + 1);
        }
        PropertyIterator propIter = node.getProperties();
        while (propIter.hasNext()) {
            Property prop = propIter.nextProperty();
            String name = prop.getName();
            if (this.jcrPrimaryType.equals(name) || this.jcrMixinTypes.equals(name) || this.jcrUUID.equals(name)) continue;
            this.process(prop, level + 1);
        }
        this.leavingProperties(node, level);
        if (!this.noRecurse) {
            NodeIterator nodeIter = node.getNodes();
            while (nodeIter.hasNext()) {
                Node childNode = nodeIter.nextNode();
                this.process(childNode, level + 1);
            }
        }
        this.leaving(node, level);
    }

    protected void process(Property prop, int level) throws RepositoryException, SAXException {
        this.entering(prop, level);
        this.leaving(prop, level);
    }

    protected abstract void entering(Node var1, int var2) throws RepositoryException, SAXException;

    protected abstract void enteringProperties(Node var1, int var2) throws RepositoryException, SAXException;

    protected abstract void leavingProperties(Node var1, int var2) throws RepositoryException, SAXException;

    protected abstract void leaving(Node var1, int var2) throws RepositoryException, SAXException;

    protected abstract void entering(Property var1, int var2) throws RepositoryException, SAXException;

    protected abstract void leaving(Property var1, int var2) throws RepositoryException, SAXException;
}

