/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.virtual;

import java.util.HashSet;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.ItemStateReferenceMap;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.core.virtual.VirtualNodeState;
import org.apache.jackrabbit.core.virtual.VirtualPropertyState;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVISProvider
implements VirtualItemStateProvider,
ItemStateListener {
    private static Logger log = LoggerFactory.getLogger((Class)AbstractVISProvider.class);
    private VirtualNodeState root = null;
    protected final NodeId rootNodeId;
    protected final NodeTypeRegistry ntReg;
    private ItemStateReferenceMap nodes = new ItemStateReferenceMap();

    public AbstractVISProvider(NodeTypeRegistry ntReg, NodeId rootNodeId) {
        this.ntReg = ntReg;
        this.rootNodeId = rootNodeId;
    }

    protected abstract VirtualNodeState createRootNodeState() throws RepositoryException;

    public boolean hasItemState(ItemId id) {
        if (id instanceof NodeId) {
            if (this.nodes.contains(id)) {
                return true;
            }
            if (id.equals(this.rootNodeId)) {
                return true;
            }
            return this.internalHasNodeState((NodeId)id);
        }
        return this.internalHasPropertyState((PropertyId)id);
    }

    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        if (id instanceof NodeId) {
            ItemState s = this.nodes.contains(id) ? this.nodes.get(id) : (id.equals(this.rootNodeId) ? this.getRootState() : this.cache(this.internalGetNodeState((NodeId)id)));
            return s;
        }
        return this.internalGetPropertyState((PropertyId)id);
    }

    public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
        throw new NoSuchItemStateException(id.toString());
    }

    public boolean hasNodeReferences(NodeReferencesId id) {
        return false;
    }

    public boolean isVirtualRoot(ItemId id) {
        return id.equals(this.rootNodeId);
    }

    public NodeId getVirtualRootId() {
        return this.rootNodeId;
    }

    public synchronized NodeState getRootState() throws ItemStateException {
        try {
            if (this.root == null) {
                this.root = this.createRootNodeState();
            }
            return this.root;
        }
        catch (RepositoryException e) {
            throw new ItemStateException("Error creating root node state", e);
        }
    }

    protected abstract boolean internalHasNodeState(NodeId var1);

    protected abstract VirtualNodeState internalGetNodeState(NodeId var1) throws NoSuchItemStateException, ItemStateException;

    protected boolean internalHasPropertyState(PropertyId id) {
        try {
            NodeState parent = (NodeState)this.getItemState(id.getParentId());
            if (parent instanceof VirtualNodeState) {
                return parent.hasPropertyName(id.getName());
            }
        }
        catch (ItemStateException itemStateException) {
            // empty catch block
        }
        return false;
    }

    protected VirtualPropertyState internalGetPropertyState(PropertyId id) throws NoSuchItemStateException, ItemStateException {
        NodeState parent = (NodeState)this.getItemState(id.getParentId());
        if (parent instanceof VirtualNodeState) {
            return ((VirtualNodeState)parent).getProperty(id.getName());
        }
        throw new NoSuchItemStateException(id.toString());
    }

    public VirtualPropertyState createPropertyState(VirtualNodeState parent, QName name, int type, boolean multiValued) throws RepositoryException {
        PropDef def = this.getApplicablePropertyDef(parent, name, type, multiValued);
        PropertyId id = new PropertyId(parent.getNodeId(), name);
        VirtualPropertyState prop = new VirtualPropertyState(id);
        prop.setType(type);
        prop.setMultiValued(multiValued);
        prop.setDefinitionId(def.getId());
        return prop;
    }

    public VirtualNodeState createNodeState(VirtualNodeState parent, QName name, NodeId id, QName nodeTypeName) throws RepositoryException {
        NodeDefId def;
        try {
            def = this.getApplicableChildNodeDef(parent, name, nodeTypeName).getId();
        }
        catch (RepositoryException re) {
            NodeTypeRegistry ntReg = this.getNodeTypeRegistry();
            EffectiveNodeType ent = ntReg.getEffectiveNodeType(QName.NT_UNSTRUCTURED);
            NodeDef cnd = ent.getApplicableChildNodeDef(name, nodeTypeName);
            ntReg.getNodeDef(cnd.getId());
            def = cnd.getId();
        }
        if (id == null) {
            id = new NodeId(UUID.randomUUID());
        }
        VirtualNodeState state = new VirtualNodeState(this, parent.getNodeId(), id, nodeTypeName, new QName[0]);
        state.setDefinitionId(def);
        this.cache(state);
        return state;
    }

    protected NodeTypeRegistry getNodeTypeRegistry() {
        return this.ntReg;
    }

    protected NodeState cache(NodeState state) {
        if (state != null) {
            this.nodes.put(state);
            log.debug("item added to cache. size=" + this.nodes.size());
        }
        return state;
    }

    protected void evict(NodeId id) {
        this.nodes.remove(id);
    }

    public void invalidateItem(ItemId id, boolean recursive) {
        VirtualNodeState state;
        VirtualNodeState virtualNodeState = state = id.equals(this.rootNodeId) ? this.root : (VirtualNodeState)this.nodes.get(id);
        if (state != null) {
            if (recursive) {
                VirtualPropertyState[] props = state.getProperties();
                for (int i = 0; i < props.length; ++i) {
                    props[i].notifyStateUpdated();
                }
                Iterator iter = state.getChildNodeEntries().iterator();
                while (iter.hasNext()) {
                    NodeState.ChildNodeEntry pe = (NodeState.ChildNodeEntry)iter.next();
                    this.invalidateItem(pe.getId(), true);
                }
            }
            state.notifyStateUpdated();
        }
    }

    protected PropDef getApplicablePropertyDef(NodeState parent, QName propertyName, int type, boolean multiValued) throws RepositoryException {
        return this.getEffectiveNodeType(parent).getApplicablePropertyDef(propertyName, type, multiValued);
    }

    protected NodeDef getApplicableChildNodeDef(NodeState parent, QName nodeName, QName nodeTypeName) throws RepositoryException {
        return this.getEffectiveNodeType(parent).getApplicableChildNodeDef(nodeName, nodeTypeName);
    }

    protected EffectiveNodeType getEffectiveNodeType(NodeState parent) throws RepositoryException {
        NodeTypeRegistry ntReg = this.getNodeTypeRegistry();
        HashSet<QName> set = new HashSet<QName>(parent.getMixinTypeNames());
        set.add(parent.getNodeTypeName());
        try {
            return ntReg.getEffectiveNodeType(set.toArray(new QName[set.size()]));
        }
        catch (NodeTypeConflictException ntce) {
            String msg = "internal error: failed to build effective node type for node " + parent.getNodeId();
            throw new RepositoryException(msg, (Throwable)ntce);
        }
    }

    public void stateCreated(ItemState created) {
    }

    public void stateModified(ItemState modified) {
    }

    public void stateDestroyed(ItemState destroyed) {
        destroyed.removeListener(this);
        if (destroyed.isNode() && destroyed.getId().equals(this.rootNodeId)) {
            try {
                this.root = this.createRootNodeState();
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        this.evict((NodeId)destroyed.getId());
    }

    public void stateDiscarded(ItemState discarded) {
        discarded.removeListener(this);
        if (discarded.isNode() && discarded.getId().equals(this.rootNodeId)) {
            try {
                this.root = this.createRootNodeState();
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        this.evict((NodeId)discarded.getId());
    }
}

