/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.core.InternalXAResource;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.TransactionContext;
import org.apache.jackrabbit.core.TransactionException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.XAItemStateManager;
import org.apache.jackrabbit.core.version.AbstractVersionHistory;
import org.apache.jackrabbit.core.version.AbstractVersionManager;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionHistoryImpl;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.InternalVersionItemImpl;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionManagerImpl;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.core.virtual.VirtualNodeState;
import org.apache.jackrabbit.core.virtual.VirtualPropertyState;
import org.apache.jackrabbit.name.QName;

public class XAVersionManager
extends AbstractVersionManager
implements EventStateCollectionFactory,
VirtualItemStateProvider,
InternalXAResource {
    private static final String CHANGE_LOG_ATTRIBUTE_NAME = "XAVersionManager.ChangeLog";
    private static final String ITEMS_ATTRIBUTE_NAME = "VersionItems";
    private final VersionManagerImpl vMgr;
    private NodeTypeRegistry ntReg;
    private SessionImpl session;
    private Map xaItems;

    public XAVersionManager(VersionManagerImpl vMgr, NodeTypeRegistry ntReg, SessionImpl session) throws RepositoryException {
        NodeState state;
        this.vMgr = vMgr;
        this.ntReg = ntReg;
        this.session = session;
        this.stateMgr = new XAItemStateManager(vMgr.getSharedStateMgr(), this, CHANGE_LOG_ATTRIBUTE_NAME);
        try {
            state = (NodeState)this.stateMgr.getItemState(vMgr.getHistoryRootId());
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Unable to retrieve history root", (Throwable)e);
        }
        this.historyRoot = new NodeStateEx(this.stateMgr, ntReg, state, QName.JCR_VERSIONSTORAGE);
    }

    public EventStateCollection createEventStateCollection() throws RepositoryException {
        return this.vMgr.getEscFactory().createEventStateCollection(this.session);
    }

    public VirtualItemStateProvider getVirtualItemStateProvider() {
        return this;
    }

    public VersionHistory createVersionHistory(Session session, NodeState node) throws RepositoryException {
        if (this.isInXA()) {
            InternalVersionHistory history = this.createVersionHistory(node);
            this.xaItems.put(history.getId(), history);
            return (VersionHistory)((SessionImpl)session).getNodeById(history.getId());
        }
        return this.vMgr.createVersionHistory(session, node);
    }

    public Version checkin(NodeImpl node) throws RepositoryException {
        if (this.isInXA()) {
            String histUUID = node.getProperty(QName.JCR_VERSIONHISTORY).getString();
            InternalVersion version = this.checkin((InternalVersionHistoryImpl)this.getVersionHistory(NodeId.valueOf(histUUID)), node);
            return (Version)((SessionImpl)node.getSession()).getNodeById(version.getId());
        }
        return this.vMgr.checkin(node);
    }

    public void removeVersion(VersionHistory history, QName versionName) throws RepositoryException {
        if (this.isInXA()) {
            InternalVersionHistoryImpl vh = (InternalVersionHistoryImpl)((AbstractVersionHistory)history).getInternalVersionHistory();
            this.removeVersion(vh, versionName);
            return;
        }
        this.vMgr.removeVersion(history, versionName);
    }

    public Version setVersionLabel(VersionHistory history, QName version, QName label, boolean move) throws RepositoryException {
        if (this.isInXA()) {
            InternalVersionHistoryImpl vh = (InternalVersionHistoryImpl)((AbstractVersionHistory)history).getInternalVersionHistory();
            InternalVersion v = this.setVersionLabel(vh, version, label, move);
            if (v == null) {
                return null;
            }
            return (Version)((SessionImpl)history.getSession()).getNodeById(v.getId());
        }
        return this.vMgr.setVersionLabel(history, version, label, move);
    }

    public void close() throws Exception {
    }

    public boolean isVirtualRoot(ItemId id) {
        return false;
    }

    public NodeId getVirtualRootId() {
        return null;
    }

    public VirtualPropertyState createPropertyState(VirtualNodeState parent, QName name, int type, boolean multiValued) throws RepositoryException {
        throw new IllegalStateException("Read-only");
    }

    public VirtualNodeState createNodeState(VirtualNodeState parent, QName name, NodeId id, QName nodeTypeName) throws RepositoryException {
        throw new IllegalStateException("Read-only");
    }

    public boolean setNodeReferences(NodeReferences refs) {
        ChangeLog changeLog = ((XAItemStateManager)this.stateMgr).getChangeLog();
        if (changeLog != null) {
            changeLog.modified(refs);
            return true;
        }
        return false;
    }

    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ChangeLog changeLog = ((XAItemStateManager)this.stateMgr).getChangeLog();
        if (changeLog != null) {
            return changeLog.get(id);
        }
        throw new NoSuchItemStateException("State not in change log: " + id);
    }

    public boolean hasItemState(ItemId id) {
        ChangeLog changeLog = ((XAItemStateManager)this.stateMgr).getChangeLog();
        if (changeLog != null) {
            return changeLog.has(id);
        }
        return false;
    }

    public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
        ChangeLog changeLog = ((XAItemStateManager)this.stateMgr).getChangeLog();
        if (changeLog != null) {
            return changeLog.get(id);
        }
        return null;
    }

    public boolean hasNodeReferences(NodeReferencesId id) {
        ChangeLog changeLog = ((XAItemStateManager)this.stateMgr).getChangeLog();
        if (changeLog != null) {
            return changeLog.get(id) != null;
        }
        return false;
    }

    protected InternalVersionItem getItem(NodeId id) throws RepositoryException {
        InternalVersionItem item = null;
        if (this.xaItems != null) {
            item = (InternalVersionItem)this.xaItems.get(id);
        }
        if (item == null) {
            item = this.vMgr.getItem(id);
        }
        return item;
    }

    protected boolean hasItem(NodeId id) {
        if (this.xaItems != null && this.xaItems.containsKey(id)) {
            return true;
        }
        return this.vMgr.hasItem(id);
    }

    protected List getItemReferences(InternalVersionItem item) {
        return this.vMgr.getItemReferences(item);
    }

    protected InternalVersion checkin(InternalVersionHistoryImpl history, NodeImpl node) throws RepositoryException {
        if (history.getVersionManager() != this) {
            history = this.makeLocalCopy(history);
            this.xaItems.put(history.getId(), history);
        }
        return super.checkin(history, node);
    }

    protected void removeVersion(InternalVersionHistoryImpl history, QName name) throws VersionException, RepositoryException {
        if (history.getVersionManager() != this) {
            history = this.makeLocalCopy(history);
            this.xaItems.put(history.getId(), history);
        }
        super.removeVersion(history, name);
    }

    protected InternalVersion setVersionLabel(InternalVersionHistoryImpl history, QName version, QName label, boolean move) throws RepositoryException {
        if (history.getVersionManager() != this) {
            history = this.makeLocalCopy(history);
            this.xaItems.put(history.getId(), history);
        }
        return super.setVersionLabel(history, version, label, move);
    }

    protected void versionCreated(InternalVersion version) {
        this.xaItems.put(version.getId(), version);
    }

    protected void versionDestroyed(InternalVersion version) {
        this.xaItems.remove(version.getId());
    }

    public void associate(TransactionContext tx) {
        ((XAItemStateManager)this.stateMgr).associate(tx);
        HashMap xaItems = null;
        if (tx != null && (xaItems = (HashMap)tx.getAttribute(ITEMS_ATTRIBUTE_NAME)) == null) {
            xaItems = new HashMap();
            tx.setAttribute(ITEMS_ATTRIBUTE_NAME, xaItems);
        }
        this.xaItems = xaItems;
    }

    public void beforeOperation(TransactionContext tx) {
        ((XAItemStateManager)this.stateMgr).beforeOperation(tx);
    }

    public void prepare(TransactionContext tx) throws TransactionException {
        ((XAItemStateManager)this.stateMgr).prepare(tx);
    }

    public void commit(TransactionContext tx) throws TransactionException {
        ((XAItemStateManager)this.stateMgr).commit(tx);
        Map xaItems = (Map)tx.getAttribute(ITEMS_ATTRIBUTE_NAME);
        this.vMgr.itemsUpdated(xaItems.values());
    }

    public void rollback(TransactionContext tx) {
        ((XAItemStateManager)this.stateMgr).rollback(tx);
    }

    public void afterOperation(TransactionContext tx) {
        ((XAItemStateManager)this.stateMgr).afterOperation(tx);
    }

    private boolean isInXA() {
        return this.xaItems != null;
    }

    private InternalVersionHistoryImpl makeLocalCopy(InternalVersionHistoryImpl history) throws RepositoryException {
        NodeState state;
        try {
            state = (NodeState)this.stateMgr.getItemState(history.getId());
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Unable to make local copy", (Throwable)e);
        }
        NodeStateEx stateEx = new NodeStateEx(this.stateMgr, this.ntReg, state, null);
        return new InternalVersionHistoryImpl(this, stateEx);
    }

    boolean differentXAEnv(InternalVersionItemImpl item) {
        return item.getVersionManager() == this && (this.xaItems == null || !this.xaItems.containsKey(item.getId()));
    }
}

