/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeDefinition;
import org.apache.jackrabbit.core.ItemLifeCycleListener;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.version.AbstractVersion;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionImpl;
import org.apache.jackrabbit.core.version.XAVersionManager;

public class XAVersion
extends AbstractVersion {
    private InternalVersion version;
    private final XAVersionManager vMgr;

    public XAVersion(ItemManager itemMgr, SessionImpl session, NodeId id, NodeState state, NodeDefinition definition, ItemLifeCycleListener[] listeners, InternalVersion version) {
        super(itemMgr, session, id, state, definition, listeners);
        this.version = version;
        this.vMgr = (XAVersionManager)session.getVersionManager();
    }

    protected InternalVersion getInternalVersion() throws RepositoryException {
        this.ensureUpToDate();
        this.sanityCheck();
        return this.version;
    }

    protected void sanityCheck() throws RepositoryException {
        super.sanityCheck();
        if (this.version == null) {
            throw new InvalidItemStateException(this.id + ": the item does not exist anymore");
        }
    }

    private synchronized void ensureUpToDate() throws RepositoryException {
        if (this.version != null && this.vMgr.differentXAEnv((InternalVersionImpl)this.version)) {
            this.version = this.vMgr.getVersion(this.version.getId());
        }
    }
}

