/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.InternalFrozenNode;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionHistoryImpl;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.InternalVersionItemImpl;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.uuid.UUID;

class InternalVersionImpl
extends InternalVersionItemImpl
implements InternalVersion {
    private ArrayList predecessors = new ArrayList();
    private ArrayList successors = new ArrayList();
    private NodeStateEx node;
    private Calendar created;
    private HashSet labelCache = null;
    private final boolean isRoot;
    private final QName name;
    private final InternalVersionHistory versionHistory;

    public InternalVersionImpl(InternalVersionHistoryImpl vh, NodeStateEx node, QName name) {
        super(vh.getVersionManager());
        this.versionHistory = vh;
        this.node = node;
        this.name = name;
        InternalValue[] values = node.getPropertyValues(QName.JCR_CREATED);
        if (values != null) {
            this.created = (Calendar)values[0].internalValue();
        }
        this.isRoot = name.equals(QName.JCR_ROOTVERSION);
    }

    public NodeId getId() {
        return this.node.getNodeId();
    }

    public InternalVersionItem getParent() {
        return this.versionHistory;
    }

    public QName getName() {
        return this.name;
    }

    public InternalFrozenNode getFrozenNode() {
        try {
            NodeState.ChildNodeEntry entry = this.node.getState().getChildNodeEntry(QName.JCR_FROZENNODE, 1);
            if (entry == null) {
                throw new InternalError("version has no frozen node: " + this.getId());
            }
            return (InternalFrozenNode)this.vMgr.getItem(entry.getId());
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("unable to retrieve frozen node: " + (Object)((Object)e));
        }
    }

    public Calendar getCreated() {
        return this.created;
    }

    public InternalVersion[] getSuccessors() {
        return this.successors.toArray(new InternalVersionImpl[this.successors.size()]);
    }

    public InternalVersion[] getPredecessors() {
        return this.predecessors.toArray(new InternalVersionImpl[this.predecessors.size()]);
    }

    public boolean isMoreRecent(InternalVersion v) {
        for (int i = 0; i < this.predecessors.size(); ++i) {
            InternalVersion pred = (InternalVersion)this.predecessors.get(i);
            if (!pred.equals(v) && !pred.isMoreRecent(v)) continue;
            return true;
        }
        return false;
    }

    public InternalVersionHistory getVersionHistory() {
        return this.versionHistory;
    }

    public boolean hasLabel(QName label) {
        return this.internalHasLabel(label);
    }

    public QName[] getLabels() {
        return this.internalGetLabels();
    }

    public boolean isRootVersion() {
        return this.isRoot;
    }

    void resolvePredecessors() {
        InternalValue[] values = this.node.getPropertyValues(QName.JCR_PREDECESSORS);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                NodeId vId = new NodeId((UUID)values[i].internalValue());
                InternalVersionImpl v = (InternalVersionImpl)this.versionHistory.getVersion(vId);
                this.predecessors.add(v);
                v.addSuccessor(this);
            }
        }
    }

    void clear() {
        this.successors.clear();
        this.predecessors.clear();
        this.labelCache = null;
    }

    private void addSuccessor(InternalVersion successor) {
        this.successors.add(successor);
    }

    private void storePredecessors() throws RepositoryException {
        InternalValue[] values = new InternalValue[this.predecessors.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = InternalValue.create(((InternalVersion)this.predecessors.get(i)).getId().getUUID());
        }
        this.node.setPropertyValues(QName.JCR_PREDECESSORS, 1, values);
    }

    void internalDetach() throws RepositoryException {
        InternalVersionImpl[] succ = (InternalVersionImpl[])this.getSuccessors();
        for (int i = 0; i < succ.length; ++i) {
            succ[i].internalDetachPredecessor(this);
        }
        InternalVersionImpl[] preds = (InternalVersionImpl[])this.getPredecessors();
        for (int i = 0; i < preds.length; ++i) {
            preds[i].internalDetachSuccessor(this);
        }
        this.clear();
    }

    private void internalDetachPredecessor(InternalVersionImpl v) throws RepositoryException {
        for (int i = 0; i < this.predecessors.size(); ++i) {
            if (!this.predecessors.get(i).equals(v)) continue;
            this.predecessors.remove(i);
            break;
        }
        this.predecessors.addAll(Arrays.asList(v.getPredecessors()));
        this.storePredecessors();
        this.node.store();
    }

    private void internalDetachSuccessor(InternalVersionImpl v) {
        for (int i = 0; i < this.successors.size(); ++i) {
            if (!this.successors.get(i).equals(v)) continue;
            this.successors.remove(i);
            break;
        }
        this.successors.addAll(Arrays.asList(v.getSuccessors()));
    }

    boolean internalAddLabel(QName label) {
        if (this.labelCache == null) {
            this.labelCache = new HashSet();
        }
        return this.labelCache.add(label);
    }

    boolean internalRemoveLabel(QName label) {
        if (this.labelCache == null) {
            return false;
        }
        return this.labelCache.remove(label);
    }

    boolean internalHasLabel(QName label) {
        if (this.labelCache == null) {
            return false;
        }
        return this.labelCache.contains(label);
    }

    QName[] internalGetLabels() {
        if (this.labelCache == null) {
            return new QName[0];
        }
        return this.labelCache.toArray(new QName[this.labelCache.size()]);
    }

    void invalidate() {
        this.node.getState().discard();
    }
}

