/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.value;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.jackrabbit.value.BinaryValue;
import org.apache.jackrabbit.value.BooleanValue;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.DoubleValue;
import org.apache.jackrabbit.value.LongValue;
import org.apache.jackrabbit.value.NameValue;
import org.apache.jackrabbit.value.PathValue;
import org.apache.jackrabbit.value.ReferenceValue;
import org.apache.jackrabbit.value.StringValue;
import org.apache.jackrabbit.value.ValueHelper;

public class InternalValue {
    public static final InternalValue[] EMPTY_ARRAY = new InternalValue[0];
    public static final InternalValue BOOLEAN_TRUE = InternalValue.create(true);
    public static final InternalValue BOOLEAN_FALSE = InternalValue.create(false);
    private final Object val;
    private final int type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalValue create(Value value, NamespaceResolver nsResolver) throws ValueFormatException, RepositoryException {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        switch (value.getType()) {
            case 2: {
                InternalValue internalValue;
                if (value instanceof BLOBFileValue) {
                    return new InternalValue((BLOBFileValue)value);
                }
                InputStream stream = value.getStream();
                try {
                    internalValue = new InternalValue(new BLOBFileValue(stream));
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new ValueFormatException(ioe.getMessage());
                    }
                }
                try {
                    stream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                return internalValue;
            }
            case 6: {
                return value.getBoolean() ? BOOLEAN_TRUE : BOOLEAN_FALSE;
            }
            case 5: {
                return new InternalValue(value.getDate());
            }
            case 4: {
                return new InternalValue(value.getDouble());
            }
            case 3: {
                return new InternalValue(value.getLong());
            }
            case 9: {
                return new InternalValue(new UUID(value.getString()));
            }
            case 7: {
                try {
                    return new InternalValue(QName.fromJCRName(value.getString(), nsResolver));
                }
                catch (IllegalNameException ine) {
                    throw new ValueFormatException(ine.getMessage());
                }
                catch (UnknownPrefixException upe) {
                    throw new ValueFormatException(upe.getMessage());
                }
            }
            case 8: {
                try {
                    return new InternalValue(Path.create(value.getString(), nsResolver, false));
                }
                catch (MalformedPathException mpe) {
                    throw new ValueFormatException(mpe.getMessage());
                }
            }
            case 1: {
                return new InternalValue(value.getString());
            }
        }
        throw new IllegalArgumentException("illegal value");
    }

    public static InternalValue create(Value value, int targetType, NamespaceResolver nsResolver) throws ValueFormatException, RepositoryException {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        return InternalValue.create(ValueHelper.convert(value, targetType), nsResolver);
    }

    public static InternalValue create(String value, int targetType, NamespaceResolver nsResolver) throws ValueFormatException, RepositoryException {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        return InternalValue.create(ValueHelper.convert(value, targetType), nsResolver);
    }

    public static InternalValue create(String value) {
        return new InternalValue(value);
    }

    public static InternalValue create(long value) {
        return new InternalValue(value);
    }

    public static InternalValue create(double value) {
        return new InternalValue(value);
    }

    public static InternalValue create(Calendar value) {
        return new InternalValue(value);
    }

    public static InternalValue create(boolean value) {
        return new InternalValue(value);
    }

    public static InternalValue create(byte[] value) {
        return new InternalValue(new BLOBFileValue(value));
    }

    public static InternalValue create(InputStream value) throws IOException {
        return new InternalValue(new BLOBFileValue(value));
    }

    public static InternalValue create(InputStream value, boolean temp) throws IOException {
        return new InternalValue(new BLOBFileValue(value, temp));
    }

    public static InternalValue create(FileSystemResource value) throws IOException {
        return new InternalValue(new BLOBFileValue(value));
    }

    public static InternalValue create(File value) throws IOException {
        return new InternalValue(new BLOBFileValue(value));
    }

    public static InternalValue create(QName value) {
        return new InternalValue(value);
    }

    public static InternalValue[] create(QName[] values) {
        InternalValue[] ret = new InternalValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = new InternalValue(values[i]);
        }
        return ret;
    }

    public static InternalValue[] create(String[] values) {
        InternalValue[] ret = new InternalValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = new InternalValue(values[i]);
        }
        return ret;
    }

    public static InternalValue[] create(Calendar[] values) {
        InternalValue[] ret = new InternalValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = new InternalValue(values[i]);
        }
        return ret;
    }

    public static InternalValue create(Path value) {
        return new InternalValue(value);
    }

    public static InternalValue create(UUID value) {
        return new InternalValue(value);
    }

    public Value toJCRValue(NamespaceResolver nsResolver) throws RepositoryException {
        switch (this.type) {
            case 2: {
                return new BinaryValue(((BLOBFileValue)this.val).getStream());
            }
            case 6: {
                return new BooleanValue((Boolean)this.val);
            }
            case 5: {
                return new DateValue((Calendar)this.val);
            }
            case 4: {
                return new DoubleValue((Double)this.val);
            }
            case 3: {
                return new LongValue((Long)this.val);
            }
            case 9: {
                return ReferenceValue.valueOf(((UUID)this.val).toString());
            }
            case 8: {
                try {
                    return PathValue.valueOf(((Path)this.val).toJCRPath(nsResolver));
                }
                catch (NoPrefixDeclaredException npde) {
                    throw new RepositoryException("internal error: encountered unregistered namespace", (Throwable)npde);
                }
            }
            case 7: {
                try {
                    return NameValue.valueOf(((QName)this.val).toJCRName(nsResolver));
                }
                catch (NoPrefixDeclaredException npde) {
                    throw new RepositoryException("internal error: encountered unregistered namespace", (Throwable)npde);
                }
            }
            case 1: {
                return new StringValue((String)this.val);
            }
        }
        throw new RepositoryException("illegal internal value type");
    }

    public Object internalValue() {
        return this.val;
    }

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalValue createCopy() throws RepositoryException {
        switch (this.type) {
            case 2: {
                InternalValue internalValue;
                InputStream stream = ((BLOBFileValue)this.val).getStream();
                try {
                    internalValue = new InternalValue(new BLOBFileValue(stream));
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new RepositoryException("failed to copy binary value", (Throwable)ioe);
                    }
                }
                try {
                    stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return internalValue;
            }
            case 6: {
                return new InternalValue((Boolean)this.val);
            }
            case 5: {
                return new InternalValue((Calendar)this.val);
            }
            case 4: {
                return new InternalValue((Double)this.val);
            }
            case 3: {
                return new InternalValue((Long)this.val);
            }
            case 9: {
                return new InternalValue((UUID)this.val);
            }
            case 8: {
                return new InternalValue((Path)this.val);
            }
            case 7: {
                return new InternalValue((QName)this.val);
            }
            case 1: {
                return new InternalValue((String)this.val);
            }
        }
        throw new RepositoryException("illegal internal value type");
    }

    public String toString() {
        if (this.type == 5) {
            return ISO8601.format((Calendar)this.val);
        }
        return this.val.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof InternalValue) {
            InternalValue other = (InternalValue)obj;
            return this.val.equals(other.val);
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public static InternalValue valueOf(String s, int type) {
        switch (type) {
            case 6: {
                return new InternalValue(Boolean.valueOf(s));
            }
            case 5: {
                return new InternalValue(ISO8601.parse(s));
            }
            case 4: {
                return new InternalValue(Double.valueOf(s));
            }
            case 3: {
                return new InternalValue(Long.valueOf(s));
            }
            case 9: {
                return new InternalValue(new UUID(s));
            }
            case 8: {
                return new InternalValue(Path.valueOf(s));
            }
            case 7: {
                return new InternalValue(QName.valueOf(s));
            }
            case 1: {
                return new InternalValue(s);
            }
            case 2: {
                throw new IllegalArgumentException("this method does not support the type PropertyType.BINARY");
            }
        }
        throw new IllegalArgumentException("illegal type");
    }

    private InternalValue(String value) {
        this.val = value;
        this.type = 1;
    }

    private InternalValue(QName value) {
        this.val = value;
        this.type = 7;
    }

    private InternalValue(long value) {
        this.val = new Long(value);
        this.type = 3;
    }

    private InternalValue(double value) {
        this.val = new Double(value);
        this.type = 4;
    }

    private InternalValue(Calendar value) {
        this.val = value;
        this.type = 5;
    }

    private InternalValue(boolean value) {
        this.val = new Boolean(value);
        this.type = 6;
    }

    private InternalValue(BLOBFileValue value) {
        this.val = value;
        this.type = 2;
    }

    private InternalValue(Path value) {
        this.val = value;
        this.type = 8;
    }

    private InternalValue(UUID value) {
        this.val = value;
        this.type = 9;
    }
}

