/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.core.nodetype.PropDefId;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.util.BLOBStore;
import org.apache.jackrabbit.core.state.util.ResourceBasedBLOBStore;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.uuid.UUID;

public final class Serializer {
    private static final byte[] NULL_UUID_PLACEHOLDER_BYTES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String ENCODING = "UTF-8";

    public static void serialize(NodeState state, OutputStream stream) throws Exception {
        DataOutputStream out = new DataOutputStream(stream);
        out.writeUTF(state.getNodeTypeName().toString());
        if (state.getParentId() == null) {
            out.write(NULL_UUID_PLACEHOLDER_BYTES);
        } else {
            out.write(state.getParentId().getUUID().getRawBytes());
        }
        out.writeUTF(state.getDefinitionId().toString());
        Collection c = state.getMixinTypeNames();
        out.writeInt(c.size());
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            out.writeUTF(iter.next().toString());
        }
        out.writeShort(state.getModCount());
        c = state.getPropertyNames();
        out.writeInt(c.size());
        iter = c.iterator();
        while (iter.hasNext()) {
            QName propName = (QName)iter.next();
            out.writeUTF(propName.toString());
        }
        c = state.getChildNodeEntries();
        out.writeInt(c.size());
        iter = c.iterator();
        while (iter.hasNext()) {
            NodeState.ChildNodeEntry entry = (NodeState.ChildNodeEntry)iter.next();
            out.writeUTF(entry.getName().toString());
            out.write(entry.getId().getUUID().getRawBytes());
        }
    }

    public static void deserialize(NodeState state, InputStream stream) throws Exception {
        int i;
        DataInputStream in = new DataInputStream(stream);
        String s = in.readUTF();
        state.setNodeTypeName(QName.valueOf(s));
        byte[] uuidBytes = new byte[16];
        in.readFully(uuidBytes);
        if (!Arrays.equals(uuidBytes, NULL_UUID_PLACEHOLDER_BYTES)) {
            state.setParentId(new NodeId(new UUID(uuidBytes)));
        }
        s = in.readUTF();
        state.setDefinitionId(NodeDefId.valueOf(s));
        int count = in.readInt();
        HashSet<QName> set = new HashSet<QName>(count);
        for (int i2 = 0; i2 < count; ++i2) {
            set.add(QName.valueOf(in.readUTF()));
        }
        if (set.size() > 0) {
            state.setMixinTypeNames(set);
        }
        short modCount = in.readShort();
        state.setModCount(modCount);
        count = in.readInt();
        for (i = 0; i < count; ++i) {
            state.addPropertyName(QName.valueOf(in.readUTF()));
        }
        count = in.readInt();
        for (i = 0; i < count; ++i) {
            QName name = QName.valueOf(in.readUTF());
            in.readFully(uuidBytes);
            state.addChildNodeEntry(name, new NodeId(new UUID(uuidBytes)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(PropertyState state, OutputStream stream, BLOBStore blobStore) throws Exception {
        DataOutputStream out = new DataOutputStream(stream);
        out.writeInt(state.getType());
        out.writeBoolean(state.isMultiValued());
        out.writeUTF(state.getDefinitionId().toString());
        out.writeShort(state.getModCount());
        InternalValue[] values = state.getValues();
        out.writeInt(values.length);
        for (int i = 0; i < values.length; ++i) {
            InternalValue val = values[i];
            if (state.getType() == 2) {
                BLOBFileValue blobVal = (BLOBFileValue)val.internalValue();
                InputStream in = blobVal.getStream();
                String blobId = blobStore.createId(state.getPropertyId(), i);
                try {
                    blobStore.put(blobId, in, blobVal.getLength());
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
                out.writeUTF(blobId);
                if (blobStore instanceof ResourceBasedBLOBStore) {
                    FileSystemResource fsRes = ((ResourceBasedBLOBStore)blobStore).getResource(blobId);
                    values[i] = InternalValue.create(fsRes);
                } else {
                    in = blobStore.get(blobId);
                    try {
                        values[i] = InternalValue.create(in, false);
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                }
                blobVal.discard();
                continue;
            }
            byte[] bytes = val.toString().getBytes(ENCODING);
            out.writeInt(bytes.length);
            out.write(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deserialize(PropertyState state, InputStream stream, BLOBStore blobStore) throws Exception {
        DataInputStream in = new DataInputStream(stream);
        int type = in.readInt();
        state.setType(type);
        boolean multiValued = in.readBoolean();
        state.setMultiValued(multiValued);
        String s = in.readUTF();
        state.setDefinitionId(PropDefId.valueOf(s));
        short modCount = in.readShort();
        state.setModCount(modCount);
        int count = in.readInt();
        InternalValue[] values = new InternalValue[count];
        int i = 0;
        while (true) {
            InternalValue val;
            block12: {
                block11: {
                    if (i >= count) {
                        state.setValues(values);
                        return;
                    }
                    if (type != 2) break block11;
                    s = in.readUTF();
                    if (blobStore instanceof ResourceBasedBLOBStore) {
                        FileSystemResource fsRes = ((ResourceBasedBLOBStore)blobStore).getResource(s);
                        val = InternalValue.create(fsRes);
                        break block12;
                    } else {
                        InputStream is = blobStore.get(s);
                        try {
                            val = InternalValue.create(is, false);
                        }
                        finally {
                            try {
                                is.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                int len = in.readInt();
                byte[] bytes = new byte[len];
                in.readFully(bytes);
                s = new String(bytes, ENCODING);
                val = InternalValue.valueOf(s, type);
            }
            values[i] = val;
            ++i;
        }
    }

    public static void serialize(NodeReferences refs, OutputStream stream) throws Exception {
        DataOutputStream out = new DataOutputStream(stream);
        List c = refs.getReferences();
        out.writeInt(c.size());
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            PropertyId propId = (PropertyId)iter.next();
            out.writeUTF(propId.toString());
        }
    }

    public static void deserialize(NodeReferences refs, InputStream stream) throws Exception {
        DataInputStream in = new DataInputStream(stream);
        refs.clearAllReferences();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            refs.addReference(PropertyId.valueOf(in.readUTF()));
        }
    }
}

