/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.ItemStateReferenceCache;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PersistenceManager;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.StaleItemStateException;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedItemStateManager
implements ItemStateManager,
ItemStateListener,
Dumpable {
    private static Logger log = LoggerFactory.getLogger((Class)SharedItemStateManager.class);
    private final ItemStateReferenceCache cache;
    private final PersistenceManager persistMgr;
    private final NodeTypeRegistry ntReg;
    private final boolean usesReferences;
    private final NodeId rootNodeId;
    private VirtualItemStateProvider[] virtualProviders = new VirtualItemStateProvider[0];
    private final ReadWriteLock rwLock = new ReentrantWriterPreferenceReadWriteLock(){

        protected boolean allowReader() {
            return this.activeWriter_ == null || this.activeWriter_ == Thread.currentThread();
        }
    };

    public SharedItemStateManager(PersistenceManager persistMgr, NodeId rootNodeId, NodeTypeRegistry ntReg, boolean usesReferences) throws ItemStateException {
        this.cache = new ItemStateReferenceCache();
        this.persistMgr = persistMgr;
        this.ntReg = ntReg;
        this.usesReferences = usesReferences;
        this.rootNodeId = rootNodeId;
        if (!this.hasNonVirtualItemState(rootNodeId)) {
            this.createRootNodeState(rootNodeId, ntReg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        this.acquireReadLock();
        try {
            int i2;
            for (i2 = 0; i2 < this.virtualProviders.length; ++i2) {
                if (!this.virtualProviders[i2].isVirtualRoot(id)) continue;
                ItemState itemState = this.virtualProviders[i2].getItemState(id);
                return itemState;
            }
            if (this.hasNonVirtualItemState(id)) {
                ItemState i2 = this.getNonVirtualItemState(id);
                return i2;
            }
            for (i2 = 0; i2 < this.virtualProviders.length; ++i2) {
                if (!this.virtualProviders[i2].hasItemState(id)) continue;
                ItemState itemState = this.virtualProviders[i2].getItemState(id);
                return itemState;
            }
        }
        finally {
            this.rwLock.readLock().release();
        }
        throw new NoSuchItemStateException(id.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasItemState(ItemId id) {
        try {
            this.acquireReadLock();
        }
        catch (ItemStateException e) {
            return false;
        }
        try {
            int i;
            if (this.cache.isCached(id)) {
                boolean e = true;
                return e;
            }
            for (i = 0; i < this.virtualProviders.length; ++i) {
                if (!this.virtualProviders[i].isVirtualRoot(id)) continue;
                boolean bl = true;
                return bl;
            }
            if (this.hasNonVirtualItemState(id)) {
                i = 1;
                return i != 0;
            }
            for (i = 0; i < this.virtualProviders.length; ++i) {
                if (!this.virtualProviders[i].hasItemState(id)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.rwLock.readLock().release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
        this.acquireReadLock();
        try {
            NodeReferences nodeReferences = this.persistMgr.load(id);
            return nodeReferences;
        }
        catch (NoSuchItemStateException e) {
            for (int i = 0; i < this.virtualProviders.length; ++i) {
                try {
                    NodeReferences nodeReferences = this.virtualProviders[i].getNodeReferences(id);
                    return nodeReferences;
                }
                catch (NoSuchItemStateException noSuchItemStateException) {
                    continue;
                }
            }
        }
        finally {
            this.rwLock.readLock().release();
        }
        throw new NoSuchItemStateException(id.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasNodeReferences(NodeReferencesId id) {
        block10: {
            try {
                this.acquireReadLock();
            }
            catch (ItemStateException e) {
                return false;
            }
            try {
                if (!this.persistMgr.exists(id)) break block10;
                boolean e = true;
            }
            catch (ItemStateException e) {
                // empty catch block
                break block10;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            this.rwLock.readLock().release();
            return e;
        }
        int i = 0;
        while (i < this.virtualProviders.length) {
            if (this.virtualProviders[i].hasNodeReferences(id)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void stateCreated(ItemState created) {
        this.cache.cache(created);
    }

    public void stateModified(ItemState modified) {
    }

    public void stateDestroyed(ItemState destroyed) {
        destroyed.removeListener(this);
        this.cache.evict(destroyed.getId());
    }

    public void stateDiscarded(ItemState discarded) {
        discarded.removeListener(this);
        this.cache.evict(discarded.getId());
    }

    public void dump(PrintStream ps) {
        ps.println("SharedItemStateManager (" + this + ")");
        ps.println();
        ps.print("[referenceCache] ");
        this.cache.dump(ps);
    }

    public void dispose() {
        this.cache.evictAll();
    }

    public void addVirtualItemStateProvider(VirtualItemStateProvider prov) {
        VirtualItemStateProvider[] provs = new VirtualItemStateProvider[this.virtualProviders.length + 1];
        System.arraycopy(this.virtualProviders, 0, provs, 0, this.virtualProviders.length);
        provs[this.virtualProviders.length] = prov;
        this.virtualProviders = provs;
    }

    public Update beginUpdate(ChangeLog local, EventStateCollectionFactory factory, VirtualItemStateProvider virtualProvider) throws ReferentialIntegrityException, StaleItemStateException, ItemStateException {
        Update update = new Update(local, factory, virtualProvider);
        update.begin();
        return update;
    }

    public void update(ChangeLog local, EventStateCollectionFactory factory) throws ReferentialIntegrityException, StaleItemStateException, ItemStateException {
        this.beginUpdate(local, factory, null).end();
    }

    private NodeState createInstance(NodeId id, QName nodeTypeName, NodeId parentId) {
        NodeState state = this.persistMgr.createNew(id);
        state.setNodeTypeName(nodeTypeName);
        state.setParentId(parentId);
        state.setStatus(4);
        state.addListener(this);
        return state;
    }

    private NodeState createRootNodeState(NodeId rootNodeId, NodeTypeRegistry ntReg) throws ItemStateException {
        PropDef propDef;
        NodeDefId nodeDefId;
        NodeState rootState = this.createInstance(rootNodeId, QName.REP_ROOT, null);
        try {
            nodeDefId = ntReg.getRootNodeDef().getId();
            EffectiveNodeType ent = ntReg.getEffectiveNodeType(QName.REP_ROOT);
            propDef = ent.getApplicablePropertyDef(QName.JCR_PRIMARYTYPE, 7, false);
        }
        catch (NoSuchNodeTypeException nsnte) {
            String msg = "internal error: failed to create root node";
            log.error(msg, (Throwable)nsnte);
            throw new ItemStateException(msg, nsnte);
        }
        catch (ConstraintViolationException cve) {
            String msg = "internal error: failed to create root node";
            log.error(msg, (Throwable)cve);
            throw new ItemStateException(msg, cve);
        }
        rootState.setDefinitionId(nodeDefId);
        rootState.addPropertyName(propDef.getName());
        PropertyState prop = this.createInstance(propDef.getName(), rootNodeId);
        prop.setValues(new InternalValue[]{InternalValue.create(QName.REP_ROOT)});
        prop.setType(propDef.getRequiredType());
        prop.setMultiValued(propDef.isMultiple());
        prop.setDefinitionId(propDef.getId());
        ChangeLog changeLog = new ChangeLog();
        changeLog.added(rootState);
        changeLog.added(prop);
        this.persistMgr.store(changeLog);
        changeLog.persisted();
        return rootState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemState getNonVirtualItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ItemStateReferenceCache itemStateReferenceCache = this.cache;
        synchronized (itemStateReferenceCache) {
            ItemState state = this.cache.retrieve(id);
            if (state == null) {
                state = this.loadItemState(id);
                state.setStatus(1);
                this.cache.cache(state);
                state.addListener(this);
            }
            return state;
        }
    }

    private boolean hasNonVirtualItemState(ItemId id) {
        if (this.cache.isCached(id)) {
            return true;
        }
        try {
            if (id.denotesNode()) {
                return this.persistMgr.exists((NodeId)id);
            }
            return this.persistMgr.exists((PropertyId)id);
        }
        catch (ItemStateException ise) {
            return false;
        }
    }

    private ItemState createInstance(ItemState other) {
        if (other.isNode()) {
            NodeState ns = (NodeState)other;
            return this.createInstance(ns.getNodeId(), ns.getNodeTypeName(), ns.getParentId());
        }
        PropertyState ps = (PropertyState)other;
        return this.createInstance(ps.getName(), ps.getParentId());
    }

    private PropertyState createInstance(QName propName, NodeId parentId) {
        PropertyState state = this.persistMgr.createNew(new PropertyId(parentId, propName));
        state.setStatus(4);
        state.addListener(this);
        return state;
    }

    private ItemState loadItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ItemState state = id.denotesNode() ? this.persistMgr.load((NodeId)id) : this.persistMgr.load((PropertyId)id);
        return state;
    }

    private boolean isReferenceable(NodeState state) throws ItemStateException {
        QName primary = state.getNodeTypeName();
        Set mixins = state.getMixinTypeNames();
        if (mixins.contains(QName.MIX_REFERENCEABLE) || mixins.contains(QName.MIX_VERSIONABLE) || primary.equals(QName.NT_RESOURCE)) {
            return true;
        }
        QName[] types = new QName[mixins.size() + 1];
        mixins.toArray(types);
        types[types.length - 1] = primary;
        try {
            return this.ntReg.getEffectiveNodeType(types).includesNodeType(QName.MIX_REFERENCEABLE);
        }
        catch (NodeTypeConflictException ntce) {
            String msg = "internal error: failed to build effective node type for node " + state.getNodeId();
            log.debug(msg);
            throw new ItemStateException(msg, ntce);
        }
        catch (NoSuchNodeTypeException nsnte) {
            String msg = "internal error: failed to build effective node type for node " + state.getNodeId();
            log.debug(msg);
            throw new ItemStateException(msg, nsnte);
        }
    }

    protected void updateReferences(ChangeLog changes, VirtualItemStateProvider virtualProvider) throws ItemStateException {
        NodeReferences refs;
        InternalValue[] vals;
        PropertyState prop;
        ItemState state;
        Iterator iter = changes.addedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (state.isNode() || (prop = (PropertyState)state).getType() != 9) continue;
            vals = prop.getValues();
            for (int i = 0; vals != null && i < vals.length; ++i) {
                NodeReferencesId refsId = new NodeReferencesId((UUID)vals[i].internalValue());
                if (virtualProvider != null && virtualProvider.hasNodeReferences(refsId)) continue;
                refs = this.getOrCreateNodeReferences(refsId, changes);
                refs.addReference(prop.getPropertyId());
                changes.modified(refs);
            }
        }
        iter = changes.modifiedStates();
        while (iter.hasNext()) {
            NodeReferences refs2;
            NodeReferencesId refsId;
            int i;
            InternalValue[] vals2;
            state = (ItemState)iter.next();
            if (state.isNode()) continue;
            PropertyState newProp = (PropertyState)state;
            PropertyState oldProp = (PropertyState)this.getItemState(state.getId());
            if (oldProp.getType() == 9) {
                vals2 = oldProp.getValues();
                for (i = 0; vals2 != null && i < vals2.length; ++i) {
                    refsId = new NodeReferencesId((UUID)vals2[i].internalValue());
                    if (virtualProvider != null && virtualProvider.hasNodeReferences(refsId)) continue;
                    refs2 = changes.get(refsId);
                    if (refs2 == null) {
                        refs2 = this.getNodeReferences(refsId);
                    }
                    refs2.removeReference(oldProp.getPropertyId());
                    changes.modified(refs2);
                }
            }
            if (newProp.getType() != 9) continue;
            vals2 = newProp.getValues();
            for (i = 0; vals2 != null && i < vals2.length; ++i) {
                refsId = new NodeReferencesId((UUID)vals2[i].internalValue());
                if (virtualProvider != null && virtualProvider.hasNodeReferences(refsId)) continue;
                refs2 = this.getOrCreateNodeReferences(refsId, changes);
                refs2.addReference(newProp.getPropertyId());
                changes.modified(refs2);
            }
        }
        iter = changes.deletedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (state.isNode() || (prop = (PropertyState)state).getType() != 9) continue;
            vals = prop.getValues();
            for (int i = 0; vals != null && i < vals.length; ++i) {
                NodeReferencesId refsId = new NodeReferencesId((UUID)vals[i].internalValue());
                if (virtualProvider != null && virtualProvider.hasNodeReferences(refsId)) continue;
                refs = changes.get(refsId);
                if (refs == null) {
                    refs = this.getNodeReferences(refsId);
                }
                refs.removeReference(prop.getPropertyId());
                changes.modified(refs);
            }
        }
    }

    private NodeReferences getOrCreateNodeReferences(NodeReferencesId refsId, ChangeLog changes) throws ItemStateException {
        NodeReferences refs = changes.get(refsId);
        if (refs == null) {
            refs = this.hasNodeReferences(refsId) ? this.getNodeReferences(refsId) : new NodeReferences(refsId);
        }
        return refs;
    }

    protected void checkReferentialIntegrity(ChangeLog changes) throws ReferentialIntegrityException, ItemStateException {
        Iterator iter = changes.deletedStates();
        while (iter.hasNext()) {
            NodeState node;
            ItemState state = (ItemState)iter.next();
            if (!state.isNode() || !this.isReferenceable(node = (NodeState)state)) continue;
            NodeReferencesId refsId = new NodeReferencesId(node.getNodeId());
            NodeReferences refs = changes.get(refsId);
            if (refs == null) {
                if (!this.hasNodeReferences(refsId)) continue;
                refs = this.getNodeReferences(refsId);
            }
            if (!refs.hasReferences() || changes.has(node.getNodeId())) continue;
            String msg = node.getNodeId() + ": the node cannot be removed because it is still being referenced.";
            log.debug(msg);
            throw new ReferentialIntegrityException(msg);
        }
        iter = changes.modifiedRefs();
        while (iter.hasNext()) {
            NodeReferences refs = (NodeReferences)iter.next();
            NodeId id = refs.getTargetId();
            if (!refs.hasReferences() || changes.has(id) || this.hasItemState(id)) continue;
            String msg = "Target node " + id + " of REFERENCE property does not exist";
            log.debug(msg);
            throw new ReferentialIntegrityException(msg);
        }
    }

    private void acquireReadLock() throws ItemStateException {
        try {
            this.rwLock.readLock().acquire();
        }
        catch (InterruptedException e) {
            throw new ItemStateException("Interrupted while acquiring read lock");
        }
    }

    private void acquireWriteLock() throws ItemStateException {
        try {
            this.rwLock.writeLock().acquire();
        }
        catch (InterruptedException e) {
            throw new ItemStateException("Interrupted while acquiring write lock");
        }
    }

    class Update {
        private final ChangeLog local;
        private final EventStateCollectionFactory factory;
        private final VirtualItemStateProvider virtualProvider;
        private ChangeLog shared;
        private List[] virtualNodeReferences;
        private EventStateCollection events;
        private boolean holdingWriteLock;

        public Update(ChangeLog local, EventStateCollectionFactory factory, VirtualItemStateProvider virtualProvider) {
            this.local = local;
            this.factory = factory;
            this.virtualProvider = virtualProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void begin() throws ItemStateException, ReferentialIntegrityException {
            this.shared = new ChangeLog();
            this.virtualNodeReferences = new List[SharedItemStateManager.this.virtualProviders.length];
            SharedItemStateManager.this.acquireWriteLock();
            this.holdingWriteLock = true;
            boolean succeeded = false;
            try {
                ItemState state;
                if (SharedItemStateManager.this.usesReferences) {
                    SharedItemStateManager.this.updateReferences(this.local, this.virtualProvider);
                }
                SharedItemStateManager.this.checkReferentialIntegrity(this.local);
                try {
                    this.events = this.factory.createEventStateCollection();
                }
                catch (RepositoryException e) {
                    String msg = "Unable to create event state collection.";
                    log.error(msg);
                    throw new ItemStateException(msg, e);
                }
                Iterator iter = this.local.modifiedStates();
                while (iter.hasNext()) {
                    state = (ItemState)iter.next();
                    state.connect(SharedItemStateManager.this.getItemState(state.getId()));
                    if (state.isStale()) {
                        String msg = state.getId() + " has been modified externally";
                        log.debug(msg);
                        throw new StaleItemStateException(msg);
                    }
                    state.getOverlayedState().touch();
                    this.shared.modified(state.getOverlayedState());
                }
                iter = this.local.deletedStates();
                while (iter.hasNext()) {
                    state = (ItemState)iter.next();
                    state.connect(SharedItemStateManager.this.getItemState(state.getId()));
                    if (state.isStale()) {
                        String msg = state.getId() + " has been modified externally";
                        log.debug(msg);
                        throw new StaleItemStateException(msg);
                    }
                    this.shared.deleted(state.getOverlayedState());
                }
                iter = this.local.addedStates();
                while (iter.hasNext()) {
                    state = (ItemState)iter.next();
                    state.connect(SharedItemStateManager.this.createInstance(state));
                    this.shared.added(state.getOverlayedState());
                }
                iter = this.local.modifiedRefs();
                while (iter.hasNext()) {
                    NodeReferences refs = (NodeReferences)iter.next();
                    boolean virtual = false;
                    NodeId id = refs.getId().getTargetId();
                    for (int i = 0; i < SharedItemStateManager.this.virtualProviders.length; ++i) {
                        if (!SharedItemStateManager.this.virtualProviders[i].hasItemState(id)) continue;
                        LinkedList<NodeReferences> virtualRefs = this.virtualNodeReferences[i];
                        if (virtualRefs == null) {
                            this.virtualNodeReferences[i] = virtualRefs = new LinkedList<NodeReferences>();
                        }
                        virtualRefs.add(refs);
                        virtual = true;
                        break;
                    }
                    if (virtual) continue;
                    this.shared.modified(refs);
                }
                this.events.createEventStates(SharedItemStateManager.this.rootNodeId, this.local, SharedItemStateManager.this);
                this.local.push();
                succeeded = true;
            }
            finally {
                if (!succeeded) {
                    this.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void end() throws ItemStateException {
            block11: {
                boolean succeeded = false;
                try {
                    long t0 = System.currentTimeMillis();
                    SharedItemStateManager.this.persistMgr.store(this.shared);
                    succeeded = true;
                    long t1 = System.currentTimeMillis();
                    if (log.isDebugEnabled()) {
                        log.debug("persisting change log " + this.shared + " took " + (t1 - t0) + "ms");
                    }
                }
                finally {
                    if (!succeeded) {
                        this.cancel();
                    }
                }
                try {
                    this.shared.persisted();
                    for (int i = 0; i < this.virtualNodeReferences.length; ++i) {
                        List virtualRefs = this.virtualNodeReferences[i];
                        if (virtualRefs == null) continue;
                        Iterator iter = virtualRefs.iterator();
                        while (iter.hasNext()) {
                            NodeReferences refs = (NodeReferences)iter.next();
                            SharedItemStateManager.this.virtualProviders[i].setNodeReferences(refs);
                        }
                    }
                    SharedItemStateManager.this.acquireReadLock();
                    SharedItemStateManager.this.rwLock.writeLock().release();
                    this.holdingWriteLock = false;
                    this.events.dispatch();
                    Object var8_9 = null;
                    if (!this.holdingWriteLock) break block11;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (this.holdingWriteLock) {
                        SharedItemStateManager.this.rwLock.writeLock().release();
                        this.holdingWriteLock = false;
                        throw throwable;
                    }
                    SharedItemStateManager.this.rwLock.readLock().release();
                    throw throwable;
                }
                SharedItemStateManager.this.rwLock.writeLock().release();
                this.holdingWriteLock = false;
                return;
            }
            SharedItemStateManager.this.rwLock.readLock().release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void cancel() {
            try {
                ItemState state;
                this.local.disconnect();
                Iterator iter = this.shared.modifiedStates();
                while (iter.hasNext()) {
                    state = (ItemState)iter.next();
                    try {
                        state.copy(SharedItemStateManager.this.loadItemState(state.getId()));
                    }
                    catch (ItemStateException e) {
                        state.discard();
                    }
                }
                iter = this.shared.deletedStates();
                while (iter.hasNext()) {
                    state = (ItemState)iter.next();
                    try {
                        state.copy(SharedItemStateManager.this.loadItemState(state.getId()));
                    }
                    catch (ItemStateException e) {
                        state.discard();
                    }
                }
                iter = this.shared.addedStates();
                while (iter.hasNext()) {
                    state = (ItemState)iter.next();
                    state.discard();
                }
                Object var5_6 = null;
                if (!this.holdingWriteLock) return;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (!this.holdingWriteLock) throw throwable;
                SharedItemStateManager.this.rwLock.writeLock().release();
                this.holdingWriteLock = false;
                throw throwable;
            }
            SharedItemStateManager.this.rwLock.writeLock().release();
            this.holdingWriteLock = false;
        }
    }
}

