/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.jackrabbit.core.CachingHierarchyManager;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.ZombieHierarchyManager;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.StaleItemStateException;
import org.apache.jackrabbit.core.state.TransientItemStateManager;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionItemStateManager
implements UpdatableItemStateManager,
Dumpable {
    private static Logger log = LoggerFactory.getLogger((Class)SessionItemStateManager.class);
    private final UpdatableItemStateManager persistentStateMgr;
    private final TransientItemStateManager transientStateMgr;
    private CachingHierarchyManager hierMgr;

    public SessionItemStateManager(NodeId rootNodeId, UpdatableItemStateManager persistentStateMgr, NamespaceResolver nsResolver) {
        this.persistentStateMgr = persistentStateMgr;
        this.transientStateMgr = new TransientItemStateManager();
        this.hierMgr = new CachingHierarchyManager(rootNodeId, this, nsResolver);
    }

    public HierarchyManager getHierarchyMgr() {
        return this.hierMgr;
    }

    public void dump(PrintStream ps) {
        ps.println("SessionItemStateManager (" + this + ")");
        ps.println();
        this.transientStateMgr.dump(ps);
        ps.println();
    }

    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        if (this.transientStateMgr.getAttic().hasItemState(id)) {
            return this.transientStateMgr.getItemState(id);
        }
        if (this.transientStateMgr.hasItemState(id)) {
            return this.transientStateMgr.getItemState(id);
        }
        if (this.persistentStateMgr.hasItemState(id)) {
            return this.persistentStateMgr.getItemState(id);
        }
        throw new NoSuchItemStateException(id.toString());
    }

    public boolean hasItemState(ItemId id) {
        if (this.transientStateMgr.getAttic().hasItemState(id)) {
            return this.transientStateMgr.hasItemState(id);
        }
        if (this.transientStateMgr.hasItemState(id)) {
            return true;
        }
        return this.persistentStateMgr.hasItemState(id);
    }

    public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
        return this.persistentStateMgr.getNodeReferences(id);
    }

    public boolean hasNodeReferences(NodeReferencesId id) {
        return this.persistentStateMgr.hasNodeReferences(id);
    }

    public void edit() throws IllegalStateException {
        this.persistentStateMgr.edit();
    }

    public boolean inEditMode() {
        return this.persistentStateMgr.inEditMode();
    }

    public NodeState createNew(NodeId id, QName nodeTypeName, NodeId parentId) throws IllegalStateException {
        return this.persistentStateMgr.createNew(id, nodeTypeName, parentId);
    }

    public NodeState createNew(NodeState transientState) throws IllegalStateException {
        NodeState persistentState = this.createNew(transientState.getNodeId(), transientState.getNodeTypeName(), transientState.getParentId());
        transientState.connect(persistentState);
        return persistentState;
    }

    public PropertyState createNew(QName propName, NodeId parentId) throws IllegalStateException {
        return this.persistentStateMgr.createNew(propName, parentId);
    }

    public PropertyState createNew(PropertyState transientState) throws IllegalStateException {
        PropertyState persistentState = this.createNew(transientState.getName(), transientState.getParentId());
        transientState.connect(persistentState);
        return persistentState;
    }

    public void store(ItemState state) throws IllegalStateException {
        this.persistentStateMgr.store(state);
    }

    public void destroy(ItemState state) throws IllegalStateException {
        this.persistentStateMgr.destroy(state);
    }

    public void cancel() throws IllegalStateException {
        this.persistentStateMgr.cancel();
    }

    public void update() throws ReferentialIntegrityException, StaleItemStateException, ItemStateException, IllegalStateException {
        this.persistentStateMgr.update();
    }

    public void dispose() {
        this.transientStateMgr.disposeAllItemStates();
        this.persistentStateMgr.dispose();
    }

    public ItemState getTransientItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        return this.transientStateMgr.getItemState(id);
    }

    public boolean hasAnyTransientItemStates() {
        return this.transientStateMgr.hasAnyItemStates();
    }

    public Iterator getDescendantTransientItemStates(NodeId parentId) throws InvalidItemStateException, RepositoryException {
        if (!this.transientStateMgr.hasAnyItemStates()) {
            return Collections.EMPTY_LIST.iterator();
        }
        List[] la = new List[10];
        try {
            Iterator iter = this.transientStateMgr.getEntries();
            while (iter.hasNext()) {
                ArrayList<ItemState> list;
                int depth;
                ItemState state = (ItemState)iter.next();
                try {
                    depth = this.hierMgr.getRelativeDepth(parentId, state.getId());
                }
                catch (ItemNotFoundException infe) {
                    String msg = state.getId() + ": the item seems to have been removed externally.";
                    log.debug(msg);
                    throw new InvalidItemStateException(msg);
                }
                if (depth < 1) continue;
                if (depth > la.length) {
                    List[] old = la;
                    la = new List[depth + 10];
                    System.arraycopy(old, 0, la, 0, old.length);
                }
                if ((list = la[depth - 1]) == null) {
                    la[depth - 1] = list = new ArrayList<ItemState>();
                }
                list.add(state);
            }
        }
        catch (RepositoryException re) {
            log.warn("inconsistent hierarchy state", (Throwable)re);
        }
        IteratorChain resultIter = new IteratorChain();
        for (int i = la.length - 1; i >= 0; --i) {
            List list = la[i];
            if (list == null) continue;
            resultIter.addIterator(list.iterator());
        }
        if (resultIter.getIterators().isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return resultIter;
    }

    public Iterator getDescendantTransientItemStatesInAttic(NodeId parentId) {
        if (!this.transientStateMgr.hasAnyItemStatesInAttic()) {
            return Collections.EMPTY_LIST.iterator();
        }
        ZombieHierarchyManager zombieHierMgr = new ZombieHierarchyManager(this.hierMgr.getRootNodeId(), this, this.transientStateMgr.getAttic(), this.hierMgr.getNamespaceResolver());
        List[] la = new List[10];
        try {
            Iterator iter = this.transientStateMgr.getEntriesInAttic();
            while (iter.hasNext()) {
                ArrayList<ItemState> list;
                ItemState state = (ItemState)iter.next();
                int depth = zombieHierMgr.getRelativeDepth(parentId, state.getId());
                if (depth < 1) continue;
                if (depth > la.length) {
                    List[] old = la;
                    la = new List[depth + 10];
                    System.arraycopy(old, 0, la, 0, old.length);
                }
                if ((list = la[depth - 1]) == null) {
                    la[depth - 1] = list = new ArrayList<ItemState>();
                }
                list.add(state);
            }
        }
        catch (RepositoryException re) {
            log.warn("inconsistent hierarchy state", (Throwable)re);
        }
        IteratorChain resultIter = new IteratorChain();
        for (int i = la.length - 1; i >= 0; --i) {
            List list = la[i];
            if (list == null) continue;
            resultIter.addIterator(list.iterator());
        }
        if (resultIter.getIterators().isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return resultIter;
    }

    public boolean isItemStateInAttic(ItemId id) {
        return this.transientStateMgr.getAttic().hasItemState(id);
    }

    public NodeState createTransientNodeState(NodeId id, QName nodeTypeName, NodeId parentId, int initialStatus) throws ItemStateException {
        return this.transientStateMgr.createNodeState(id, nodeTypeName, parentId, initialStatus);
    }

    public NodeState createTransientNodeState(NodeState overlayedState, int initialStatus) throws ItemStateException {
        NodeState state = this.transientStateMgr.createNodeState(overlayedState, initialStatus);
        this.hierMgr.stateOverlaid(state);
        return state;
    }

    public PropertyState createTransientPropertyState(NodeId parentId, QName propName, int initialStatus) throws ItemStateException {
        return this.transientStateMgr.createPropertyState(parentId, propName, initialStatus);
    }

    public PropertyState createTransientPropertyState(PropertyState overlayedState, int initialStatus) throws ItemStateException {
        PropertyState state = this.transientStateMgr.createPropertyState(overlayedState, initialStatus);
        this.hierMgr.stateOverlaid(state);
        return state;
    }

    public void disconnectTransientItemState(ItemState state) {
        this.hierMgr.stateUncovered(state);
        state.disconnect();
    }

    public void disposeTransientItemState(ItemState state) {
        this.transientStateMgr.disposeItemState(state);
    }

    public void moveTransientItemStateToAttic(ItemState state) {
        this.transientStateMgr.moveItemStateToAttic(state);
    }

    public void disposeTransientItemStateInAttic(ItemState state) {
        this.transientStateMgr.disposeItemStateInAttic(state);
    }

    public void disposeAllTransientItemStates() {
        this.transientStateMgr.disposeAllItemStates();
    }
}

