/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.util.WeakIdentityCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ItemState
implements ItemStateListener,
Serializable {
    static final long serialVersionUID = -1473610775880779769L;
    private static Logger log;
    public static final int STATUS_UNDEFINED = 0;
    public static final int STATUS_EXISTING = 1;
    public static final int STATUS_EXISTING_MODIFIED = 2;
    public static final int STATUS_EXISTING_REMOVED = 3;
    public static final int STATUS_NEW = 4;
    public static final int STATUS_STALE_MODIFIED = 5;
    public static final int STATUS_STALE_DESTROYED = 6;
    protected int status = 0;
    private short modCount;
    private final boolean isTransient;
    private final transient Collection listeners = new WeakIdentityCollection(5);
    protected transient ItemState overlayedState;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ItemState(int initialStatus, boolean isTransient) {
        switch (initialStatus) {
            case 1: 
            case 4: {
                this.status = initialStatus;
                break;
            }
            default: {
                String msg = "illegal status: " + initialStatus;
                log.debug(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        this.modCount = 0;
        this.overlayedState = null;
        this.isTransient = isTransient;
    }

    protected ItemState(ItemState overlayedState, int initialStatus, boolean isTransient) {
        switch (initialStatus) {
            case 1: 
            case 2: 
            case 3: {
                this.status = initialStatus;
                break;
            }
            default: {
                String msg = "illegal status: " + initialStatus;
                log.debug(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        this.isTransient = isTransient;
        this.connect(overlayedState);
    }

    protected abstract void copy(ItemState var1);

    void pull() {
        if (this.overlayedState != null) {
            this.copy(this.overlayedState);
            this.modCount = this.overlayedState.getModCount();
        }
    }

    void push() {
        if (this.overlayedState != null) {
            this.overlayedState.copy(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDisposed() {
        Collection collection = this.listeners;
        synchronized (collection) {
            this.listeners.clear();
        }
        this.disconnect();
        this.overlayedState = null;
        this.status = 0;
    }

    protected void connect(ItemState overlayedState) {
        if (this.overlayedState != null && this.overlayedState != overlayedState) {
            throw new IllegalStateException("Item state already connected to another underlying state: " + this);
        }
        this.overlayedState = overlayedState;
        this.overlayedState.addListener(this);
    }

    protected void reconnect() {
        if (this.overlayedState == null) {
            throw new IllegalStateException("Item state cannot be reconnected because there's no underlying state to reconnect to: " + this);
        }
        this.overlayedState.addListener(this);
    }

    protected void disconnect() {
        if (this.overlayedState != null) {
            this.overlayedState.removeListener(this);
            this.overlayedState = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStateDiscarded() {
        ItemStateListener[] la;
        Collection collection = this.listeners;
        synchronized (collection) {
            la = this.listeners.toArray(new ItemStateListener[this.listeners.size()]);
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].stateDiscarded(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStateCreated() {
        ItemStateListener[] la;
        Collection collection = this.listeners;
        synchronized (collection) {
            la = this.listeners.toArray(new ItemStateListener[this.listeners.size()]);
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].stateCreated(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyStateUpdated() {
        ItemStateListener[] la;
        Collection collection = this.listeners;
        synchronized (collection) {
            la = this.listeners.toArray(new ItemStateListener[this.listeners.size()]);
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].stateModified(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStateDestroyed() {
        ItemStateListener[] la;
        Collection collection = this.listeners;
        synchronized (collection) {
            la = this.listeners.toArray(new ItemStateListener[this.listeners.size()]);
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].stateDestroyed(this);
        }
    }

    public abstract boolean isNode();

    public abstract ItemId getId();

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isStale() {
        if (this.isTransient) {
            return this.status == 5 || this.status == 6;
        }
        return this.overlayedState != null && this.modCount != this.overlayedState.getModCount();
    }

    public abstract NodeId getParentId();

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int newStatus) {
        switch (newStatus) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.status = newStatus;
                return;
            }
        }
        String msg = "illegal status: " + newStatus;
        log.debug(msg);
        throw new IllegalArgumentException(msg);
    }

    public short getModCount() {
        return this.modCount;
    }

    public void setModCount(short modCount) {
        this.modCount = modCount;
    }

    synchronized void touch() {
        this.modCount = (short)(this.modCount + 1);
    }

    public void discard() {
        if (this.status != 0) {
            this.notifyStateDiscarded();
            this.status = 0;
        }
    }

    public boolean hasOverlayedState() {
        return this.overlayedState != null;
    }

    public ItemState getOverlayedState() {
        return this.overlayedState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ItemStateListener listener) {
        Collection collection = this.listeners;
        synchronized (collection) {
            if (!$assertionsDisabled && this.listeners.contains(listener)) {
                throw new AssertionError();
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ItemStateListener listener) {
        Collection collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(listener);
        }
    }

    public void stateCreated(ItemState created) {
        this.status = 1;
        this.pull();
    }

    public void stateDestroyed(ItemState destroyed) {
        if (this.isTransient) {
            this.status = 6;
        } else {
            this.status = 3;
            this.notifyStateDestroyed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateModified(ItemState modified) {
        if (this.isTransient) {
            this.status = 5;
        } else {
            ItemState itemState = this;
            synchronized (itemState) {
                this.pull();
                this.notifyStateUpdated();
            }
        }
    }

    public void stateDiscarded(ItemState discarded) {
        this.discard();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    static {
        $assertionsDisabled = !ItemState.class.desiredAssertionStatus();
        log = LoggerFactory.getLogger((Class)ItemState.class);
    }
}

