/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.AnonymousPrincipal;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAccessManager
implements AccessManager {
    private static Logger log = LoggerFactory.getLogger((Class)SimpleAccessManager.class);
    protected Subject subject;
    protected HierarchyManager hierMgr;
    private boolean initialized = false;
    protected boolean system = false;
    protected boolean anonymous = false;

    public void init(AMContext context) throws AccessDeniedException, Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        this.subject = context.getSubject();
        this.hierMgr = context.getHierarchyManager();
        this.anonymous = !this.subject.getPrincipals(AnonymousPrincipal.class).isEmpty();
        this.system = !this.subject.getPrincipals(SystemPrincipal.class).isEmpty();
        this.initialized = true;
    }

    public synchronized void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        this.initialized = false;
    }

    public void checkPermission(ItemId id, int permissions) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        if (this.system) {
            return;
        }
        if (this.anonymous && ((permissions & 2) == 2 || (permissions & 4) == 4)) {
            throw new AccessDeniedException();
        }
    }

    public boolean isGranted(ItemId id, int permissions) throws ItemNotFoundException, RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        if (this.system) {
            return true;
        }
        return !this.anonymous || (permissions & 2) != 2 && (permissions & 4) != 4;
    }

    public boolean canAccess(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        return true;
    }
}

