/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.xpath;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.jcr.query.InvalidQueryException;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.query.AndQueryNode;
import org.apache.jackrabbit.core.query.DerefQueryNode;
import org.apache.jackrabbit.core.query.LocationStepQueryNode;
import org.apache.jackrabbit.core.query.NAryQueryNode;
import org.apache.jackrabbit.core.query.NodeTypeQueryNode;
import org.apache.jackrabbit.core.query.NotQueryNode;
import org.apache.jackrabbit.core.query.OrQueryNode;
import org.apache.jackrabbit.core.query.OrderQueryNode;
import org.apache.jackrabbit.core.query.PathQueryNode;
import org.apache.jackrabbit.core.query.QueryNode;
import org.apache.jackrabbit.core.query.QueryRootNode;
import org.apache.jackrabbit.core.query.RelationQueryNode;
import org.apache.jackrabbit.core.query.TextsearchQueryNode;
import org.apache.jackrabbit.core.query.xpath.Node;
import org.apache.jackrabbit.core.query.xpath.ParseException;
import org.apache.jackrabbit.core.query.xpath.QueryFormat;
import org.apache.jackrabbit.core.query.xpath.SimpleNode;
import org.apache.jackrabbit.core.query.xpath.XPath;
import org.apache.jackrabbit.core.query.xpath.XPathTreeConstants;
import org.apache.jackrabbit.core.query.xpath.XPathVisitor;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.ISO9075;

public class XPathQueryBuilder
implements XPathVisitor,
XPathTreeConstants {
    static final QName FN_NOT = new QName("http://www.w3.org/2004/10/xpath-functions", "not");
    static final QName FN_NOT_10 = new QName("", "not");
    static final QName FN_TRUE = new QName("", "true");
    static final QName FN_FALSE = new QName("", "false");
    static final QName FN_POSITION = new QName("", "position");
    static final QName FN_ELEMENT = new QName("", "element");
    static final QName FN_POSITION_FULL = new QName("", "position()");
    static final QName JCR_XMLTEXT = new QName("http://www.jcp.org/jcr/1.0", "xmltext");
    static final QName FN_LAST = new QName("", "last");
    static final QName FN_FIRST = new QName("", "first");
    static final QName XS_DATETIME = new QName("http://www.w3.org/2001/XMLSchema", "dateTime");
    static final QName JCR_LIKE = new QName("http://www.jcp.org/jcr/1.0", "like");
    static final QName JCR_DEREF = new QName("http://www.jcp.org/jcr/1.0", "deref");
    static final QName JCR_CONTAINS = new QName("http://www.jcp.org/jcr/1.0", "contains");
    static final QName JCR_ROOT = new QName("http://www.jcp.org/jcr/1.0", "root");
    static final QName JCR_SCORE = new QName("http://www.jcp.org/jcr/1.0", "score");
    private static final String OP_EQ = "eq";
    private static final String OP_NE = "ne";
    private static final String OP_GT = "gt";
    private static final String OP_GE = "ge";
    private static final String OP_LT = "lt";
    private static final String OP_LE = "le";
    private static final String OP_SIGN_EQ = "=";
    private static final String OP_SIGN_NE = "!=";
    private static final String OP_SIGN_GT = ">";
    private static final String OP_SIGN_GE = ">=";
    private static final String OP_SIGN_LT = "<";
    private static final String OP_SIGN_LE = "<=";
    private static Map parsers = new ReferenceMap(2, 2);
    private final QueryRootNode root = new QueryRootNode();
    private final NamespaceResolver resolver;
    private final List exceptions = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XPathQueryBuilder(String statement, NamespaceResolver resolver) throws InvalidQueryException {
        this.resolver = resolver;
        try {
            SimpleNode query;
            XPath parser;
            statement = "for $v in " + statement + " return $v";
            Map map = parsers;
            synchronized (map) {
                parser = (XPath)parsers.get(resolver);
                if (parser == null) {
                    parser = new XPath(new StringReader(statement));
                    parsers.put(resolver, parser);
                }
            }
            XPath xPath = parser;
            synchronized (xPath) {
                parser.ReInit(new StringReader(statement));
                query = parser.XPath2();
            }
            query.jjtAccept(this, this.root);
        }
        catch (ParseException e) {
            throw new InvalidQueryException(e.getMessage(), (Throwable)e);
        }
        catch (Throwable t) {
            throw new InvalidQueryException(t.getMessage(), t);
        }
        if (this.exceptions.size() > 0) {
            Exception e = (Exception)this.exceptions.get(0);
            if (e instanceof InvalidQueryException) {
                throw (InvalidQueryException)e;
            }
            throw new InvalidQueryException(e.getMessage(), (Throwable)e);
        }
    }

    public static QueryRootNode createQuery(String statement, NamespaceResolver resolver) throws InvalidQueryException {
        QueryRootNode root = new XPathQueryBuilder(statement, resolver).getRootNode();
        return root;
    }

    public static String toString(QueryRootNode root, NamespaceResolver resolver) throws InvalidQueryException {
        return QueryFormat.toString(root, resolver);
    }

    QueryRootNode getRootNode() {
        return this.root;
    }

    public Object visit(SimpleNode node, Object data) {
        QueryNode queryNode = (QueryNode)data;
        switch (node.getId()) {
            case 0: {
                queryNode = this.createPathQueryNode(node);
                break;
            }
            case 120: 
            case 121: {
                ((PathQueryNode)queryNode).setAbsolute(true);
                break;
            }
            case 123: {
                if (this.isAttributeAxis(node)) {
                    if (queryNode.getType() == 2 || queryNode.getType() == 12 && ((DerefQueryNode)queryNode).getRefProperty() == null || queryNode.getType() == 3 || queryNode.getType() == 11 || queryNode.getType() == 4) {
                        node.childrenAccept(this, queryNode);
                        break;
                    }
                    if (queryNode.getType() == 9) {
                        RelationQueryNode isNull = new RelationQueryNode(queryNode, 26);
                        node.childrenAccept(this, isNull);
                        NotQueryNode notNode = (NotQueryNode)queryNode;
                        NAryQueryNode parent = (NAryQueryNode)notNode.getParent();
                        parent.removeOperand(notNode);
                        parent.addOperand(isNull);
                        break;
                    }
                    RelationQueryNode notNull = new RelationQueryNode(queryNode, 27);
                    node.childrenAccept(this, notNull);
                    ((NAryQueryNode)queryNode).addOperand(notNull);
                    break;
                }
                if (queryNode.getType() == 11) {
                    this.createLocationStep(node, (NAryQueryNode)queryNode);
                    break;
                }
                if (queryNode.getType() == 4) break;
                this.exceptions.add(new InvalidQueryException("Only attribute axis is allowed in predicate"));
                break;
            }
            case 139: {
                if (queryNode.getType() == 10 || queryNode.getType() == 12 || queryNode.getType() == 2 || queryNode.getType() == 4 || queryNode.getType() == 11) {
                    this.createNodeTest(node, queryNode);
                    break;
                }
                if (queryNode.getType() == 3) {
                    this.createOrderSpec(node, (OrderQueryNode)queryNode);
                    break;
                }
                node.childrenAccept(this, queryNode);
                break;
            }
            case 261: {
                SimpleNode child;
                if (queryNode.getType() != 10 || (child = (SimpleNode)node.jjtGetChild(0)).getId() == 251) break;
                this.createNodeTest(child, queryNode);
                break;
            }
            case 238: {
                if (queryNode.getType() != 10) break;
                LocationStepQueryNode loc = (LocationStepQueryNode)queryNode;
                loc.setNameTest(JCR_XMLTEXT);
                break;
            }
            case 270: {
                if (queryNode.getType() != 10) break;
                LocationStepQueryNode loc = (LocationStepQueryNode)queryNode;
                String ntName = ((SimpleNode)node.jjtGetChild(0)).getValue();
                try {
                    QName nt = QName.fromJCRName(ntName, this.resolver);
                    NodeTypeQueryNode nodeType = new NodeTypeQueryNode(loc, nt);
                    loc.addPredicate(nodeType);
                }
                catch (IllegalNameException e) {
                    this.exceptions.add(new InvalidQueryException("Not a valid name: " + ntName));
                }
                catch (UnknownPrefixException e) {
                    this.exceptions.add(new InvalidQueryException("Unknown prefix in name: " + ntName));
                }
                break;
            }
            case 100: {
                NAryQueryNode parent = (NAryQueryNode)queryNode;
                queryNode = new OrQueryNode(parent);
                parent.addOperand(queryNode);
                node.childrenAccept(this, queryNode);
                break;
            }
            case 101: {
                NAryQueryNode parent = (NAryQueryNode)queryNode;
                queryNode = new AndQueryNode(parent);
                parent.addOperand(queryNode);
                node.childrenAccept(this, queryNode);
                break;
            }
            case 102: {
                this.createExpression(node, (NAryQueryNode)queryNode);
                break;
            }
            case 47: 
            case 146: 
            case 147: 
            case 148: {
                if (queryNode.getType() == 2) {
                    this.assignValue(node, (RelationQueryNode)queryNode);
                    break;
                }
                if (queryNode.getType() == 10) {
                    if (node.getId() == 146) {
                        int index = Integer.parseInt(node.getValue());
                        ((LocationStepQueryNode)queryNode).setIndex(index);
                        break;
                    }
                    this.exceptions.add(new InvalidQueryException("LocationStep only allows integer literal as position index"));
                    break;
                }
                this.exceptions.add(new InvalidQueryException("Parse error: data is not a RelationQueryNode"));
                break;
            }
            case 114: {
                if (queryNode.getType() == 2) {
                    ((RelationQueryNode)queryNode).setUnaryMinus(true);
                    break;
                }
                this.exceptions.add(new InvalidQueryException("Parse error: data is not a RelationQueryNode"));
                break;
            }
            case 152: {
                queryNode = this.createFunction(node, queryNode);
                break;
            }
            case 81: {
                this.root.setOrderNode(new OrderQueryNode(this.root));
                queryNode = this.root.getOrderNode();
                node.childrenAccept(this, queryNode);
                break;
            }
            case 86: {
                if (node.jjtGetNumChildren() <= 0 || ((SimpleNode)node.jjtGetChild(0)).getId() != 88) break;
                OrderQueryNode.OrderSpec[] specs = ((OrderQueryNode)queryNode).getOrderSpecs();
                specs[specs.length - 1].setAscending(false);
                break;
            }
            case 144: {
                if (queryNode.getType() == 11) {
                    QueryNode[] operands = ((PathQueryNode)queryNode).getOperands();
                    queryNode = operands[operands.length - 1];
                }
                node.childrenAccept(this, queryNode);
                break;
            }
            default: {
                node.childrenAccept(this, queryNode);
            }
        }
        return queryNode;
    }

    private LocationStepQueryNode createLocationStep(SimpleNode node, NAryQueryNode parent) {
        LocationStepQueryNode queryNode = null;
        boolean descendant = false;
        Node p = node.jjtGetParent();
        for (int i = 0; i < p.jjtGetNumChildren(); ++i) {
            SimpleNode c = (SimpleNode)p.jjtGetChild(i);
            if (c == node) {
                queryNode = new LocationStepQueryNode(parent, null, descendant);
                parent.addOperand(queryNode);
                break;
            }
            descendant = c.getId() == 122 || c.getId() == 121;
        }
        node.childrenAccept(this, queryNode);
        return queryNode;
    }

    private void createNodeTest(SimpleNode node, QueryNode queryNode) {
        if (node.jjtGetNumChildren() > 0) {
            SimpleNode child = (SimpleNode)node.jjtGetChild(0);
            if (child.getId() == 140 || child.getId() == 268) {
                try {
                    if (queryNode.getType() == 10) {
                        QName name = ISO9075.decode(QName.fromJCRName(child.getValue(), this.resolver));
                        if (name.equals(JCR_ROOT)) {
                            name = LocationStepQueryNode.EMPTY_NAME;
                        }
                        ((LocationStepQueryNode)queryNode).setNameTest(name);
                    } else if (queryNode.getType() == 12) {
                        QName name = ISO9075.decode(QName.fromJCRName(child.getValue(), this.resolver));
                        ((DerefQueryNode)queryNode).setRefProperty(name);
                    } else if (queryNode.getType() == 2) {
                        QName name = ISO9075.decode(QName.fromJCRName(child.getValue(), this.resolver));
                        ((RelationQueryNode)queryNode).setProperty(name);
                    } else if (queryNode.getType() == 11) {
                        QName name = ISO9075.decode(QName.fromJCRName(child.getValue(), this.resolver));
                        this.root.addSelectProperty(name);
                    } else if (queryNode.getType() == 3) {
                        QName name = ISO9075.decode(QName.fromJCRName(child.getValue(), this.resolver));
                        this.root.getOrderNode().addOrderSpec(name, true);
                    } else if (queryNode.getType() == 4) {
                        QName name = ISO9075.decode(QName.fromJCRName(child.getValue(), this.resolver));
                        ((TextsearchQueryNode)queryNode).setPropertyName(name);
                    }
                }
                catch (IllegalNameException e) {
                    this.exceptions.add(new InvalidQueryException("Illegal name: " + child.getValue()));
                }
                catch (UnknownPrefixException e) {
                    this.exceptions.add(new InvalidQueryException("Unknown prefix: " + child.getValue()));
                }
            } else if (child.getId() == 141) {
                if (queryNode.getType() == 10) {
                    ((LocationStepQueryNode)queryNode).setNameTest(null);
                }
            } else {
                this.exceptions.add(new InvalidQueryException("Unsupported location for name test: " + child));
            }
        }
    }

    private void createExpression(SimpleNode node, NAryQueryNode queryNode) {
        if (node.getId() != 102) {
            throw new IllegalArgumentException("node must be of type ComparisonExpr");
        }
        String opType = node.getValue();
        int type = 0;
        if (opType.equals(OP_EQ)) {
            type = 11;
        } else if (opType.equals(OP_SIGN_EQ)) {
            type = 12;
        } else if (opType.equals(OP_GT)) {
            type = 17;
        } else if (opType.equals(OP_SIGN_GT)) {
            type = 18;
        } else if (opType.equals(OP_GE)) {
            type = 19;
        } else if (opType.equals(OP_SIGN_GE)) {
            type = 20;
        } else if (opType.equals(OP_LE)) {
            type = 21;
        } else if (opType.equals(OP_SIGN_LE)) {
            type = 22;
        } else if (opType.equals(OP_LT)) {
            type = 15;
        } else if (opType.equals(OP_SIGN_LT)) {
            type = 16;
        } else if (opType.equals(OP_NE)) {
            type = 13;
        } else if (opType.equals(OP_SIGN_NE)) {
            type = 14;
        } else {
            this.exceptions.add(new InvalidQueryException("Unsupported ComparisonExpr type:" + node.getValue()));
        }
        RelationQueryNode rqn = new RelationQueryNode(queryNode, type);
        node.childrenAccept(this, rqn);
        queryNode.addOperand(rqn);
    }

    private PathQueryNode createPathQueryNode(SimpleNode node) {
        this.root.setLocationNode(new PathQueryNode(this.root));
        node.childrenAccept(this, this.root.getLocationNode());
        return this.root.getLocationNode();
    }

    private void assignValue(SimpleNode node, RelationQueryNode queryNode) {
        if (node.getId() == 47) {
            queryNode.setStringValue(this.unescapeQuotes(node.getValue()));
        } else if (node.getId() == 147) {
            queryNode.setDoubleValue(Double.parseDouble(node.getValue()));
        } else if (node.getId() == 148) {
            queryNode.setDoubleValue(Double.parseDouble(node.getValue()));
        } else if (node.getId() == 146) {
            if (queryNode.getValueType() == 6) {
                queryNode.setPositionValue(Integer.parseInt(node.getValue()));
            } else {
                queryNode.setLongValue(Long.parseLong(node.getValue()));
            }
        } else {
            this.exceptions.add(new InvalidQueryException("Unsupported literal type:" + node.toString()));
        }
    }

    private QueryNode createFunction(SimpleNode node, QueryNode queryNode) {
        block67: {
            String fName = ((SimpleNode)node.jjtGetChild(0)).getValue();
            fName = fName.substring(0, fName.length() - 1);
            try {
                if (FN_NOT.toJCRName(this.resolver).equals(fName) || FN_NOT_10.toJCRName(this.resolver).equals(fName)) {
                    if (queryNode instanceof NAryQueryNode) {
                        NotQueryNode not = new NotQueryNode(queryNode);
                        ((NAryQueryNode)queryNode).addOperand(not);
                        queryNode = not;
                        if (node.jjtGetNumChildren() == 2) {
                            node.jjtGetChild(1).jjtAccept(this, queryNode);
                        } else {
                            this.exceptions.add(new InvalidQueryException("fn:not only supports one expression argument"));
                        }
                    } else {
                        this.exceptions.add(new InvalidQueryException("Unsupported location for function fn:not"));
                    }
                    break block67;
                }
                if (XS_DATETIME.toJCRName(this.resolver).equals(fName)) {
                    if (node.jjtGetNumChildren() == 2) {
                        if (queryNode instanceof RelationQueryNode) {
                            RelationQueryNode rel = (RelationQueryNode)queryNode;
                            SimpleNode literal = (SimpleNode)node.jjtGetChild(1).jjtGetChild(0);
                            if (literal.getId() == 47) {
                                String value = literal.getValue();
                                Calendar c = ISO8601.parse(value = value.substring(1, value.length() - 1));
                                if (c == null) {
                                    this.exceptions.add(new InvalidQueryException("Unable to parse string literal for xs:dateTime: " + value));
                                } else {
                                    rel.setDateValue(c.getTime());
                                }
                            } else {
                                this.exceptions.add(new InvalidQueryException("Wrong argument type for xs:dateTime"));
                            }
                        } else {
                            this.exceptions.add(new InvalidQueryException("Unsupported location for function xs:dateTime"));
                        }
                    } else {
                        this.exceptions.add(new InvalidQueryException("Wrong number of arguments for xs:dateTime"));
                    }
                    break block67;
                }
                if (JCR_CONTAINS.toJCRName(this.resolver).equals(fName)) {
                    if (node.jjtGetNumChildren() == 3) {
                        if (queryNode instanceof NAryQueryNode) {
                            SimpleNode literal = (SimpleNode)node.jjtGetChild(2).jjtGetChild(0);
                            if (literal.getId() == 47) {
                                TextsearchQueryNode contains = new TextsearchQueryNode(queryNode, this.unescapeQuotes(literal.getValue()));
                                SimpleNode path = (SimpleNode)node.jjtGetChild(1);
                                path.jjtAccept(this, contains);
                                ((NAryQueryNode)queryNode).addOperand(contains);
                            } else {
                                this.exceptions.add(new InvalidQueryException("Wrong argument type for jcr:contains"));
                            }
                        }
                    } else {
                        this.exceptions.add(new InvalidQueryException("Wrong number of arguments for jcr:contains"));
                    }
                    break block67;
                }
                if (JCR_LIKE.toJCRName(this.resolver).equals(fName)) {
                    if (node.jjtGetNumChildren() == 3) {
                        if (queryNode instanceof NAryQueryNode) {
                            SimpleNode literal;
                            RelationQueryNode like = new RelationQueryNode(queryNode, 23);
                            ((NAryQueryNode)queryNode).addOperand(like);
                            node.jjtGetChild(1).jjtAccept(this, like);
                            if (like.getProperty() == null) {
                                this.exceptions.add(new InvalidQueryException("Wrong first argument type for jcr:like"));
                            }
                            if ((literal = (SimpleNode)node.jjtGetChild(2).jjtGetChild(0)).getId() == 47) {
                                like.setStringValue(this.unescapeQuotes(literal.getValue()));
                            } else {
                                this.exceptions.add(new InvalidQueryException("Wrong second argument type for jcr:like"));
                            }
                        } else {
                            this.exceptions.add(new InvalidQueryException("Unsupported location for function jcr:like"));
                        }
                    } else {
                        this.exceptions.add(new InvalidQueryException("Wrong number of arguments for jcr:like"));
                    }
                    break block67;
                }
                if (FN_TRUE.toJCRName(this.resolver).equals(fName)) {
                    if (queryNode.getType() == 2) {
                        RelationQueryNode rel = (RelationQueryNode)queryNode;
                        rel.setStringValue("true");
                    } else {
                        this.exceptions.add(new InvalidQueryException("Unsupported location for true()"));
                    }
                    break block67;
                }
                if (FN_FALSE.toJCRName(this.resolver).equals(fName)) {
                    if (queryNode.getType() == 2) {
                        RelationQueryNode rel = (RelationQueryNode)queryNode;
                        rel.setStringValue("false");
                    } else {
                        this.exceptions.add(new InvalidQueryException("Unsupported location for false()"));
                    }
                    break block67;
                }
                if (FN_POSITION.toJCRName(this.resolver).equals(fName)) {
                    if (queryNode.getType() == 2) {
                        RelationQueryNode rel = (RelationQueryNode)queryNode;
                        if (rel.getOperation() == 12) {
                            rel.setPositionValue(1);
                            rel.setProperty(FN_POSITION_FULL);
                        } else {
                            this.exceptions.add(new InvalidQueryException("Unsupported expression with position(). Only = is supported."));
                        }
                    } else {
                        this.exceptions.add(new InvalidQueryException("Unsupported location for position()"));
                    }
                    break block67;
                }
                if (FN_FIRST.toJCRName(this.resolver).equals(fName)) {
                    if (queryNode.getType() == 2) {
                        ((RelationQueryNode)queryNode).setPositionValue(1);
                    } else if (queryNode.getType() == 10) {
                        ((LocationStepQueryNode)queryNode).setIndex(1);
                    } else {
                        this.exceptions.add(new InvalidQueryException("Unsupported location for first()"));
                    }
                    break block67;
                }
                if (FN_LAST.toJCRName(this.resolver).equals(fName)) {
                    if (queryNode.getType() == 2) {
                        ((RelationQueryNode)queryNode).setPositionValue(Integer.MIN_VALUE);
                    } else if (queryNode.getType() == 10) {
                        ((LocationStepQueryNode)queryNode).setIndex(Integer.MIN_VALUE);
                    } else {
                        this.exceptions.add(new InvalidQueryException("Unsupported location for last()"));
                    }
                    break block67;
                }
                if (JCR_DEREF.toJCRName(this.resolver).equals(fName)) {
                    if (node.jjtGetNumChildren() != 3) break block67;
                    boolean descendant = false;
                    if (queryNode.getType() == 10) {
                        LocationStepQueryNode loc = (LocationStepQueryNode)queryNode;
                        descendant = loc.getIncludeDescendants();
                        queryNode = loc.getParent();
                        ((NAryQueryNode)queryNode).removeOperand(loc);
                    }
                    if (queryNode.getType() == 11) {
                        SimpleNode literal;
                        PathQueryNode pathNode = (PathQueryNode)queryNode;
                        DerefQueryNode derefNode = new DerefQueryNode(pathNode, null, false);
                        node.jjtGetChild(1).jjtAccept(this, derefNode);
                        if (derefNode.getRefProperty() == null) {
                            this.exceptions.add(new InvalidQueryException("Wrong first argument type for jcr:deref"));
                        }
                        if ((literal = (SimpleNode)node.jjtGetChild(2).jjtGetChild(0)).getId() == 47) {
                            String value = literal.getValue();
                            if (!(value = value.substring(1, value.length() - 1)).equals("*")) {
                                QName name = null;
                                try {
                                    name = ISO9075.decode(QName.fromJCRName(value, this.resolver));
                                }
                                catch (IllegalNameException e) {
                                    this.exceptions.add(new InvalidQueryException("Illegal name: " + value));
                                }
                                catch (UnknownPrefixException e) {
                                    this.exceptions.add(new InvalidQueryException("Unknown prefix: " + value));
                                }
                                derefNode.setNameTest(name);
                            }
                        } else {
                            this.exceptions.add(new InvalidQueryException("Wrong second argument type for jcr:like"));
                        }
                        if (!descendant) {
                            SimpleNode c;
                            Node p = node.jjtGetParent();
                            for (int i = 0; i < p.jjtGetNumChildren() && (c = (SimpleNode)p.jjtGetChild(i)) != node; ++i) {
                                descendant = c.getId() == 122 || c.getId() == 121;
                            }
                        }
                        derefNode.setIncludeDescendants(descendant);
                        pathNode.addPathStep(derefNode);
                        break block67;
                    }
                    this.exceptions.add(new InvalidQueryException("Unsupported location for jcr:deref()"));
                    break block67;
                }
                if (JCR_SCORE.toJCRName(this.resolver).equals(fName)) {
                    if (queryNode.getType() == 3) {
                        this.createOrderSpec(node, (OrderQueryNode)queryNode);
                    } else {
                        this.exceptions.add(new InvalidQueryException("Unsupported location for jcr:score()"));
                    }
                } else {
                    this.exceptions.add(new InvalidQueryException("Unsupported function: " + fName));
                }
            }
            catch (NoPrefixDeclaredException e) {
                this.exceptions.add(e);
            }
        }
        return queryNode;
    }

    private OrderQueryNode.OrderSpec createOrderSpec(SimpleNode node, OrderQueryNode queryNode) {
        SimpleNode child = (SimpleNode)node.jjtGetChild(0);
        OrderQueryNode.OrderSpec spec = null;
        try {
            String propName = child.getValue();
            if (child.getId() == 62) {
                propName.substring(0, propName.length() - 1);
            }
            QName name = ISO9075.decode(QName.fromJCRName(propName, this.resolver));
            spec = new OrderQueryNode.OrderSpec(name, true);
            queryNode.addOrderSpec(spec);
        }
        catch (IllegalNameException e) {
            this.exceptions.add(new InvalidQueryException("Illegal name: " + child.getValue()));
        }
        catch (UnknownPrefixException e) {
            this.exceptions.add(new InvalidQueryException("Unknown prefix: " + child.getValue()));
        }
        return spec;
    }

    private boolean isAttributeAxis(SimpleNode node) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (((SimpleNode)node.jjtGetChild(i)).getId() != 131) continue;
            return true;
        }
        return false;
    }

    private String unescapeQuotes(String literal) {
        String value = literal.substring(1, literal.length() - 1);
        if (value.length() == 0) {
            return value;
        }
        value = literal.charAt(0) == '\"' ? value.replaceAll("\"\"", "\"") : value.replaceAll("''", "'");
        return value;
    }
}

