/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.sql;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import javax.jcr.query.InvalidQueryException;
import org.apache.jackrabbit.core.query.AndQueryNode;
import org.apache.jackrabbit.core.query.DerefQueryNode;
import org.apache.jackrabbit.core.query.ExactQueryNode;
import org.apache.jackrabbit.core.query.LocationStepQueryNode;
import org.apache.jackrabbit.core.query.NodeTypeQueryNode;
import org.apache.jackrabbit.core.query.NotQueryNode;
import org.apache.jackrabbit.core.query.OrQueryNode;
import org.apache.jackrabbit.core.query.OrderQueryNode;
import org.apache.jackrabbit.core.query.PathQueryNode;
import org.apache.jackrabbit.core.query.QueryConstants;
import org.apache.jackrabbit.core.query.QueryNode;
import org.apache.jackrabbit.core.query.QueryNodeVisitor;
import org.apache.jackrabbit.core.query.QueryRootNode;
import org.apache.jackrabbit.core.query.RelationQueryNode;
import org.apache.jackrabbit.core.query.TextsearchQueryNode;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.util.ISO8601;

class QueryFormat
implements QueryNodeVisitor,
QueryConstants {
    private final NamespaceResolver resolver;
    private String statement;
    private List exceptions = new ArrayList();
    private List nodeTypes = new ArrayList();

    private QueryFormat(QueryRootNode root, NamespaceResolver resolver) throws InvalidQueryException {
        this.resolver = resolver;
        this.statement = root.accept(this, new StringBuffer()).toString();
        if (this.exceptions.size() > 0) {
            Exception e = (Exception)this.exceptions.get(0);
            throw new InvalidQueryException(e.getMessage(), (Throwable)e);
        }
    }

    public static String toString(QueryRootNode root, NamespaceResolver resolver) throws InvalidQueryException {
        return new QueryFormat(root, resolver).toString();
    }

    public String toString() {
        return this.statement;
    }

    public Object visit(QueryRootNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        try {
            sb.append("SELECT");
            QName[] selectProps = node.getSelectProperties();
            if (selectProps.length == 0) {
                sb.append(" *");
            } else {
                String comma = "";
                for (int i = 0; i < selectProps.length; ++i) {
                    sb.append(comma).append(" ");
                    QueryFormat.appendName(selectProps[i], this.resolver, sb);
                    comma = ",";
                }
            }
            sb.append(" FROM");
            StringBuffer tmp = new StringBuffer();
            LocationStepQueryNode[] steps = node.getLocationNode().getPathSteps();
            QueryNode[] predicates = steps[steps.length - 1].getPredicates();
            String and = "";
            for (int i = 0; i < predicates.length; ++i) {
                if (i == 0) {
                    tmp.append(" WHERE ");
                }
                tmp.append(and);
                predicates[i].accept(this, tmp);
                and = " AND ";
            }
            String comma = "";
            int ntCount = 0;
            Iterator it = this.nodeTypes.iterator();
            while (it.hasNext()) {
                QName nt = (QName)it.next();
                sb.append(comma).append(" ");
                QueryFormat.appendName(nt, this.resolver, sb);
                comma = ",";
                ++ntCount;
            }
            if (ntCount == 0) {
                sb.append(" ");
                sb.append(QName.NT_BASE.toJCRName(this.resolver));
            }
            sb.append(tmp.toString());
            if (steps.length != 2 || !steps[1].getIncludeDescendants() || steps[1].getNameTest() != null) {
                if (predicates.length > 0) {
                    sb.append(" AND ");
                } else {
                    sb.append(" WHERE ");
                }
                node.getLocationNode().accept(this, sb);
            }
        }
        catch (NoPrefixDeclaredException e) {
            this.exceptions.add(e);
        }
        if (node.getOrderNode() != null) {
            node.getOrderNode().accept(this, sb);
        }
        return sb;
    }

    public Object visit(OrQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        boolean bracket = false;
        if (node.getParent() instanceof LocationStepQueryNode || node.getParent() instanceof AndQueryNode || node.getParent() instanceof NotQueryNode) {
            bracket = true;
        }
        if (bracket) {
            sb.append("(");
        }
        String or = "";
        QueryNode[] operands = node.getOperands();
        for (int i = 0; i < operands.length; ++i) {
            sb.append(or);
            operands[i].accept(this, sb);
            or = " OR ";
        }
        if (bracket) {
            sb.append(")");
        }
        return sb;
    }

    public Object visit(AndQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        boolean bracket = false;
        if (node.getParent() instanceof NotQueryNode) {
            bracket = true;
        }
        if (bracket) {
            sb.append("(");
        }
        String and = "";
        QueryNode[] operands = node.getOperands();
        for (int i = 0; i < operands.length; ++i) {
            sb.append(and);
            int len = sb.length();
            operands[i].accept(this, sb);
            and = sb.length() - len > 0 ? " AND " : "";
        }
        if (bracket) {
            sb.append(")");
        }
        return sb;
    }

    public Object visit(NotQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        QueryNode[] operands = node.getOperands();
        if (operands.length > 0) {
            sb.append("NOT ");
            operands[0].accept(this, sb);
        }
        return sb;
    }

    public Object visit(ExactQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        try {
            QueryFormat.appendName(node.getPropertyName(), this.resolver, sb);
        }
        catch (NoPrefixDeclaredException e) {
            this.exceptions.add(e);
        }
        sb.append("='").append(node.getValue()).append("'");
        return sb;
    }

    public Object visit(NodeTypeQueryNode node, Object data) {
        this.nodeTypes.add(node.getValue());
        return data;
    }

    public Object visit(TextsearchQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        String query = node.getQuery().replaceAll("'", "''");
        sb.append("CONTAINS(");
        if (node.getPropertyName() == null) {
            sb.append("*");
        } else {
            try {
                QueryFormat.appendName(node.getPropertyName(), this.resolver, sb);
            }
            catch (NoPrefixDeclaredException e) {
                this.exceptions.add(e);
            }
        }
        sb.append(", '");
        sb.append(query).append("')");
        return sb;
    }

    public Object visit(PathQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        try {
            if (QueryFormat.containsDescendantOrSelf(node)) {
                int i;
                sb.append("(");
                sb.append(QName.JCR_PATH.toJCRName(this.resolver));
                sb.append(" LIKE '");
                LocationStepQueryNode[] steps = node.getPathSteps();
                for (i = 0; i < steps.length; ++i) {
                    if (steps[i].getNameTest() == null || steps[i].getNameTest().getLocalName().length() > 0) {
                        sb.append('/');
                    }
                    if (steps[i].getIncludeDescendants()) {
                        sb.append("%/");
                    }
                    steps[i].accept(this, sb);
                }
                sb.append('\'');
                sb.append(" OR ");
                sb.append(QName.JCR_PATH.toJCRName(this.resolver));
                sb.append(" LIKE '");
                for (i = 0; i < steps.length; ++i) {
                    if (steps[i].getNameTest() == null || steps[i].getNameTest().getLocalName().length() > 0) {
                        sb.append('/');
                    }
                    if (steps[i].getNameTest() == null) continue;
                    steps[i].accept(this, sb);
                }
                sb.append("')");
            } else if (QueryFormat.containsAllChildrenMatch(node)) {
                sb.append(QName.JCR_PATH.toJCRName(this.resolver));
                sb.append(" LIKE '");
                StringBuffer path = new StringBuffer();
                LocationStepQueryNode[] steps = node.getPathSteps();
                for (int i = 0; i < steps.length; ++i) {
                    if (steps[i].getNameTest() == null || steps[i].getNameTest().getLocalName().length() > 0) {
                        path.append('/');
                    }
                    steps[i].accept(this, path);
                }
                sb.append(path);
                sb.append('\'');
                sb.append(" AND NOT ");
                sb.append(QName.JCR_PATH.toJCRName(this.resolver));
                sb.append(" LIKE '");
                sb.append(path).append("/%").append('\'');
            } else {
                sb.append(QName.JCR_PATH.toJCRName(this.resolver));
                sb.append(" LIKE '");
                LocationStepQueryNode[] steps = node.getPathSteps();
                for (int i = 0; i < steps.length; ++i) {
                    if (steps[i].getNameTest() == null || steps[i].getNameTest().getLocalName().length() > 0) {
                        sb.append('/');
                    }
                    steps[i].accept(this, sb);
                }
                sb.append('\'');
            }
        }
        catch (NoPrefixDeclaredException e) {
            this.exceptions.add(e);
        }
        return sb;
    }

    public Object visit(LocationStepQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        if (node.getNameTest() == null) {
            sb.append("%");
        } else if (node.getNameTest().getLocalName().length() > 0) {
            try {
                sb.append(node.getNameTest().toJCRName(this.resolver));
            }
            catch (NoPrefixDeclaredException e) {
                this.exceptions.add(e);
            }
            if (node.getIndex() == -2147483647) {
                sb.append("[%]");
            } else if (node.getIndex() != 1) {
                sb.append('[').append(node.getIndex()).append(']');
            }
        }
        return sb;
    }

    public Object visit(DerefQueryNode node, Object data) {
        this.exceptions.add(new InvalidQueryException("jcr:deref() function not supported in SQL"));
        return data;
    }

    public Object visit(RelationQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        try {
            if (node.getOperation() == 11 || node.getOperation() == 12) {
                QueryFormat.appendName(node.getProperty(), this.resolver, sb);
                sb.append(" = ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 19 || node.getOperation() == 20) {
                QueryFormat.appendName(node.getProperty(), this.resolver, sb);
                sb.append(" >= ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 17 || node.getOperation() == 18) {
                QueryFormat.appendName(node.getProperty(), this.resolver, sb);
                sb.append(" > ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 21 || node.getOperation() == 22) {
                QueryFormat.appendName(node.getProperty(), this.resolver, sb);
                sb.append(" <= ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 23) {
                QueryFormat.appendName(node.getProperty(), this.resolver, sb);
                sb.append(" LIKE ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 15 || node.getOperation() == 16) {
                QueryFormat.appendName(node.getProperty(), this.resolver, sb);
                sb.append(" < ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 13 || node.getOperation() == 14) {
                QueryFormat.appendName(node.getProperty(), this.resolver, sb);
                sb.append(" <> ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 26) {
                QueryFormat.appendName(node.getProperty(), this.resolver, sb);
                sb.append(" IS NULL");
            } else if (node.getOperation() == 27) {
                QueryFormat.appendName(node.getProperty(), this.resolver, sb);
                sb.append(" IS NOT NULL");
            } else {
                this.exceptions.add(new InvalidQueryException("Invalid operation: " + node.getOperation()));
            }
            if (node.getOperation() == 23 && node.getStringValue().indexOf(92) > -1) {
                sb.append(" ESCAPE '\\'");
            }
        }
        catch (NoPrefixDeclaredException e) {
            this.exceptions.add(e);
        }
        return sb;
    }

    public Object visit(OrderQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        sb.append(" ORDER BY");
        OrderQueryNode.OrderSpec[] specs = node.getOrderSpecs();
        if (specs.length > 0) {
            try {
                String comma = "";
                for (int i = 0; i < specs.length; ++i) {
                    sb.append(comma).append(" ");
                    QueryFormat.appendName(specs[i].getProperty(), this.resolver, sb);
                    if (!specs[i].isAscending()) {
                        sb.append(" DESC");
                    }
                    comma = ",";
                }
            }
            catch (NoPrefixDeclaredException e) {
                this.exceptions.add(e);
            }
        } else {
            sb.append(" SCORE");
        }
        return sb;
    }

    private static void appendName(QName name, NamespaceResolver resolver, StringBuffer b) throws NoPrefixDeclaredException {
        boolean quote;
        boolean bl = quote = name.getLocalName().indexOf(32) > -1;
        if (quote) {
            b.append('\"');
        }
        b.append(name.toJCRName(resolver));
        if (quote) {
            b.append('\"');
        }
    }

    private void appendValue(RelationQueryNode node, StringBuffer b) {
        if (node.getValueType() == 1) {
            b.append(node.getLongValue());
        } else if (node.getValueType() == 2) {
            b.append(node.getDoubleValue());
        } else if (node.getValueType() == 3) {
            b.append("'").append(node.getStringValue().replaceAll("'", "''")).append("'");
        } else if (node.getValueType() == 4 || node.getValueType() == 5) {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            cal.setTime(node.getDateValue());
            b.append("TIMESTAMP '").append(ISO8601.format(cal)).append("'");
        } else {
            this.exceptions.add(new InvalidQueryException("Invalid type: " + node.getValueType()));
        }
    }

    private static boolean containsDescendantOrSelf(PathQueryNode path) {
        LocationStepQueryNode[] steps = path.getPathSteps();
        int count = 0;
        for (int i = 0; i < steps.length; ++i) {
            if (steps[i].getNameTest() == null || !steps[i].getIncludeDescendants()) continue;
            ++count;
        }
        return count == 1;
    }

    private static boolean containsAllChildrenMatch(PathQueryNode path) {
        LocationStepQueryNode[] steps = path.getPathSteps();
        int count = 0;
        for (int i = 0; i < steps.length; ++i) {
            if (steps[i].getNameTest() != null || steps[i].getIncludeDescendants()) continue;
            if (i == steps.length - 1 && count == 0) {
                return true;
            }
            ++count;
        }
        return false;
    }
}

