/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.fulltext;

import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.fulltext.CharStream;

public final class FastCharStream
implements CharStream {
    private int position;
    private int tokenStart;
    private String input;

    public FastCharStream(String input) {
        this.input = input;
    }

    public final char readChar() throws IOException {
        if (this.position >= this.input.length()) {
            throw new IOException("read past eof");
        }
        return this.input.charAt(this.position++);
    }

    public final char BeginToken() throws IOException {
        this.tokenStart = this.position;
        return this.readChar();
    }

    public final void backup(int amount) {
        this.position -= amount;
    }

    public final String GetImage() {
        return this.input.substring(this.tokenStart, this.position);
    }

    public final char[] GetSuffix(int len) {
        char[] value = new char[len];
        for (int i = 0; i < len; ++i) {
            value[i] = this.input.charAt(this.position - len + i);
        }
        return value;
    }

    public final void Done() {
    }

    public final int getColumn() {
        return this.position;
    }

    public final int getLine() {
        return 1;
    }

    public final int getEndColumn() {
        return this.position;
    }

    public final int getEndLine() {
        return 1;
    }

    public final int getBeginColumn() {
        return this.tokenStart;
    }

    public final int getBeginLine() {
        return 1;
    }
}

