/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.Arrays;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.query.lucene.ScoreNodeIterator;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;
import org.apache.jackrabbit.value.LongValue;
import org.apache.jackrabbit.value.PathValue;
import org.apache.jackrabbit.value.StringValue;

class RowIteratorImpl
implements RowIterator {
    private final ScoreNodeIterator nodes;
    private final QName[] properties;
    private final NamespaceResolver resolver;

    RowIteratorImpl(ScoreNodeIterator nodes, QName[] properties, NamespaceResolver resolver) {
        this.nodes = nodes;
        this.properties = properties;
        this.resolver = resolver;
    }

    public Row nextRow() throws NoSuchElementException {
        return new RowImpl(this.nodes.getScore(), this.nodes.nextNodeImpl());
    }

    public void skip(long skipNum) throws NoSuchElementException {
        this.nodes.skip(skipNum);
    }

    public long getSize() {
        return this.nodes.getSize();
    }

    public long getPosition() {
        return this.nodes.getPosition();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public boolean hasNext() {
        return this.nodes.hasNext();
    }

    public Object next() throws NoSuchElementException {
        return this.nextRow();
    }

    class RowImpl
    implements Row {
        private final float score;
        private final NodeImpl node;
        private Value[] values;
        private Set propertySet;

        RowImpl(float score, NodeImpl node) {
            this.score = score;
            this.node = node;
        }

        public Value[] getValues() throws RepositoryException {
            if (this.values == null) {
                Value[] tmp = new Value[RowIteratorImpl.this.properties.length];
                for (int i = 0; i < RowIteratorImpl.this.properties.length; ++i) {
                    if (this.node.hasProperty(RowIteratorImpl.this.properties[i])) {
                        PropertyImpl prop = this.node.getProperty(RowIteratorImpl.this.properties[i]);
                        if (!prop.getDefinition().isMultiple()) {
                            if (prop.getDefinition().getRequiredType() == 0) {
                                tmp[i] = new StringValue(prop.getString());
                                continue;
                            }
                            tmp[i] = prop.getValue();
                            continue;
                        }
                        tmp[i] = null;
                        continue;
                    }
                    tmp[i] = QName.JCR_PATH.equals(RowIteratorImpl.this.properties[i]) ? PathValue.valueOf(this.node.getPath()) : (QName.JCR_SCORE.equals(RowIteratorImpl.this.properties[i]) ? new LongValue((long)((int)(this.score * 1000.0f))) : null);
                }
                this.values = tmp;
            }
            Value[] ret = new Value[this.values.length];
            System.arraycopy(this.values, 0, ret, 0, this.values.length);
            return ret;
        }

        public Value getValue(String propertyName) throws ItemNotFoundException, RepositoryException {
            if (this.propertySet == null) {
                HashSet<QName> tmp = new HashSet<QName>();
                tmp.addAll(Arrays.asList(RowIteratorImpl.this.properties));
                this.propertySet = tmp;
            }
            try {
                QName prop = QName.fromJCRName(propertyName, RowIteratorImpl.this.resolver);
                if (!this.propertySet.contains(prop)) {
                    throw new ItemNotFoundException(propertyName);
                }
                if (this.node.hasProperty(prop)) {
                    PropertyImpl p = this.node.getProperty(prop);
                    if (p.getDefinition().getRequiredType() == 0) {
                        return new StringValue(p.getString());
                    }
                    return p.getValue();
                }
                if (QName.JCR_PATH.equals(prop)) {
                    return PathValue.valueOf(this.node.getPath());
                }
                if (QName.JCR_SCORE.equals(prop)) {
                    return new LongValue((long)((int)(this.score * 1000.0f)));
                }
                return null;
            }
            catch (IllegalNameException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
            catch (UnknownPrefixException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

