/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.core.query.DefaultQueryNodeVisitor;
import org.apache.jackrabbit.core.query.ExecutableQuery;
import org.apache.jackrabbit.core.query.LocationStepQueryNode;
import org.apache.jackrabbit.core.query.NodeTypeQueryNode;
import org.apache.jackrabbit.core.query.OrderQueryNode;
import org.apache.jackrabbit.core.query.PathQueryNode;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.QueryParser;
import org.apache.jackrabbit.core.query.QueryRootNode;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryBuilder;
import org.apache.jackrabbit.core.query.lucene.QueryHits;
import org.apache.jackrabbit.core.query.lucene.QueryResultImpl;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.WorkspaceTraversalResult;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.name.QName;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
implements ExecutableQuery {
    private static final Logger log = LoggerFactory.getLogger((Class)QueryImpl.class);
    protected static final QueryRootNode ALL_NODES = new QueryRootNode();
    protected final QueryRootNode root;
    protected final SessionImpl session;
    protected final ItemManager itemMgr;
    protected final SearchIndex index;
    protected final PropertyTypeRegistry propReg;
    private boolean documentOrder = true;

    public QueryImpl(SessionImpl session, ItemManager itemMgr, SearchIndex index, PropertyTypeRegistry propReg, String statement, String language) throws InvalidQueryException {
        this.session = session;
        this.itemMgr = itemMgr;
        this.index = index;
        this.propReg = propReg;
        this.root = QueryParser.parse(statement, language, session.getNamespaceResolver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QueryResult execute() throws RepositoryException {
        void var7_10;
        void var6_7;
        if (log.isDebugEnabled()) {
            log.debug("Executing query: \n" + this.root.dump());
        }
        if (ALL_NODES.equals(this.root)) {
            return new WorkspaceTraversalResult(this.session, new QName[]{QName.JCR_PRIMARYTYPE, QName.JCR_PATH, QName.JCR_SCORE}, this.session.getNamespaceResolver());
        }
        Query query = LuceneQueryBuilder.createQuery(this.root, this.session, this.index.getContext().getItemStateManager(), this.index.getNamespaceMappings(), this.index.getTextAnalyzer(), this.propReg);
        OrderQueryNode orderNode = this.root.getOrderNode();
        OrderQueryNode.OrderSpec[] orderSpecs = orderNode != null ? orderNode.getOrderSpecs() : new OrderQueryNode.OrderSpec[]{};
        QName[] orderProperties = new QName[orderSpecs.length];
        boolean[] ascSpecs = new boolean[orderSpecs.length];
        for (int i = 0; i < orderSpecs.length; ++i) {
            orderProperties[i] = orderSpecs[i].getProperty();
            ascSpecs[i] = orderSpecs[i].isAscending();
        }
        AccessManager accessMgr = this.session.getAccessManager();
        QueryHits result = null;
        result = this.index.executeQuery(this, query, orderProperties, ascSpecs);
        ArrayList<NodeId> ids = new ArrayList<NodeId>(result.length());
        ArrayList<Float> scores = new ArrayList<Float>(result.length());
        for (int i = 0; i < result.length(); ++i) {
            NodeId id = NodeId.valueOf(result.doc(i).get(FieldNames.UUID));
            if (!accessMgr.isGranted(id, 1)) continue;
            ids.add(id);
            scores.add(new Float(result.score(i)));
        }
        Object var13_14 = null;
        if (result == null) return new QueryResultImpl(this.itemMgr, var6_7.toArray(new NodeId[var6_7.size()]), var7_10.toArray(new Float[var7_10.size()]), this.getSelectProperties(), this.session.getNamespaceResolver(), orderNode == null && this.documentOrder);
        try {
            result.close();
            return new QueryResultImpl(this.itemMgr, var6_7.toArray(new NodeId[var6_7.size()]), var7_10.toArray(new Float[var7_10.size()]), this.getSelectProperties(), this.session.getNamespaceResolver(), orderNode == null && this.documentOrder);
        }
        catch (IOException e2) {
            log.warn("Unable to close query result: " + e2);
        }
        return new QueryResultImpl(this.itemMgr, var6_7.toArray(new NodeId[var6_7.size()]), var7_10.toArray(new Float[var7_10.size()]), this.getSelectProperties(), this.session.getNamespaceResolver(), orderNode == null && this.documentOrder);
        {
            catch (IOException e) {
                log.error("Exception while executing query: ", (Throwable)e);
                ids = Collections.EMPTY_LIST;
                scores = Collections.EMPTY_LIST;
                Object var13_15 = null;
                if (result == null) return new QueryResultImpl(this.itemMgr, var6_7.toArray(new NodeId[var6_7.size()]), var7_10.toArray(new Float[var7_10.size()]), this.getSelectProperties(), this.session.getNamespaceResolver(), orderNode == null && this.documentOrder);
                try {
                    result.close();
                    return new QueryResultImpl(this.itemMgr, var6_7.toArray(new NodeId[var6_7.size()]), var7_10.toArray(new Float[var7_10.size()]), this.getSelectProperties(), this.session.getNamespaceResolver(), orderNode == null && this.documentOrder);
                }
                catch (IOException e2) {
                    log.warn("Unable to close query result: " + e2);
                }
                return new QueryResultImpl(this.itemMgr, var6_7.toArray(new NodeId[var6_7.size()]), var7_10.toArray(new Float[var7_10.size()]), this.getSelectProperties(), this.session.getNamespaceResolver(), orderNode == null && this.documentOrder);
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (result == null) throw throwable;
            try {
                result.close();
                throw throwable;
            }
            catch (IOException e2) {
                log.warn("Unable to close query result: " + e2);
            }
            throw throwable;
        }
    }

    public boolean getRespectDocumentOrder() {
        return this.documentOrder;
    }

    public void setRespectDocumentOrder(boolean documentOrder) {
        this.documentOrder = documentOrder;
    }

    protected QName[] getSelectProperties() throws RepositoryException {
        ArrayList<QName> selectProps = new ArrayList<QName>();
        selectProps.addAll(Arrays.asList(this.root.getSelectProperties()));
        if (selectProps.size() == 0) {
            LocationStepQueryNode[] steps = this.root.getLocationNode().getPathSteps();
            final QName[] ntName = new QName[1];
            steps[steps.length - 1].acceptOperands(new DefaultQueryNodeVisitor(){

                public Object visit(NodeTypeQueryNode node, Object data) {
                    ntName[0] = node.getValue();
                    return data;
                }
            }, null);
            if (ntName[0] == null) {
                ntName[0] = QName.NT_BASE;
            }
            NodeTypeImpl nt = this.session.getNodeTypeManager().getNodeType(ntName[0]);
            PropertyDefinition[] propDefs = nt.getPropertyDefinitions();
            for (int i = 0; i < propDefs.length; ++i) {
                PropertyDefinitionImpl propDef = (PropertyDefinitionImpl)propDefs[i];
                if (propDef.definesResidual() || propDef.isMultiple()) continue;
                selectProps.add(propDef.getQName());
            }
        }
        if (!selectProps.contains(QName.JCR_PATH)) {
            selectProps.add(QName.JCR_PATH);
        }
        if (!selectProps.contains(QName.JCR_SCORE)) {
            selectProps.add(QName.JCR_SCORE);
        }
        return selectProps.toArray(new QName[selectProps.size()]);
    }

    static {
        PathQueryNode pathNode = new PathQueryNode(ALL_NODES);
        pathNode.addPathStep(new LocationStepQueryNode(pathNode, null, true));
        pathNode.setAbsolute(true);
        ALL_NODES.setLocationNode(pathNode);
    }
}

