/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.query.lucene.ScoreNodeIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeIteratorImpl
implements ScoreNodeIterator {
    private static final Logger log = LoggerFactory.getLogger((Class)NodeIteratorImpl.class);
    protected final NodeId[] ids;
    protected final Float[] scores;
    protected final ItemManager itemMgr;
    protected int pos = -1;
    protected int invalid = 0;
    private NodeImpl next;

    NodeIteratorImpl(ItemManager itemMgr, NodeId[] ids, Float[] scores) {
        this.itemMgr = itemMgr;
        this.ids = ids;
        this.scores = scores;
        this.fetchNext();
    }

    public Node nextNode() throws NoSuchElementException {
        return this.nextNodeImpl();
    }

    public Object next() throws NoSuchElementException {
        return this.nextNode();
    }

    public NodeImpl nextNodeImpl() throws NoSuchElementException {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        NodeImpl n = this.next;
        this.fetchNext();
        return n;
    }

    public void skip(long skipNum) throws NoSuchElementException {
        if (skipNum < 0L) {
            throw new IllegalArgumentException("skipNum must not be negative");
        }
        if ((long)this.pos + skipNum > (long)this.ids.length) {
            throw new NoSuchElementException();
        }
        if (skipNum != 0L) {
            this.pos = (int)((long)this.pos + (skipNum - 1L));
            this.fetchNext();
        }
    }

    public long getSize() {
        return this.ids.length - this.invalid;
    }

    public long getPosition() {
        return this.pos - this.invalid;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public float getScore() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.scores[this.pos].floatValue();
    }

    protected void fetchNext() {
        this.next = null;
        while (this.next == null && this.pos + 1 < this.ids.length) {
            try {
                this.next = (NodeImpl)this.itemMgr.getItem(this.ids[this.pos + 1]);
            }
            catch (RepositoryException e) {
                log.warn("Exception retrieving Node with UUID: " + this.ids[this.pos + 1] + ": " + e.toString());
                ++this.invalid;
                ++this.pos;
            }
        }
        ++this.pos;
    }
}

