/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import org.apache.commons.collections.map.LRUMap;
import org.apache.jackrabbit.core.query.lucene.CachingIndexReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DocNumberCache {
    private static final Logger log = LoggerFactory.getLogger((Class)DocNumberCache.class);
    private static final long LOG_INTERVAL = 10000L;
    private static final int CACHE_SEGMENTS = 16;
    private static final int CACHE_SEGMENTS_MASK = 15;
    private final LRUMap[] docNumbers = new LRUMap[16];
    private long lastLog;
    private long misses;
    private long accesses;

    DocNumberCache(int size) {
        if ((size %= 16) < 64) {
            size = 64;
        }
        for (int i = 0; i < this.docNumbers.length; ++i) {
            this.docNumbers[i] = new LRUMap(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(String uuid, CachingIndexReader reader, int n) {
        LRUMap cacheSegment;
        LRUMap lRUMap = cacheSegment = this.docNumbers[DocNumberCache.getSegmentIndex(uuid.charAt(0))];
        synchronized (lRUMap) {
            Entry e = (Entry)cacheSegment.get((Object)uuid);
            if (e != null) {
                if (reader.getCreationTick() <= e.reader.getCreationTick()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Ignoring put(). New entry is not from a newer reader. existing: " + e.reader.getCreationTick() + ", new: " + reader.getCreationTick());
                    }
                    e = null;
                }
            } else {
                e = new Entry(reader, n);
            }
            if (e != null) {
                cacheSegment.put((Object)uuid, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Entry get(String uuid) {
        Entry entry;
        LRUMap cacheSegment;
        LRUMap lRUMap = cacheSegment = this.docNumbers[DocNumberCache.getSegmentIndex(uuid.charAt(0))];
        synchronized (lRUMap) {
            entry = (Entry)cacheSegment.get((Object)uuid);
        }
        if (log.isInfoEnabled()) {
            ++this.accesses;
            if (entry == null) {
                ++this.misses;
            }
            if (this.accesses > 1000L && System.currentTimeMillis() - this.lastLog > 10000L) {
                long ratio = 100L;
                if (this.misses != 0L) {
                    ratio -= this.misses * 100L / this.accesses;
                }
                StringBuffer statistics = new StringBuffer();
                int inUse = 0;
                for (int i = 0; i < this.docNumbers.length; ++i) {
                    inUse += this.docNumbers[i].size();
                }
                statistics.append("size=").append(inUse);
                statistics.append("/").append(this.docNumbers[0].maxSize() * 16);
                statistics.append(", #accesses=").append(this.accesses);
                statistics.append(", #hits=").append(this.accesses - this.misses);
                statistics.append(", #misses=").append(this.misses);
                statistics.append(", cacheRatio=").append(ratio).append("%");
                log.info(statistics.toString());
                this.accesses = 0L;
                this.misses = 0L;
                this.lastLog = System.currentTimeMillis();
            }
        }
        return entry;
    }

    private static final int getSegmentIndex(char c) {
        if (c > '9') {
            c = (char)(c + 9);
        }
        return c & 0xF;
    }

    public static final class Entry {
        final CachingIndexReader reader;
        final int doc;

        Entry(CachingIndexReader reader, int doc) {
            this.reader = reader;
            this.doc = doc;
        }
    }
}

